/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the counts of open tasks, child workflow executions and timers for a workflow execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowExecutionOpenCounts implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkflowExecutionOpenCounts.Builder, WorkflowExecutionOpenCounts> {
    private static final SdkField<Integer> OPEN_ACTIVITY_TASKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("openActivityTasks").getter(getter(WorkflowExecutionOpenCounts::openActivityTasks))
            .setter(setter(Builder::openActivityTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openActivityTasks").build()).build();

    private static final SdkField<Integer> OPEN_DECISION_TASKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("openDecisionTasks").getter(getter(WorkflowExecutionOpenCounts::openDecisionTasks))
            .setter(setter(Builder::openDecisionTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openDecisionTasks").build()).build();

    private static final SdkField<Integer> OPEN_TIMERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("openTimers").getter(getter(WorkflowExecutionOpenCounts::openTimers)).setter(setter(Builder::openTimers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openTimers").build()).build();

    private static final SdkField<Integer> OPEN_CHILD_WORKFLOW_EXECUTIONS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("openChildWorkflowExecutions")
            .getter(getter(WorkflowExecutionOpenCounts::openChildWorkflowExecutions))
            .setter(setter(Builder::openChildWorkflowExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openChildWorkflowExecutions")
                    .build()).build();

    private static final SdkField<Integer> OPEN_LAMBDA_FUNCTIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("openLambdaFunctions").getter(getter(WorkflowExecutionOpenCounts::openLambdaFunctions))
            .setter(setter(Builder::openLambdaFunctions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openLambdaFunctions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPEN_ACTIVITY_TASKS_FIELD,
            OPEN_DECISION_TASKS_FIELD, OPEN_TIMERS_FIELD, OPEN_CHILD_WORKFLOW_EXECUTIONS_FIELD, OPEN_LAMBDA_FUNCTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer openActivityTasks;

    private final Integer openDecisionTasks;

    private final Integer openTimers;

    private final Integer openChildWorkflowExecutions;

    private final Integer openLambdaFunctions;

    private WorkflowExecutionOpenCounts(BuilderImpl builder) {
        this.openActivityTasks = builder.openActivityTasks;
        this.openDecisionTasks = builder.openDecisionTasks;
        this.openTimers = builder.openTimers;
        this.openChildWorkflowExecutions = builder.openChildWorkflowExecutions;
        this.openLambdaFunctions = builder.openLambdaFunctions;
    }

    /**
     * <p>
     * The count of activity tasks whose status is <code>OPEN</code>.
     * </p>
     * 
     * @return The count of activity tasks whose status is <code>OPEN</code>.
     */
    public final Integer openActivityTasks() {
        return openActivityTasks;
    }

    /**
     * <p>
     * The count of decision tasks whose status is OPEN. A workflow execution can have at most one open decision task.
     * </p>
     * 
     * @return The count of decision tasks whose status is OPEN. A workflow execution can have at most one open decision
     *         task.
     */
    public final Integer openDecisionTasks() {
        return openDecisionTasks;
    }

    /**
     * <p>
     * The count of timers started by this workflow execution that have not fired yet.
     * </p>
     * 
     * @return The count of timers started by this workflow execution that have not fired yet.
     */
    public final Integer openTimers() {
        return openTimers;
    }

    /**
     * <p>
     * The count of child workflow executions whose status is <code>OPEN</code>.
     * </p>
     * 
     * @return The count of child workflow executions whose status is <code>OPEN</code>.
     */
    public final Integer openChildWorkflowExecutions() {
        return openChildWorkflowExecutions;
    }

    /**
     * <p>
     * The count of Lambda tasks whose status is <code>OPEN</code>.
     * </p>
     * 
     * @return The count of Lambda tasks whose status is <code>OPEN</code>.
     */
    public final Integer openLambdaFunctions() {
        return openLambdaFunctions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(openActivityTasks());
        hashCode = 31 * hashCode + Objects.hashCode(openDecisionTasks());
        hashCode = 31 * hashCode + Objects.hashCode(openTimers());
        hashCode = 31 * hashCode + Objects.hashCode(openChildWorkflowExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(openLambdaFunctions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionOpenCounts)) {
            return false;
        }
        WorkflowExecutionOpenCounts other = (WorkflowExecutionOpenCounts) obj;
        return Objects.equals(openActivityTasks(), other.openActivityTasks())
                && Objects.equals(openDecisionTasks(), other.openDecisionTasks())
                && Objects.equals(openTimers(), other.openTimers())
                && Objects.equals(openChildWorkflowExecutions(), other.openChildWorkflowExecutions())
                && Objects.equals(openLambdaFunctions(), other.openLambdaFunctions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowExecutionOpenCounts").add("OpenActivityTasks", openActivityTasks())
                .add("OpenDecisionTasks", openDecisionTasks()).add("OpenTimers", openTimers())
                .add("OpenChildWorkflowExecutions", openChildWorkflowExecutions())
                .add("OpenLambdaFunctions", openLambdaFunctions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "openActivityTasks":
            return Optional.ofNullable(clazz.cast(openActivityTasks()));
        case "openDecisionTasks":
            return Optional.ofNullable(clazz.cast(openDecisionTasks()));
        case "openTimers":
            return Optional.ofNullable(clazz.cast(openTimers()));
        case "openChildWorkflowExecutions":
            return Optional.ofNullable(clazz.cast(openChildWorkflowExecutions()));
        case "openLambdaFunctions":
            return Optional.ofNullable(clazz.cast(openLambdaFunctions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("openActivityTasks", OPEN_ACTIVITY_TASKS_FIELD);
        map.put("openDecisionTasks", OPEN_DECISION_TASKS_FIELD);
        map.put("openTimers", OPEN_TIMERS_FIELD);
        map.put("openChildWorkflowExecutions", OPEN_CHILD_WORKFLOW_EXECUTIONS_FIELD);
        map.put("openLambdaFunctions", OPEN_LAMBDA_FUNCTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkflowExecutionOpenCounts, T> g) {
        return obj -> g.apply((WorkflowExecutionOpenCounts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowExecutionOpenCounts> {
        /**
         * <p>
         * The count of activity tasks whose status is <code>OPEN</code>.
         * </p>
         * 
         * @param openActivityTasks
         *        The count of activity tasks whose status is <code>OPEN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openActivityTasks(Integer openActivityTasks);

        /**
         * <p>
         * The count of decision tasks whose status is OPEN. A workflow execution can have at most one open decision
         * task.
         * </p>
         * 
         * @param openDecisionTasks
         *        The count of decision tasks whose status is OPEN. A workflow execution can have at most one open
         *        decision task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openDecisionTasks(Integer openDecisionTasks);

        /**
         * <p>
         * The count of timers started by this workflow execution that have not fired yet.
         * </p>
         * 
         * @param openTimers
         *        The count of timers started by this workflow execution that have not fired yet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openTimers(Integer openTimers);

        /**
         * <p>
         * The count of child workflow executions whose status is <code>OPEN</code>.
         * </p>
         * 
         * @param openChildWorkflowExecutions
         *        The count of child workflow executions whose status is <code>OPEN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openChildWorkflowExecutions(Integer openChildWorkflowExecutions);

        /**
         * <p>
         * The count of Lambda tasks whose status is <code>OPEN</code>.
         * </p>
         * 
         * @param openLambdaFunctions
         *        The count of Lambda tasks whose status is <code>OPEN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openLambdaFunctions(Integer openLambdaFunctions);
    }

    static final class BuilderImpl implements Builder {
        private Integer openActivityTasks;

        private Integer openDecisionTasks;

        private Integer openTimers;

        private Integer openChildWorkflowExecutions;

        private Integer openLambdaFunctions;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionOpenCounts model) {
            openActivityTasks(model.openActivityTasks);
            openDecisionTasks(model.openDecisionTasks);
            openTimers(model.openTimers);
            openChildWorkflowExecutions(model.openChildWorkflowExecutions);
            openLambdaFunctions(model.openLambdaFunctions);
        }

        public final Integer getOpenActivityTasks() {
            return openActivityTasks;
        }

        public final void setOpenActivityTasks(Integer openActivityTasks) {
            this.openActivityTasks = openActivityTasks;
        }

        @Override
        public final Builder openActivityTasks(Integer openActivityTasks) {
            this.openActivityTasks = openActivityTasks;
            return this;
        }

        public final Integer getOpenDecisionTasks() {
            return openDecisionTasks;
        }

        public final void setOpenDecisionTasks(Integer openDecisionTasks) {
            this.openDecisionTasks = openDecisionTasks;
        }

        @Override
        public final Builder openDecisionTasks(Integer openDecisionTasks) {
            this.openDecisionTasks = openDecisionTasks;
            return this;
        }

        public final Integer getOpenTimers() {
            return openTimers;
        }

        public final void setOpenTimers(Integer openTimers) {
            this.openTimers = openTimers;
        }

        @Override
        public final Builder openTimers(Integer openTimers) {
            this.openTimers = openTimers;
            return this;
        }

        public final Integer getOpenChildWorkflowExecutions() {
            return openChildWorkflowExecutions;
        }

        public final void setOpenChildWorkflowExecutions(Integer openChildWorkflowExecutions) {
            this.openChildWorkflowExecutions = openChildWorkflowExecutions;
        }

        @Override
        public final Builder openChildWorkflowExecutions(Integer openChildWorkflowExecutions) {
            this.openChildWorkflowExecutions = openChildWorkflowExecutions;
            return this;
        }

        public final Integer getOpenLambdaFunctions() {
            return openLambdaFunctions;
        }

        public final void setOpenLambdaFunctions(Integer openLambdaFunctions) {
            this.openLambdaFunctions = openLambdaFunctions;
        }

        @Override
        public final Builder openLambdaFunctions(Integer openLambdaFunctions) {
            this.openLambdaFunctions = openLambdaFunctions;
            return this;
        }

        @Override
        public WorkflowExecutionOpenCounts build() {
            return new WorkflowExecutionOpenCounts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
