/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.ExecutionTimeFilter;
import software.amazon.awssdk.services.swf.model.SwfRequest;
import software.amazon.awssdk.services.swf.model.TagFilter;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionFilter;
import software.amazon.awssdk.services.swf.model.WorkflowTypeFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CountOpenWorkflowExecutionsRequest
extends SwfRequest
implements ToCopyableBuilder<Builder, CountOpenWorkflowExecutionsRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(CountOpenWorkflowExecutionsRequest.getter(CountOpenWorkflowExecutionsRequest::domain)).setter(CountOpenWorkflowExecutionsRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()}).build();
    private static final SdkField<ExecutionTimeFilter> START_TIME_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("startTimeFilter").getter(CountOpenWorkflowExecutionsRequest.getter(CountOpenWorkflowExecutionsRequest::startTimeFilter)).setter(CountOpenWorkflowExecutionsRequest.setter(Builder::startTimeFilter)).constructor(ExecutionTimeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeFilter").build()}).build();
    private static final SdkField<WorkflowTypeFilter> TYPE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("typeFilter").getter(CountOpenWorkflowExecutionsRequest.getter(CountOpenWorkflowExecutionsRequest::typeFilter)).setter(CountOpenWorkflowExecutionsRequest.setter(Builder::typeFilter)).constructor(WorkflowTypeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeFilter").build()}).build();
    private static final SdkField<TagFilter> TAG_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tagFilter").getter(CountOpenWorkflowExecutionsRequest.getter(CountOpenWorkflowExecutionsRequest::tagFilter)).setter(CountOpenWorkflowExecutionsRequest.setter(Builder::tagFilter)).constructor(TagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilter").build()}).build();
    private static final SdkField<WorkflowExecutionFilter> EXECUTION_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("executionFilter").getter(CountOpenWorkflowExecutionsRequest.getter(CountOpenWorkflowExecutionsRequest::executionFilter)).setter(CountOpenWorkflowExecutionsRequest.setter(Builder::executionFilter)).constructor(WorkflowExecutionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, START_TIME_FILTER_FIELD, TYPE_FILTER_FIELD, TAG_FILTER_FIELD, EXECUTION_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CountOpenWorkflowExecutionsRequest.memberNameToFieldInitializer();
    private final String domain;
    private final ExecutionTimeFilter startTimeFilter;
    private final WorkflowTypeFilter typeFilter;
    private final TagFilter tagFilter;
    private final WorkflowExecutionFilter executionFilter;

    private CountOpenWorkflowExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.startTimeFilter = builder.startTimeFilter;
        this.typeFilter = builder.typeFilter;
        this.tagFilter = builder.tagFilter;
        this.executionFilter = builder.executionFilter;
    }

    public final String domain() {
        return this.domain;
    }

    public final ExecutionTimeFilter startTimeFilter() {
        return this.startTimeFilter;
    }

    public final WorkflowTypeFilter typeFilter() {
        return this.typeFilter;
    }

    public final TagFilter tagFilter() {
        return this.tagFilter;
    }

    public final WorkflowExecutionFilter executionFilter() {
        return this.executionFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CountOpenWorkflowExecutionsRequest)) {
            return false;
        }
        CountOpenWorkflowExecutionsRequest other = (CountOpenWorkflowExecutionsRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.startTimeFilter(), other.startTimeFilter()) && Objects.equals(this.typeFilter(), other.typeFilter()) && Objects.equals(this.tagFilter(), other.tagFilter()) && Objects.equals(this.executionFilter(), other.executionFilter());
    }

    public final String toString() {
        return ToString.builder((String)"CountOpenWorkflowExecutionsRequest").add("Domain", (Object)this.domain()).add("StartTimeFilter", (Object)this.startTimeFilter()).add("TypeFilter", (Object)this.typeFilter()).add("TagFilter", (Object)this.tagFilter()).add("ExecutionFilter", (Object)this.executionFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "startTimeFilter": {
                return Optional.ofNullable(clazz.cast(this.startTimeFilter()));
            }
            case "typeFilter": {
                return Optional.ofNullable(clazz.cast(this.typeFilter()));
            }
            case "tagFilter": {
                return Optional.ofNullable(clazz.cast(this.tagFilter()));
            }
            case "executionFilter": {
                return Optional.ofNullable(clazz.cast(this.executionFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domain", DOMAIN_FIELD);
        map.put("startTimeFilter", START_TIME_FILTER_FIELD);
        map.put("typeFilter", TYPE_FILTER_FIELD);
        map.put("tagFilter", TAG_FILTER_FIELD);
        map.put("executionFilter", EXECUTION_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CountOpenWorkflowExecutionsRequest, T> g) {
        return obj -> g.apply((CountOpenWorkflowExecutionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfRequest.BuilderImpl
    implements Builder {
        private String domain;
        private ExecutionTimeFilter startTimeFilter;
        private WorkflowTypeFilter typeFilter;
        private TagFilter tagFilter;
        private WorkflowExecutionFilter executionFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(CountOpenWorkflowExecutionsRequest model) {
            super(model);
            this.domain(model.domain);
            this.startTimeFilter(model.startTimeFilter);
            this.typeFilter(model.typeFilter);
            this.tagFilter(model.tagFilter);
            this.executionFilter(model.executionFilter);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final ExecutionTimeFilter.Builder getStartTimeFilter() {
            return this.startTimeFilter != null ? this.startTimeFilter.toBuilder() : null;
        }

        public final void setStartTimeFilter(ExecutionTimeFilter.BuilderImpl startTimeFilter) {
            this.startTimeFilter = startTimeFilter != null ? startTimeFilter.build() : null;
        }

        @Override
        public final Builder startTimeFilter(ExecutionTimeFilter startTimeFilter) {
            this.startTimeFilter = startTimeFilter;
            return this;
        }

        public final WorkflowTypeFilter.Builder getTypeFilter() {
            return this.typeFilter != null ? this.typeFilter.toBuilder() : null;
        }

        public final void setTypeFilter(WorkflowTypeFilter.BuilderImpl typeFilter) {
            this.typeFilter = typeFilter != null ? typeFilter.build() : null;
        }

        @Override
        public final Builder typeFilter(WorkflowTypeFilter typeFilter) {
            this.typeFilter = typeFilter;
            return this;
        }

        public final TagFilter.Builder getTagFilter() {
            return this.tagFilter != null ? this.tagFilter.toBuilder() : null;
        }

        public final void setTagFilter(TagFilter.BuilderImpl tagFilter) {
            this.tagFilter = tagFilter != null ? tagFilter.build() : null;
        }

        @Override
        public final Builder tagFilter(TagFilter tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }

        public final WorkflowExecutionFilter.Builder getExecutionFilter() {
            return this.executionFilter != null ? this.executionFilter.toBuilder() : null;
        }

        public final void setExecutionFilter(WorkflowExecutionFilter.BuilderImpl executionFilter) {
            this.executionFilter = executionFilter != null ? executionFilter.build() : null;
        }

        @Override
        public final Builder executionFilter(WorkflowExecutionFilter executionFilter) {
            this.executionFilter = executionFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CountOpenWorkflowExecutionsRequest build() {
            return new CountOpenWorkflowExecutionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SwfRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CountOpenWorkflowExecutionsRequest> {
        public Builder domain(String var1);

        public Builder startTimeFilter(ExecutionTimeFilter var1);

        default public Builder startTimeFilter(Consumer<ExecutionTimeFilter.Builder> startTimeFilter) {
            return this.startTimeFilter((ExecutionTimeFilter)((ExecutionTimeFilter.Builder)ExecutionTimeFilter.builder().applyMutation(startTimeFilter)).build());
        }

        public Builder typeFilter(WorkflowTypeFilter var1);

        default public Builder typeFilter(Consumer<WorkflowTypeFilter.Builder> typeFilter) {
            return this.typeFilter((WorkflowTypeFilter)((WorkflowTypeFilter.Builder)WorkflowTypeFilter.builder().applyMutation(typeFilter)).build());
        }

        public Builder tagFilter(TagFilter var1);

        default public Builder tagFilter(Consumer<TagFilter.Builder> tagFilter) {
            return this.tagFilter((TagFilter)((TagFilter.Builder)TagFilter.builder().applyMutation(tagFilter)).build());
        }

        public Builder executionFilter(WorkflowExecutionFilter var1);

        default public Builder executionFilter(Consumer<WorkflowExecutionFilter.Builder> executionFilter) {
            return this.executionFilter((WorkflowExecutionFilter)((WorkflowExecutionFilter.Builder)WorkflowExecutionFilter.builder().applyMutation(executionFilter)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

