/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.SwfRequest;
import software.amazon.awssdk.services.swf.model.TaskList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PollForActivityTaskRequest
extends SwfRequest
implements ToCopyableBuilder<Builder, PollForActivityTaskRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(PollForActivityTaskRequest.getter(PollForActivityTaskRequest::domain)).setter(PollForActivityTaskRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()}).build();
    private static final SdkField<TaskList> TASK_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("taskList").getter(PollForActivityTaskRequest.getter(PollForActivityTaskRequest::taskList)).setter(PollForActivityTaskRequest.setter(Builder::taskList)).constructor(TaskList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskList").build()}).build();
    private static final SdkField<String> IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identity").getter(PollForActivityTaskRequest.getter(PollForActivityTaskRequest::identity)).setter(PollForActivityTaskRequest.setter(Builder::identity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, TASK_LIST_FIELD, IDENTITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PollForActivityTaskRequest.memberNameToFieldInitializer();
    private final String domain;
    private final TaskList taskList;
    private final String identity;

    private PollForActivityTaskRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.taskList = builder.taskList;
        this.identity = builder.identity;
    }

    public final String domain() {
        return this.domain;
    }

    public final TaskList taskList() {
        return this.taskList;
    }

    public final String identity() {
        return this.identity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskList());
        hashCode = 31 * hashCode + Objects.hashCode(this.identity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForActivityTaskRequest)) {
            return false;
        }
        PollForActivityTaskRequest other = (PollForActivityTaskRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.taskList(), other.taskList()) && Objects.equals(this.identity(), other.identity());
    }

    public final String toString() {
        return ToString.builder((String)"PollForActivityTaskRequest").add("Domain", (Object)this.domain()).add("TaskList", (Object)this.taskList()).add("Identity", (Object)this.identity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "taskList": {
                return Optional.ofNullable(clazz.cast(this.taskList()));
            }
            case "identity": {
                return Optional.ofNullable(clazz.cast(this.identity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domain", DOMAIN_FIELD);
        map.put("taskList", TASK_LIST_FIELD);
        map.put("identity", IDENTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PollForActivityTaskRequest, T> g) {
        return obj -> g.apply((PollForActivityTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfRequest.BuilderImpl
    implements Builder {
        private String domain;
        private TaskList taskList;
        private String identity;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForActivityTaskRequest model) {
            super(model);
            this.domain(model.domain);
            this.taskList(model.taskList);
            this.identity(model.identity);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final TaskList.Builder getTaskList() {
            return this.taskList != null ? this.taskList.toBuilder() : null;
        }

        public final void setTaskList(TaskList.BuilderImpl taskList) {
            this.taskList = taskList != null ? taskList.build() : null;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final String getIdentity() {
            return this.identity;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PollForActivityTaskRequest build() {
            return new PollForActivityTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SwfRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PollForActivityTaskRequest> {
        public Builder domain(String var1);

        public Builder taskList(TaskList var1);

        default public Builder taskList(Consumer<TaskList.Builder> taskList) {
            return this.taskList((TaskList)((TaskList.Builder)TaskList.builder().applyMutation(taskList)).build());
        }

        public Builder identity(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

