/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>ChildWorkflowExecutionCompleted</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChildWorkflowExecutionCompletedEventAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<ChildWorkflowExecutionCompletedEventAttributes.Builder, ChildWorkflowExecutionCompletedEventAttributes> {
    private static final SdkField<WorkflowExecution> WORKFLOW_EXECUTION_FIELD = SdkField
            .<WorkflowExecution> builder(MarshallingType.SDK_POJO).memberName("workflowExecution")
            .getter(getter(ChildWorkflowExecutionCompletedEventAttributes::workflowExecution))
            .setter(setter(Builder::workflowExecution)).constructor(WorkflowExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowExecution").build()).build();

    private static final SdkField<WorkflowType> WORKFLOW_TYPE_FIELD = SdkField.<WorkflowType> builder(MarshallingType.SDK_POJO)
            .memberName("workflowType").getter(getter(ChildWorkflowExecutionCompletedEventAttributes::workflowType))
            .setter(setter(Builder::workflowType)).constructor(WorkflowType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowType").build()).build();

    private static final SdkField<String> RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("result")
            .getter(getter(ChildWorkflowExecutionCompletedEventAttributes::result)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()).build();

    private static final SdkField<Long> INITIATED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("initiatedEventId").getter(getter(ChildWorkflowExecutionCompletedEventAttributes::initiatedEventId))
            .setter(setter(Builder::initiatedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initiatedEventId").build()).build();

    private static final SdkField<Long> STARTED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("startedEventId").getter(getter(ChildWorkflowExecutionCompletedEventAttributes::startedEventId))
            .setter(setter(Builder::startedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedEventId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_EXECUTION_FIELD,
            WORKFLOW_TYPE_FIELD, RESULT_FIELD, INITIATED_EVENT_ID_FIELD, STARTED_EVENT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final WorkflowExecution workflowExecution;

    private final WorkflowType workflowType;

    private final String result;

    private final Long initiatedEventId;

    private final Long startedEventId;

    private ChildWorkflowExecutionCompletedEventAttributes(BuilderImpl builder) {
        this.workflowExecution = builder.workflowExecution;
        this.workflowType = builder.workflowType;
        this.result = builder.result;
        this.initiatedEventId = builder.initiatedEventId;
        this.startedEventId = builder.startedEventId;
    }

    /**
     * <p>
     * The child workflow execution that was completed.
     * </p>
     * 
     * @return The child workflow execution that was completed.
     */
    public final WorkflowExecution workflowExecution() {
        return workflowExecution;
    }

    /**
     * <p>
     * The type of the child workflow execution.
     * </p>
     * 
     * @return The type of the child workflow execution.
     */
    public final WorkflowType workflowType() {
        return workflowType;
    }

    /**
     * <p>
     * The result of the child workflow execution.
     * </p>
     * 
     * @return The result of the child workflow execution.
     */
    public final String result() {
        return result;
    }

    /**
     * <p>
     * The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
     * <code>StartChildWorkflowExecution</code> <a>Decision</a> to start this child workflow execution. This information
     * can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
     *         <code>StartChildWorkflowExecution</code> <a>Decision</a> to start this child workflow execution. This
     *         information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     *         event.
     */
    public final Long initiatedEventId() {
        return initiatedEventId;
    }

    /**
     * <p>
     * The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
     * started. This information can be useful for diagnosing problems by tracing back the chain of events leading up to
     * this event.
     * </p>
     * 
     * @return The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow
     *         execution was started. This information can be useful for diagnosing problems by tracing back the chain
     *         of events leading up to this event.
     */
    public final Long startedEventId() {
        return startedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workflowExecution());
        hashCode = 31 * hashCode + Objects.hashCode(workflowType());
        hashCode = 31 * hashCode + Objects.hashCode(result());
        hashCode = 31 * hashCode + Objects.hashCode(initiatedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(startedEventId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChildWorkflowExecutionCompletedEventAttributes)) {
            return false;
        }
        ChildWorkflowExecutionCompletedEventAttributes other = (ChildWorkflowExecutionCompletedEventAttributes) obj;
        return Objects.equals(workflowExecution(), other.workflowExecution())
                && Objects.equals(workflowType(), other.workflowType()) && Objects.equals(result(), other.result())
                && Objects.equals(initiatedEventId(), other.initiatedEventId())
                && Objects.equals(startedEventId(), other.startedEventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChildWorkflowExecutionCompletedEventAttributes").add("WorkflowExecution", workflowExecution())
                .add("WorkflowType", workflowType()).add("Result", result()).add("InitiatedEventId", initiatedEventId())
                .add("StartedEventId", startedEventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workflowExecution":
            return Optional.ofNullable(clazz.cast(workflowExecution()));
        case "workflowType":
            return Optional.ofNullable(clazz.cast(workflowType()));
        case "result":
            return Optional.ofNullable(clazz.cast(result()));
        case "initiatedEventId":
            return Optional.ofNullable(clazz.cast(initiatedEventId()));
        case "startedEventId":
            return Optional.ofNullable(clazz.cast(startedEventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workflowExecution", WORKFLOW_EXECUTION_FIELD);
        map.put("workflowType", WORKFLOW_TYPE_FIELD);
        map.put("result", RESULT_FIELD);
        map.put("initiatedEventId", INITIATED_EVENT_ID_FIELD);
        map.put("startedEventId", STARTED_EVENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChildWorkflowExecutionCompletedEventAttributes, T> g) {
        return obj -> g.apply((ChildWorkflowExecutionCompletedEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChildWorkflowExecutionCompletedEventAttributes> {
        /**
         * <p>
         * The child workflow execution that was completed.
         * </p>
         * 
         * @param workflowExecution
         *        The child workflow execution that was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecution(WorkflowExecution workflowExecution);

        /**
         * <p>
         * The child workflow execution that was completed.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkflowExecution.Builder} avoiding the
         * need to create one manually via {@link WorkflowExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #workflowExecution(WorkflowExecution)}.
         * 
         * @param workflowExecution
         *        a consumer that will call methods on {@link WorkflowExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowExecution(WorkflowExecution)
         */
        default Builder workflowExecution(Consumer<WorkflowExecution.Builder> workflowExecution) {
            return workflowExecution(WorkflowExecution.builder().applyMutation(workflowExecution).build());
        }

        /**
         * <p>
         * The type of the child workflow execution.
         * </p>
         * 
         * @param workflowType
         *        The type of the child workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowType(WorkflowType workflowType);

        /**
         * <p>
         * The type of the child workflow execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkflowType.Builder} avoiding the need
         * to create one manually via {@link WorkflowType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowType.Builder#build()} is called immediately and its
         * result is passed to {@link #workflowType(WorkflowType)}.
         * 
         * @param workflowType
         *        a consumer that will call methods on {@link WorkflowType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowType(WorkflowType)
         */
        default Builder workflowType(Consumer<WorkflowType.Builder> workflowType) {
            return workflowType(WorkflowType.builder().applyMutation(workflowType).build());
        }

        /**
         * <p>
         * The result of the child workflow execution.
         * </p>
         * 
         * @param result
         *        The result of the child workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(String result);

        /**
         * <p>
         * The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
         * <code>StartChildWorkflowExecution</code> <a>Decision</a> to start this child workflow execution. This
         * information can be useful for diagnosing problems by tracing back the chain of events leading up to this
         * event.
         * </p>
         * 
         * @param initiatedEventId
         *        The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
         *        <code>StartChildWorkflowExecution</code> <a>Decision</a> to start this child workflow execution. This
         *        information can be useful for diagnosing problems by tracing back the chain of events leading up to
         *        this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiatedEventId(Long initiatedEventId);

        /**
         * <p>
         * The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution
         * was started. This information can be useful for diagnosing problems by tracing back the chain of events
         * leading up to this event.
         * </p>
         * 
         * @param startedEventId
         *        The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow
         *        execution was started. This information can be useful for diagnosing problems by tracing back the
         *        chain of events leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedEventId(Long startedEventId);
    }

    static final class BuilderImpl implements Builder {
        private WorkflowExecution workflowExecution;

        private WorkflowType workflowType;

        private String result;

        private Long initiatedEventId;

        private Long startedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(ChildWorkflowExecutionCompletedEventAttributes model) {
            workflowExecution(model.workflowExecution);
            workflowType(model.workflowType);
            result(model.result);
            initiatedEventId(model.initiatedEventId);
            startedEventId(model.startedEventId);
        }

        public final WorkflowExecution.Builder getWorkflowExecution() {
            return workflowExecution != null ? workflowExecution.toBuilder() : null;
        }

        public final void setWorkflowExecution(WorkflowExecution.BuilderImpl workflowExecution) {
            this.workflowExecution = workflowExecution != null ? workflowExecution.build() : null;
        }

        @Override
        public final Builder workflowExecution(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
            return this;
        }

        public final WorkflowType.Builder getWorkflowType() {
            return workflowType != null ? workflowType.toBuilder() : null;
        }

        public final void setWorkflowType(WorkflowType.BuilderImpl workflowType) {
            this.workflowType = workflowType != null ? workflowType.build() : null;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final String getResult() {
            return result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        public final Long getInitiatedEventId() {
            return initiatedEventId;
        }

        public final void setInitiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
        }

        @Override
        public final Builder initiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
            return this;
        }

        public final Long getStartedEventId() {
            return startedEventId;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        @Override
        public ChildWorkflowExecutionCompletedEventAttributes build() {
            return new ChildWorkflowExecutionCompletedEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
