/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>TimerCanceled</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimerCanceledEventAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<TimerCanceledEventAttributes.Builder, TimerCanceledEventAttributes> {
    private static final SdkField<String> TIMER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timerId").getter(getter(TimerCanceledEventAttributes::timerId)).setter(setter(Builder::timerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timerId").build()).build();

    private static final SdkField<Long> STARTED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("startedEventId").getter(getter(TimerCanceledEventAttributes::startedEventId))
            .setter(setter(Builder::startedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedEventId").build()).build();

    private static final SdkField<Long> DECISION_TASK_COMPLETED_EVENT_ID_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("decisionTaskCompletedEventId")
            .getter(getter(TimerCanceledEventAttributes::decisionTaskCompletedEventId))
            .setter(setter(Builder::decisionTaskCompletedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionTaskCompletedEventId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMER_ID_FIELD,
            STARTED_EVENT_ID_FIELD, DECISION_TASK_COMPLETED_EVENT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String timerId;

    private final Long startedEventId;

    private final Long decisionTaskCompletedEventId;

    private TimerCanceledEventAttributes(BuilderImpl builder) {
        this.timerId = builder.timerId;
        this.startedEventId = builder.startedEventId;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
    }

    /**
     * <p>
     * The unique ID of the timer that was canceled.
     * </p>
     * 
     * @return The unique ID of the timer that was canceled.
     */
    public final String timerId() {
        return timerId;
    }

    /**
     * <p>
     * The ID of the <code>TimerStarted</code> event that was recorded when this timer was started. This information can
     * be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>TimerStarted</code> event that was recorded when this timer was started. This
     *         information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     *         event.
     */
    public final Long startedEventId() {
        return startedEventId;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
     * <code>CancelTimer</code> decision to cancel this timer. This information can be useful for diagnosing problems by
     * tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted
     *         in the <code>CancelTimer</code> decision to cancel this timer. This information can be useful for
     *         diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public final Long decisionTaskCompletedEventId() {
        return decisionTaskCompletedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timerId());
        hashCode = 31 * hashCode + Objects.hashCode(startedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(decisionTaskCompletedEventId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimerCanceledEventAttributes)) {
            return false;
        }
        TimerCanceledEventAttributes other = (TimerCanceledEventAttributes) obj;
        return Objects.equals(timerId(), other.timerId()) && Objects.equals(startedEventId(), other.startedEventId())
                && Objects.equals(decisionTaskCompletedEventId(), other.decisionTaskCompletedEventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimerCanceledEventAttributes").add("TimerId", timerId()).add("StartedEventId", startedEventId())
                .add("DecisionTaskCompletedEventId", decisionTaskCompletedEventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timerId":
            return Optional.ofNullable(clazz.cast(timerId()));
        case "startedEventId":
            return Optional.ofNullable(clazz.cast(startedEventId()));
        case "decisionTaskCompletedEventId":
            return Optional.ofNullable(clazz.cast(decisionTaskCompletedEventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("timerId", TIMER_ID_FIELD);
        map.put("startedEventId", STARTED_EVENT_ID_FIELD);
        map.put("decisionTaskCompletedEventId", DECISION_TASK_COMPLETED_EVENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimerCanceledEventAttributes, T> g) {
        return obj -> g.apply((TimerCanceledEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimerCanceledEventAttributes> {
        /**
         * <p>
         * The unique ID of the timer that was canceled.
         * </p>
         * 
         * @param timerId
         *        The unique ID of the timer that was canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timerId(String timerId);

        /**
         * <p>
         * The ID of the <code>TimerStarted</code> event that was recorded when this timer was started. This information
         * can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
         * </p>
         * 
         * @param startedEventId
         *        The ID of the <code>TimerStarted</code> event that was recorded when this timer was started. This
         *        information can be useful for diagnosing problems by tracing back the chain of events leading up to
         *        this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedEventId(Long startedEventId);

        /**
         * <p>
         * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in
         * the <code>CancelTimer</code> decision to cancel this timer. This information can be useful for diagnosing
         * problems by tracing back the chain of events leading up to this event.
         * </p>
         * 
         * @param decisionTaskCompletedEventId
         *        The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that
         *        resulted in the <code>CancelTimer</code> decision to cancel this timer. This information can be useful
         *        for diagnosing problems by tracing back the chain of events leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId);
    }

    static final class BuilderImpl implements Builder {
        private String timerId;

        private Long startedEventId;

        private Long decisionTaskCompletedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(TimerCanceledEventAttributes model) {
            timerId(model.timerId);
            startedEventId(model.startedEventId);
            decisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
        }

        public final String getTimerId() {
            return timerId;
        }

        public final void setTimerId(String timerId) {
            this.timerId = timerId;
        }

        @Override
        public final Builder timerId(String timerId) {
            this.timerId = timerId;
            return this;
        }

        public final Long getStartedEventId() {
            return startedEventId;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return decisionTaskCompletedEventId;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        @Override
        public TimerCanceledEventAttributes build() {
            return new TimerCanceledEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
