/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>ScheduleActivityTaskFailed</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleActivityTaskFailedEventAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduleActivityTaskFailedEventAttributes.Builder, ScheduleActivityTaskFailedEventAttributes> {
    private static final SdkField<ActivityType> ACTIVITY_TYPE_FIELD = SdkField.<ActivityType> builder(MarshallingType.SDK_POJO)
            .getter(getter(ScheduleActivityTaskFailedEventAttributes::activityType)).setter(setter(Builder::activityType))
            .constructor(ActivityType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityType").build()).build();

    private static final SdkField<String> ACTIVITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScheduleActivityTaskFailedEventAttributes::activityId)).setter(setter(Builder::activityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityId").build()).build();

    private static final SdkField<String> CAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScheduleActivityTaskFailedEventAttributes::causeAsString)).setter(setter(Builder::cause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()).build();

    private static final SdkField<Long> DECISION_TASK_COMPLETED_EVENT_ID_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(ScheduleActivityTaskFailedEventAttributes::decisionTaskCompletedEventId))
            .setter(setter(Builder::decisionTaskCompletedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionTaskCompletedEventId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_TYPE_FIELD,
            ACTIVITY_ID_FIELD, CAUSE_FIELD, DECISION_TASK_COMPLETED_EVENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final ActivityType activityType;

    private final String activityId;

    private final String causeValue;

    private final Long decisionTaskCompletedEventId;

    private ScheduleActivityTaskFailedEventAttributes(BuilderImpl builder) {
        this.activityType = builder.activityType;
        this.activityId = builder.activityId;
        this.causeValue = builder.causeValue;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
    }

    /**
     * <p>
     * The activity type provided in the <code>ScheduleActivityTask</code> decision that failed.
     * </p>
     * 
     * @return The activity type provided in the <code>ScheduleActivityTask</code> decision that failed.
     */
    public ActivityType activityType() {
        return activityType;
    }

    /**
     * <p>
     * The activityId provided in the <code>ScheduleActivityTask</code> decision that failed.
     * </p>
     * 
     * @return The activityId provided in the <code>ScheduleActivityTask</code> decision that failed.
     */
    public String activityId() {
        return activityId;
    }

    /**
     * <p>
     * The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.
     * </p>
     * <note>
     * <p>
     * If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it lacked
     * sufficient permissions. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cause} will return
     * {@link ScheduleActivityTaskFailedCause#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #causeAsString}.
     * </p>
     * 
     * @return The cause of the failure. This information is generated by the system and can be useful for diagnostic
     *         purposes.</p> <note>
     *         <p>
     *         If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it
     *         lacked sufficient permissions. For details and example IAM policies, see <a
     *         href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
     *         Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     *         </p>
     * @see ScheduleActivityTaskFailedCause
     */
    public ScheduleActivityTaskFailedCause cause() {
        return ScheduleActivityTaskFailedCause.fromValue(causeValue);
    }

    /**
     * <p>
     * The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.
     * </p>
     * <note>
     * <p>
     * If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it lacked
     * sufficient permissions. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cause} will return
     * {@link ScheduleActivityTaskFailedCause#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #causeAsString}.
     * </p>
     * 
     * @return The cause of the failure. This information is generated by the system and can be useful for diagnostic
     *         purposes.</p> <note>
     *         <p>
     *         If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it
     *         lacked sufficient permissions. For details and example IAM policies, see <a
     *         href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
     *         Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     *         </p>
     * @see ScheduleActivityTaskFailedCause
     */
    public String causeAsString() {
        return causeValue;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision that resulted in the
     * scheduling of this activity task. This information can be useful for diagnosing problems by tracing back the
     * chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision that resulted in the
     *         scheduling of this activity task. This information can be useful for diagnosing problems by tracing back
     *         the chain of events leading up to this event.
     */
    public Long decisionTaskCompletedEventId() {
        return decisionTaskCompletedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activityType());
        hashCode = 31 * hashCode + Objects.hashCode(activityId());
        hashCode = 31 * hashCode + Objects.hashCode(causeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(decisionTaskCompletedEventId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleActivityTaskFailedEventAttributes)) {
            return false;
        }
        ScheduleActivityTaskFailedEventAttributes other = (ScheduleActivityTaskFailedEventAttributes) obj;
        return Objects.equals(activityType(), other.activityType()) && Objects.equals(activityId(), other.activityId())
                && Objects.equals(causeAsString(), other.causeAsString())
                && Objects.equals(decisionTaskCompletedEventId(), other.decisionTaskCompletedEventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ScheduleActivityTaskFailedEventAttributes").add("ActivityType", activityType())
                .add("ActivityId", activityId()).add("Cause", causeAsString())
                .add("DecisionTaskCompletedEventId", decisionTaskCompletedEventId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activityType":
            return Optional.ofNullable(clazz.cast(activityType()));
        case "activityId":
            return Optional.ofNullable(clazz.cast(activityId()));
        case "cause":
            return Optional.ofNullable(clazz.cast(causeAsString()));
        case "decisionTaskCompletedEventId":
            return Optional.ofNullable(clazz.cast(decisionTaskCompletedEventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleActivityTaskFailedEventAttributes, T> g) {
        return obj -> g.apply((ScheduleActivityTaskFailedEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduleActivityTaskFailedEventAttributes> {
        /**
         * <p>
         * The activity type provided in the <code>ScheduleActivityTask</code> decision that failed.
         * </p>
         * 
         * @param activityType
         *        The activity type provided in the <code>ScheduleActivityTask</code> decision that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityType(ActivityType activityType);

        /**
         * <p>
         * The activity type provided in the <code>ScheduleActivityTask</code> decision that failed.
         * </p>
         * This is a convenience that creates an instance of the {@link ActivityType.Builder} avoiding the need to
         * create one manually via {@link ActivityType#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActivityType.Builder#build()} is called immediately and its
         * result is passed to {@link #activityType(ActivityType)}.
         * 
         * @param activityType
         *        a consumer that will call methods on {@link ActivityType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityType(ActivityType)
         */
        default Builder activityType(Consumer<ActivityType.Builder> activityType) {
            return activityType(ActivityType.builder().applyMutation(activityType).build());
        }

        /**
         * <p>
         * The activityId provided in the <code>ScheduleActivityTask</code> decision that failed.
         * </p>
         * 
         * @param activityId
         *        The activityId provided in the <code>ScheduleActivityTask</code> decision that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityId(String activityId);

        /**
         * <p>
         * The cause of the failure. This information is generated by the system and can be useful for diagnostic
         * purposes.
         * </p>
         * <note>
         * <p>
         * If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it lacked
         * sufficient permissions. For details and example IAM policies, see <a
         * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access
         * to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param causeValue
         *        The cause of the failure. This information is generated by the system and can be useful for diagnostic
         *        purposes.</p> <note>
         *        <p>
         *        If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it
         *        lacked sufficient permissions. For details and example IAM policies, see <a
         *        href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
         *        Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
         *        </p>
         * @see ScheduleActivityTaskFailedCause
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleActivityTaskFailedCause
         */
        Builder cause(String causeValue);

        /**
         * <p>
         * The cause of the failure. This information is generated by the system and can be useful for diagnostic
         * purposes.
         * </p>
         * <note>
         * <p>
         * If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it lacked
         * sufficient permissions. For details and example IAM policies, see <a
         * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access
         * to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param causeValue
         *        The cause of the failure. This information is generated by the system and can be useful for diagnostic
         *        purposes.</p> <note>
         *        <p>
         *        If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it
         *        lacked sufficient permissions. For details and example IAM policies, see <a
         *        href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
         *        Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
         *        </p>
         * @see ScheduleActivityTaskFailedCause
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleActivityTaskFailedCause
         */
        Builder cause(ScheduleActivityTaskFailedCause causeValue);

        /**
         * <p>
         * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision that resulted in the
         * scheduling of this activity task. This information can be useful for diagnosing problems by tracing back the
         * chain of events leading up to this event.
         * </p>
         * 
         * @param decisionTaskCompletedEventId
         *        The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision that resulted in
         *        the scheduling of this activity task. This information can be useful for diagnosing problems by
         *        tracing back the chain of events leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId);
    }

    static final class BuilderImpl implements Builder {
        private ActivityType activityType;

        private String activityId;

        private String causeValue;

        private Long decisionTaskCompletedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleActivityTaskFailedEventAttributes model) {
            activityType(model.activityType);
            activityId(model.activityId);
            cause(model.causeValue);
            decisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
        }

        public final ActivityType.Builder getActivityType() {
            return activityType != null ? activityType.toBuilder() : null;
        }

        @Override
        public final Builder activityType(ActivityType activityType) {
            this.activityType = activityType;
            return this;
        }

        public final void setActivityType(ActivityType.BuilderImpl activityType) {
            this.activityType = activityType != null ? activityType.build() : null;
        }

        public final String getActivityId() {
            return activityId;
        }

        @Override
        public final Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public final void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        public final String getCauseAsString() {
            return causeValue;
        }

        @Override
        public final Builder cause(String causeValue) {
            this.causeValue = causeValue;
            return this;
        }

        @Override
        public final Builder cause(ScheduleActivityTaskFailedCause causeValue) {
            this.cause(causeValue.toString());
            return this;
        }

        public final void setCause(String causeValue) {
            this.causeValue = causeValue;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        @Override
        public ScheduleActivityTaskFailedEventAttributes build() {
            return new ScheduleActivityTaskFailedEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
