/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>SignalExternalWorkflowExecution</code> decision.
 * </p>
 * <p>
 * <b>Access Control</b>
 * </p>
 * <p>
 * You can use IAM policies to control this decision's access to Amazon SWF resources as follows:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
 * </p>
 * </li>
 * <li>
 * <p>
 * Use an <code>Action</code> element to allow or deny permission to call this action.
 * </p>
 * </li>
 * <li>
 * <p>
 * You cannot use an IAM policy to constrain this action's parameters.
 * </p>
 * </li>
 * </ul>
 * <p>
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
 * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
 * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
 * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
 * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SignalExternalWorkflowExecutionDecisionAttributes
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<SignalExternalWorkflowExecutionDecisionAttributes.Builder, SignalExternalWorkflowExecutionDecisionAttributes> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SignalExternalWorkflowExecutionDecisionAttributes::workflowId)).setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SignalExternalWorkflowExecutionDecisionAttributes::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()).build();

    private static final SdkField<String> SIGNAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SignalExternalWorkflowExecutionDecisionAttributes::signalName)).setter(setter(Builder::signalName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalName").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SignalExternalWorkflowExecutionDecisionAttributes::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<String> CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SignalExternalWorkflowExecutionDecisionAttributes::control)).setter(setter(Builder::control))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("control").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD,
            RUN_ID_FIELD, SIGNAL_NAME_FIELD, INPUT_FIELD, CONTROL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String workflowId;

    private final String runId;

    private final String signalName;

    private final String input;

    private final String control;

    private SignalExternalWorkflowExecutionDecisionAttributes(BuilderImpl builder) {
        this.workflowId = builder.workflowId;
        this.runId = builder.runId;
        this.signalName = builder.signalName;
        this.input = builder.input;
        this.control = builder.control;
    }

    /**
     * <p>
     * The <code>workflowId</code> of the workflow execution to be signaled.
     * </p>
     * 
     * @return The <code>workflowId</code> of the workflow execution to be signaled.
     */
    public String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The <code>runId</code> of the workflow execution to be signaled.
     * </p>
     * 
     * @return The <code>runId</code> of the workflow execution to be signaled.
     */
    public String runId() {
        return runId;
    }

    /**
     * <p>
     * The name of the signal.The target workflow execution uses the signal name and input to process the signal.
     * </p>
     * 
     * @return The name of the signal.The target workflow execution uses the signal name and input to process the
     *         signal.
     */
    public String signalName() {
        return signalName;
    }

    /**
     * <p>
     * The input data to be provided with the signal. The target workflow execution uses the signal name and input data
     * to process the signal.
     * </p>
     * 
     * @return The input data to be provided with the signal. The target workflow execution uses the signal name and
     *         input data to process the signal.
     */
    public String input() {
        return input;
    }

    /**
     * <p>
     * The data attached to the event that can be used by the decider in subsequent decision tasks.
     * </p>
     * 
     * @return The data attached to the event that can be used by the decider in subsequent decision tasks.
     */
    public String control() {
        return control;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(signalName());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(control());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalExternalWorkflowExecutionDecisionAttributes)) {
            return false;
        }
        SignalExternalWorkflowExecutionDecisionAttributes other = (SignalExternalWorkflowExecutionDecisionAttributes) obj;
        return Objects.equals(workflowId(), other.workflowId()) && Objects.equals(runId(), other.runId())
                && Objects.equals(signalName(), other.signalName()) && Objects.equals(input(), other.input())
                && Objects.equals(control(), other.control());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SignalExternalWorkflowExecutionDecisionAttributes").add("WorkflowId", workflowId())
                .add("RunId", runId()).add("SignalName", signalName()).add("Input", input()).add("Control", control()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "runId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "signalName":
            return Optional.ofNullable(clazz.cast(signalName()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "control":
            return Optional.ofNullable(clazz.cast(control()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SignalExternalWorkflowExecutionDecisionAttributes, T> g) {
        return obj -> g.apply((SignalExternalWorkflowExecutionDecisionAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SignalExternalWorkflowExecutionDecisionAttributes> {
        /**
         * <p>
         * The <code>workflowId</code> of the workflow execution to be signaled.
         * </p>
         * 
         * @param workflowId
         *        The <code>workflowId</code> of the workflow execution to be signaled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The <code>runId</code> of the workflow execution to be signaled.
         * </p>
         * 
         * @param runId
         *        The <code>runId</code> of the workflow execution to be signaled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The name of the signal.The target workflow execution uses the signal name and input to process the signal.
         * </p>
         * 
         * @param signalName
         *        The name of the signal.The target workflow execution uses the signal name and input to process the
         *        signal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalName(String signalName);

        /**
         * <p>
         * The input data to be provided with the signal. The target workflow execution uses the signal name and input
         * data to process the signal.
         * </p>
         * 
         * @param input
         *        The input data to be provided with the signal. The target workflow execution uses the signal name and
         *        input data to process the signal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * The data attached to the event that can be used by the decider in subsequent decision tasks.
         * </p>
         * 
         * @param control
         *        The data attached to the event that can be used by the decider in subsequent decision tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder control(String control);
    }

    static final class BuilderImpl implements Builder {
        private String workflowId;

        private String runId;

        private String signalName;

        private String input;

        private String control;

        private BuilderImpl() {
        }

        private BuilderImpl(SignalExternalWorkflowExecutionDecisionAttributes model) {
            workflowId(model.workflowId);
            runId(model.runId);
            signalName(model.signalName);
            input(model.input);
            control(model.control);
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        public final String getRunId() {
            return runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        public final String getSignalName() {
            return signalName;
        }

        @Override
        public final Builder signalName(String signalName) {
            this.signalName = signalName;
            return this;
        }

        public final void setSignalName(String signalName) {
            this.signalName = signalName;
        }

        public final String getInput() {
            return input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final String getControl() {
            return control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        @Override
        public SignalExternalWorkflowExecutionDecisionAttributes build() {
            return new SignalExternalWorkflowExecutionDecisionAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
