/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>LambdaFunctionTimedOut</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaFunctionTimedOutEventAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaFunctionTimedOutEventAttributes.Builder, LambdaFunctionTimedOutEventAttributes> {
    private static final SdkField<Long> SCHEDULED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(LambdaFunctionTimedOutEventAttributes::scheduledEventId)).setter(setter(Builder::scheduledEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledEventId").build()).build();

    private static final SdkField<Long> STARTED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(LambdaFunctionTimedOutEventAttributes::startedEventId)).setter(setter(Builder::startedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedEventId").build()).build();

    private static final SdkField<String> TIMEOUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LambdaFunctionTimedOutEventAttributes::timeoutTypeAsString)).setter(setter(Builder::timeoutType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_EVENT_ID_FIELD,
            STARTED_EVENT_ID_FIELD, TIMEOUT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long scheduledEventId;

    private final Long startedEventId;

    private final String timeoutType;

    private LambdaFunctionTimedOutEventAttributes(BuilderImpl builder) {
        this.scheduledEventId = builder.scheduledEventId;
        this.startedEventId = builder.startedEventId;
        this.timeoutType = builder.timeoutType;
    }

    /**
     * <p>
     * The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this activity task was scheduled.
     * To help diagnose issues, use this information to trace back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this activity task was
     *         scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to
     *         this event.
     */
    public Long scheduledEventId() {
        return scheduledEventId;
    }

    /**
     * <p>
     * The ID of the <code>ActivityTaskStarted</code> event that was recorded when this activity task started. To help
     * diagnose issues, use this information to trace back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>ActivityTaskStarted</code> event that was recorded when this activity task started.
     *         To help diagnose issues, use this information to trace back the chain of events leading up to this event.
     */
    public Long startedEventId() {
        return startedEventId;
    }

    /**
     * <p>
     * The type of the timeout that caused this event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeoutType} will
     * return {@link LambdaFunctionTimeoutType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timeoutTypeAsString}.
     * </p>
     * 
     * @return The type of the timeout that caused this event.
     * @see LambdaFunctionTimeoutType
     */
    public LambdaFunctionTimeoutType timeoutType() {
        return LambdaFunctionTimeoutType.fromValue(timeoutType);
    }

    /**
     * <p>
     * The type of the timeout that caused this event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeoutType} will
     * return {@link LambdaFunctionTimeoutType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timeoutTypeAsString}.
     * </p>
     * 
     * @return The type of the timeout that caused this event.
     * @see LambdaFunctionTimeoutType
     */
    public String timeoutTypeAsString() {
        return timeoutType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduledEventId());
        hashCode = 31 * hashCode + Objects.hashCode(startedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionTimedOutEventAttributes)) {
            return false;
        }
        LambdaFunctionTimedOutEventAttributes other = (LambdaFunctionTimedOutEventAttributes) obj;
        return Objects.equals(scheduledEventId(), other.scheduledEventId())
                && Objects.equals(startedEventId(), other.startedEventId())
                && Objects.equals(timeoutTypeAsString(), other.timeoutTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LambdaFunctionTimedOutEventAttributes").add("ScheduledEventId", scheduledEventId())
                .add("StartedEventId", startedEventId()).add("TimeoutType", timeoutTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scheduledEventId":
            return Optional.ofNullable(clazz.cast(scheduledEventId()));
        case "startedEventId":
            return Optional.ofNullable(clazz.cast(startedEventId()));
        case "timeoutType":
            return Optional.ofNullable(clazz.cast(timeoutTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunctionTimedOutEventAttributes, T> g) {
        return obj -> g.apply((LambdaFunctionTimedOutEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaFunctionTimedOutEventAttributes> {
        /**
         * <p>
         * The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this activity task was
         * scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this
         * event.
         * </p>
         * 
         * @param scheduledEventId
         *        The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this activity task was
         *        scheduled. To help diagnose issues, use this information to trace back the chain of events leading up
         *        to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledEventId(Long scheduledEventId);

        /**
         * <p>
         * The ID of the <code>ActivityTaskStarted</code> event that was recorded when this activity task started. To
         * help diagnose issues, use this information to trace back the chain of events leading up to this event.
         * </p>
         * 
         * @param startedEventId
         *        The ID of the <code>ActivityTaskStarted</code> event that was recorded when this activity task
         *        started. To help diagnose issues, use this information to trace back the chain of events leading up to
         *        this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedEventId(Long startedEventId);

        /**
         * <p>
         * The type of the timeout that caused this event.
         * </p>
         * 
         * @param timeoutType
         *        The type of the timeout that caused this event.
         * @see LambdaFunctionTimeoutType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LambdaFunctionTimeoutType
         */
        Builder timeoutType(String timeoutType);

        /**
         * <p>
         * The type of the timeout that caused this event.
         * </p>
         * 
         * @param timeoutType
         *        The type of the timeout that caused this event.
         * @see LambdaFunctionTimeoutType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LambdaFunctionTimeoutType
         */
        Builder timeoutType(LambdaFunctionTimeoutType timeoutType);
    }

    static final class BuilderImpl implements Builder {
        private Long scheduledEventId;

        private Long startedEventId;

        private String timeoutType;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionTimedOutEventAttributes model) {
            scheduledEventId(model.scheduledEventId);
            startedEventId(model.startedEventId);
            timeoutType(model.timeoutType);
        }

        public final Long getScheduledEventId() {
            return scheduledEventId;
        }

        @Override
        public final Builder scheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
            return this;
        }

        public final void setScheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
        }

        public final Long getStartedEventId() {
            return startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        public final String getTimeoutTypeAsString() {
            return timeoutType;
        }

        @Override
        public final Builder timeoutType(String timeoutType) {
            this.timeoutType = timeoutType;
            return this;
        }

        @Override
        public final Builder timeoutType(LambdaFunctionTimeoutType timeoutType) {
            this.timeoutType(timeoutType.toString());
            return this;
        }

        public final void setTimeoutType(String timeoutType) {
            this.timeoutType = timeoutType;
        }

        @Override
        public LambdaFunctionTimedOutEventAttributes build() {
            return new LambdaFunctionTimedOutEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
