/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.StartTimerFailedCause;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartTimerFailedEventAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StartTimerFailedEventAttributes> {
    private static final SdkField<String> TIMER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartTimerFailedEventAttributes.getter(StartTimerFailedEventAttributes::timerId)).setter(StartTimerFailedEventAttributes.setter(Builder::timerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timerId").build()}).build();
    private static final SdkField<String> CAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartTimerFailedEventAttributes.getter(StartTimerFailedEventAttributes::causeAsString)).setter(StartTimerFailedEventAttributes.setter(Builder::cause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()}).build();
    private static final SdkField<Long> DECISION_TASK_COMPLETED_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(StartTimerFailedEventAttributes.getter(StartTimerFailedEventAttributes::decisionTaskCompletedEventId)).setter(StartTimerFailedEventAttributes.setter(Builder::decisionTaskCompletedEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionTaskCompletedEventId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMER_ID_FIELD, CAUSE_FIELD, DECISION_TASK_COMPLETED_EVENT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String timerId;
    private final String causeValue;
    private final Long decisionTaskCompletedEventId;

    private StartTimerFailedEventAttributes(BuilderImpl builder) {
        this.timerId = builder.timerId;
        this.causeValue = builder.causeValue;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
    }

    public String timerId() {
        return this.timerId;
    }

    public StartTimerFailedCause cause() {
        return StartTimerFailedCause.fromValue(this.causeValue);
    }

    public String causeAsString() {
        return this.causeValue;
    }

    public Long decisionTaskCompletedEventId() {
        return this.decisionTaskCompletedEventId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.causeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.decisionTaskCompletedEventId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTimerFailedEventAttributes)) {
            return false;
        }
        StartTimerFailedEventAttributes other = (StartTimerFailedEventAttributes)obj;
        return Objects.equals(this.timerId(), other.timerId()) && Objects.equals(this.causeAsString(), other.causeAsString()) && Objects.equals(this.decisionTaskCompletedEventId(), other.decisionTaskCompletedEventId());
    }

    public String toString() {
        return ToString.builder((String)"StartTimerFailedEventAttributes").add("TimerId", (Object)this.timerId()).add("Cause", (Object)this.causeAsString()).add("DecisionTaskCompletedEventId", (Object)this.decisionTaskCompletedEventId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "timerId": {
                return Optional.ofNullable(clazz.cast(this.timerId()));
            }
            case "cause": {
                return Optional.ofNullable(clazz.cast(this.causeAsString()));
            }
            case "decisionTaskCompletedEventId": {
                return Optional.ofNullable(clazz.cast(this.decisionTaskCompletedEventId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTimerFailedEventAttributes, T> g) {
        return obj -> g.apply((StartTimerFailedEventAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String timerId;
        private String causeValue;
        private Long decisionTaskCompletedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTimerFailedEventAttributes model) {
            this.timerId(model.timerId);
            this.cause(model.causeValue);
            this.decisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
        }

        public final String getTimerId() {
            return this.timerId;
        }

        @Override
        public final Builder timerId(String timerId) {
            this.timerId = timerId;
            return this;
        }

        public final void setTimerId(String timerId) {
            this.timerId = timerId;
        }

        public final String getCauseAsString() {
            return this.causeValue;
        }

        @Override
        public final Builder cause(String causeValue) {
            this.causeValue = causeValue;
            return this;
        }

        @Override
        public final Builder cause(StartTimerFailedCause causeValue) {
            this.cause(causeValue.toString());
            return this;
        }

        public final void setCause(String causeValue) {
            this.causeValue = causeValue;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return this.decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        public StartTimerFailedEventAttributes build() {
            return new StartTimerFailedEventAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StartTimerFailedEventAttributes> {
        public Builder timerId(String var1);

        public Builder cause(String var1);

        public Builder cause(StartTimerFailedCause var1);

        public Builder decisionTaskCompletedEventId(Long var1);
    }
}

