/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.ActivityType;
import software.amazon.awssdk.services.swf.model.SwfRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeprecateActivityTypeRequest
extends SwfRequest
implements ToCopyableBuilder<Builder, DeprecateActivityTypeRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeprecateActivityTypeRequest.getter(DeprecateActivityTypeRequest::domain)).setter(DeprecateActivityTypeRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()}).build();
    private static final SdkField<ActivityType> ACTIVITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeprecateActivityTypeRequest.getter(DeprecateActivityTypeRequest::activityType)).setter(DeprecateActivityTypeRequest.setter(Builder::activityType)).constructor(ActivityType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, ACTIVITY_TYPE_FIELD));
    private final String domain;
    private final ActivityType activityType;

    private DeprecateActivityTypeRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.activityType = builder.activityType;
    }

    public String domain() {
        return this.domain;
    }

    public ActivityType activityType() {
        return this.activityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.activityType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeprecateActivityTypeRequest)) {
            return false;
        }
        DeprecateActivityTypeRequest other = (DeprecateActivityTypeRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.activityType(), other.activityType());
    }

    public String toString() {
        return ToString.builder((String)"DeprecateActivityTypeRequest").add("Domain", (Object)this.domain()).add("ActivityType", (Object)this.activityType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "activityType": {
                return Optional.ofNullable(clazz.cast(this.activityType()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeprecateActivityTypeRequest, T> g) {
        return obj -> g.apply((DeprecateActivityTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfRequest.BuilderImpl
    implements Builder {
        private String domain;
        private ActivityType activityType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeprecateActivityTypeRequest model) {
            super(model);
            this.domain(model.domain);
            this.activityType(model.activityType);
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final ActivityType.Builder getActivityType() {
            return this.activityType != null ? this.activityType.toBuilder() : null;
        }

        @Override
        public final Builder activityType(ActivityType activityType) {
            this.activityType = activityType;
            return this;
        }

        public final void setActivityType(ActivityType.BuilderImpl activityType) {
            this.activityType = activityType != null ? activityType.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeprecateActivityTypeRequest build() {
            return new DeprecateActivityTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SwfRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeprecateActivityTypeRequest> {
        public Builder domain(String var1);

        public Builder activityType(ActivityType var1);

        default public Builder activityType(Consumer<ActivityType.Builder> activityType) {
            return this.activityType((ActivityType)((ActivityType.Builder)ActivityType.builder().applyMutation(activityType)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

