/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionFailedCause;
import software.amazon.awssdk.services.swf.model.WorkflowType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartChildWorkflowExecutionFailedEventAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StartChildWorkflowExecutionFailedEventAttributes> {
    private static final SdkField<WorkflowType> WORKFLOW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartChildWorkflowExecutionFailedEventAttributes.getter(StartChildWorkflowExecutionFailedEventAttributes::workflowType)).setter(StartChildWorkflowExecutionFailedEventAttributes.setter(Builder::workflowType)).constructor(WorkflowType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowType").build()}).build();
    private static final SdkField<String> CAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartChildWorkflowExecutionFailedEventAttributes.getter(StartChildWorkflowExecutionFailedEventAttributes::causeAsString)).setter(StartChildWorkflowExecutionFailedEventAttributes.setter(Builder::cause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()}).build();
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartChildWorkflowExecutionFailedEventAttributes.getter(StartChildWorkflowExecutionFailedEventAttributes::workflowId)).setter(StartChildWorkflowExecutionFailedEventAttributes.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()}).build();
    private static final SdkField<Long> INITIATED_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(StartChildWorkflowExecutionFailedEventAttributes.getter(StartChildWorkflowExecutionFailedEventAttributes::initiatedEventId)).setter(StartChildWorkflowExecutionFailedEventAttributes.setter(Builder::initiatedEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initiatedEventId").build()}).build();
    private static final SdkField<Long> DECISION_TASK_COMPLETED_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(StartChildWorkflowExecutionFailedEventAttributes.getter(StartChildWorkflowExecutionFailedEventAttributes::decisionTaskCompletedEventId)).setter(StartChildWorkflowExecutionFailedEventAttributes.setter(Builder::decisionTaskCompletedEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionTaskCompletedEventId").build()}).build();
    private static final SdkField<String> CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartChildWorkflowExecutionFailedEventAttributes.getter(StartChildWorkflowExecutionFailedEventAttributes::control)).setter(StartChildWorkflowExecutionFailedEventAttributes.setter(Builder::control)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("control").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_TYPE_FIELD, CAUSE_FIELD, WORKFLOW_ID_FIELD, INITIATED_EVENT_ID_FIELD, DECISION_TASK_COMPLETED_EVENT_ID_FIELD, CONTROL_FIELD));
    private static final long serialVersionUID = 1L;
    private final WorkflowType workflowType;
    private final String causeValue;
    private final String workflowId;
    private final Long initiatedEventId;
    private final Long decisionTaskCompletedEventId;
    private final String control;

    private StartChildWorkflowExecutionFailedEventAttributes(BuilderImpl builder) {
        this.workflowType = builder.workflowType;
        this.causeValue = builder.causeValue;
        this.workflowId = builder.workflowId;
        this.initiatedEventId = builder.initiatedEventId;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
        this.control = builder.control;
    }

    public WorkflowType workflowType() {
        return this.workflowType;
    }

    public StartChildWorkflowExecutionFailedCause cause() {
        return StartChildWorkflowExecutionFailedCause.fromValue(this.causeValue);
    }

    public String causeAsString() {
        return this.causeValue;
    }

    public String workflowId() {
        return this.workflowId;
    }

    public Long initiatedEventId() {
        return this.initiatedEventId;
    }

    public Long decisionTaskCompletedEventId() {
        return this.decisionTaskCompletedEventId;
    }

    public String control() {
        return this.control;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowType());
        hashCode = 31 * hashCode + Objects.hashCode(this.causeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiatedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.decisionTaskCompletedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.control());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartChildWorkflowExecutionFailedEventAttributes)) {
            return false;
        }
        StartChildWorkflowExecutionFailedEventAttributes other = (StartChildWorkflowExecutionFailedEventAttributes)obj;
        return Objects.equals(this.workflowType(), other.workflowType()) && Objects.equals(this.causeAsString(), other.causeAsString()) && Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.initiatedEventId(), other.initiatedEventId()) && Objects.equals(this.decisionTaskCompletedEventId(), other.decisionTaskCompletedEventId()) && Objects.equals(this.control(), other.control());
    }

    public String toString() {
        return ToString.builder((String)"StartChildWorkflowExecutionFailedEventAttributes").add("WorkflowType", (Object)this.workflowType()).add("Cause", (Object)this.causeAsString()).add("WorkflowId", (Object)this.workflowId()).add("InitiatedEventId", (Object)this.initiatedEventId()).add("DecisionTaskCompletedEventId", (Object)this.decisionTaskCompletedEventId()).add("Control", (Object)this.control()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowType": {
                return Optional.ofNullable(clazz.cast(this.workflowType()));
            }
            case "cause": {
                return Optional.ofNullable(clazz.cast(this.causeAsString()));
            }
            case "workflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "initiatedEventId": {
                return Optional.ofNullable(clazz.cast(this.initiatedEventId()));
            }
            case "decisionTaskCompletedEventId": {
                return Optional.ofNullable(clazz.cast(this.decisionTaskCompletedEventId()));
            }
            case "control": {
                return Optional.ofNullable(clazz.cast(this.control()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartChildWorkflowExecutionFailedEventAttributes, T> g) {
        return obj -> g.apply((StartChildWorkflowExecutionFailedEventAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private WorkflowType workflowType;
        private String causeValue;
        private String workflowId;
        private Long initiatedEventId;
        private Long decisionTaskCompletedEventId;
        private String control;

        private BuilderImpl() {
        }

        private BuilderImpl(StartChildWorkflowExecutionFailedEventAttributes model) {
            this.workflowType(model.workflowType);
            this.cause(model.causeValue);
            this.workflowId(model.workflowId);
            this.initiatedEventId(model.initiatedEventId);
            this.decisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
            this.control(model.control);
        }

        public final WorkflowType.Builder getWorkflowType() {
            return this.workflowType != null ? this.workflowType.toBuilder() : null;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final void setWorkflowType(WorkflowType.BuilderImpl workflowType) {
            this.workflowType = workflowType != null ? workflowType.build() : null;
        }

        public final String getCauseAsString() {
            return this.causeValue;
        }

        @Override
        public final Builder cause(String causeValue) {
            this.causeValue = causeValue;
            return this;
        }

        @Override
        public final Builder cause(StartChildWorkflowExecutionFailedCause causeValue) {
            this.cause(causeValue.toString());
            return this;
        }

        public final void setCause(String causeValue) {
            this.causeValue = causeValue;
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        public final Long getInitiatedEventId() {
            return this.initiatedEventId;
        }

        @Override
        public final Builder initiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
            return this;
        }

        public final void setInitiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return this.decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        public final String getControl() {
            return this.control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        public StartChildWorkflowExecutionFailedEventAttributes build() {
            return new StartChildWorkflowExecutionFailedEventAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StartChildWorkflowExecutionFailedEventAttributes> {
        public Builder workflowType(WorkflowType var1);

        default public Builder workflowType(Consumer<WorkflowType.Builder> workflowType) {
            return this.workflowType((WorkflowType)((WorkflowType.Builder)WorkflowType.builder().applyMutation(workflowType)).build());
        }

        public Builder cause(String var1);

        public Builder cause(StartChildWorkflowExecutionFailedCause var1);

        public Builder workflowId(String var1);

        public Builder initiatedEventId(Long var1);

        public Builder decisionTaskCompletedEventId(Long var1);

        public Builder control(String var1);
    }
}

