/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains general information about a domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainInfo implements SdkPojo, Serializable, ToCopyableBuilder<DomainInfo.Builder, DomainInfo> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DomainInfo::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DomainInfo::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DomainInfo::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD,
            DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String status;

    private final String description;

    private DomainInfo(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.description = builder.description;
    }

    /**
     * <p>
     * The name of the domain. This name is unique within the account.
     * </p>
     * 
     * @return The name of the domain. This name is unique within the account.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The status of the domain:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REGISTERED</code> – The domain is properly registered and available. You can use this domain for
     * registering types and creating new workflow executions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEPRECATED</code> – The domain was deprecated using <a>DeprecateDomain</a>, but is still in use. You should
     * not create new workflow executions in this domain.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the domain:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REGISTERED</code> – The domain is properly registered and available. You can use this domain for
     *         registering types and creating new workflow executions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEPRECATED</code> – The domain was deprecated using <a>DeprecateDomain</a>, but is still in use.
     *         You should not create new workflow executions in this domain.
     *         </p>
     *         </li>
     * @see RegistrationStatus
     */
    public RegistrationStatus status() {
        return RegistrationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the domain:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REGISTERED</code> – The domain is properly registered and available. You can use this domain for
     * registering types and creating new workflow executions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEPRECATED</code> – The domain was deprecated using <a>DeprecateDomain</a>, but is still in use. You should
     * not create new workflow executions in this domain.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the domain:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REGISTERED</code> – The domain is properly registered and available. You can use this domain for
     *         registering types and creating new workflow executions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEPRECATED</code> – The domain was deprecated using <a>DeprecateDomain</a>, but is still in use.
     *         You should not create new workflow executions in this domain.
     *         </p>
     *         </li>
     * @see RegistrationStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The description of the domain provided through <a>RegisterDomain</a>.
     * </p>
     * 
     * @return The description of the domain provided through <a>RegisterDomain</a>.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainInfo)) {
            return false;
        }
        DomainInfo other = (DomainInfo) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DomainInfo").add("Name", name()).add("Status", statusAsString())
                .add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainInfo, T> g) {
        return obj -> g.apply((DomainInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainInfo> {
        /**
         * <p>
         * The name of the domain. This name is unique within the account.
         * </p>
         * 
         * @param name
         *        The name of the domain. This name is unique within the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the domain:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REGISTERED</code> – The domain is properly registered and available. You can use this domain for
         * registering types and creating new workflow executions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEPRECATED</code> – The domain was deprecated using <a>DeprecateDomain</a>, but is still in use. You
         * should not create new workflow executions in this domain.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the domain:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REGISTERED</code> – The domain is properly registered and available. You can use this domain for
         *        registering types and creating new workflow executions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEPRECATED</code> – The domain was deprecated using <a>DeprecateDomain</a>, but is still in use.
         *        You should not create new workflow executions in this domain.
         *        </p>
         *        </li>
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the domain:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REGISTERED</code> – The domain is properly registered and available. You can use this domain for
         * registering types and creating new workflow executions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEPRECATED</code> – The domain was deprecated using <a>DeprecateDomain</a>, but is still in use. You
         * should not create new workflow executions in this domain.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the domain:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REGISTERED</code> – The domain is properly registered and available. You can use this domain for
         *        registering types and creating new workflow executions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEPRECATED</code> – The domain was deprecated using <a>DeprecateDomain</a>, but is still in use.
         *        You should not create new workflow executions in this domain.
         *        </p>
         *        </li>
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder status(RegistrationStatus status);

        /**
         * <p>
         * The description of the domain provided through <a>RegisterDomain</a>.
         * </p>
         * 
         * @param description
         *        The description of the domain provided through <a>RegisterDomain</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String status;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainInfo model) {
            name(model.name);
            status(model.status);
            description(model.description);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RegistrationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public DomainInfo build() {
            return new DomainInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
