/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a workflow execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowExecution implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkflowExecution.Builder, WorkflowExecution> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WorkflowExecution::workflowId)).setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WorkflowExecution::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD,
            RUN_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String workflowId;

    private final String runId;

    private WorkflowExecution(BuilderImpl builder) {
        this.workflowId = builder.workflowId;
        this.runId = builder.runId;
    }

    /**
     * <p>
     * The user defined identifier associated with the workflow execution.
     * </p>
     * 
     * @return The user defined identifier associated with the workflow execution.
     */
    public String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * A system-generated unique identifier for the workflow execution.
     * </p>
     * 
     * @return A system-generated unique identifier for the workflow execution.
     */
    public String runId() {
        return runId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecution)) {
            return false;
        }
        WorkflowExecution other = (WorkflowExecution) obj;
        return Objects.equals(workflowId(), other.workflowId()) && Objects.equals(runId(), other.runId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("WorkflowExecution").add("WorkflowId", workflowId()).add("RunId", runId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "runId":
            return Optional.ofNullable(clazz.cast(runId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowExecution, T> g) {
        return obj -> g.apply((WorkflowExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowExecution> {
        /**
         * <p>
         * The user defined identifier associated with the workflow execution.
         * </p>
         * 
         * @param workflowId
         *        The user defined identifier associated with the workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * A system-generated unique identifier for the workflow execution.
         * </p>
         * 
         * @param runId
         *        A system-generated unique identifier for the workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);
    }

    static final class BuilderImpl implements Builder {
        private String workflowId;

        private String runId;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecution model) {
            workflowId(model.workflowId);
            runId(model.runId);
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        public final String getRunId() {
            return runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public WorkflowExecution build() {
            return new WorkflowExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
