/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.ActivityType;
import software.amazon.awssdk.services.swf.model.SwfResponse;
import software.amazon.awssdk.services.swf.model.WorkflowExecution;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PollForActivityTaskResponse
extends SwfResponse
implements ToCopyableBuilder<Builder, PollForActivityTaskResponse> {
    private static final SdkField<String> TASK_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PollForActivityTaskResponse.getter(PollForActivityTaskResponse::taskToken)).setter(PollForActivityTaskResponse.setter(Builder::taskToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskToken").build()}).build();
    private static final SdkField<String> ACTIVITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PollForActivityTaskResponse.getter(PollForActivityTaskResponse::activityId)).setter(PollForActivityTaskResponse.setter(Builder::activityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityId").build()}).build();
    private static final SdkField<Long> STARTED_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(PollForActivityTaskResponse.getter(PollForActivityTaskResponse::startedEventId)).setter(PollForActivityTaskResponse.setter(Builder::startedEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedEventId").build()}).build();
    private static final SdkField<WorkflowExecution> WORKFLOW_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PollForActivityTaskResponse.getter(PollForActivityTaskResponse::workflowExecution)).setter(PollForActivityTaskResponse.setter(Builder::workflowExecution)).constructor(WorkflowExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowExecution").build()}).build();
    private static final SdkField<ActivityType> ACTIVITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PollForActivityTaskResponse.getter(PollForActivityTaskResponse::activityType)).setter(PollForActivityTaskResponse.setter(Builder::activityType)).constructor(ActivityType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityType").build()}).build();
    private static final SdkField<String> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PollForActivityTaskResponse.getter(PollForActivityTaskResponse::input)).setter(PollForActivityTaskResponse.setter(Builder::input)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_TOKEN_FIELD, ACTIVITY_ID_FIELD, STARTED_EVENT_ID_FIELD, WORKFLOW_EXECUTION_FIELD, ACTIVITY_TYPE_FIELD, INPUT_FIELD));
    private final String taskToken;
    private final String activityId;
    private final Long startedEventId;
    private final WorkflowExecution workflowExecution;
    private final ActivityType activityType;
    private final String input;

    private PollForActivityTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskToken = builder.taskToken;
        this.activityId = builder.activityId;
        this.startedEventId = builder.startedEventId;
        this.workflowExecution = builder.workflowExecution;
        this.activityType = builder.activityType;
        this.input = builder.input;
    }

    public String taskToken() {
        return this.taskToken;
    }

    public String activityId() {
        return this.activityId;
    }

    public Long startedEventId() {
        return this.startedEventId;
    }

    public WorkflowExecution workflowExecution() {
        return this.workflowExecution;
    }

    public ActivityType activityType() {
        return this.activityType;
    }

    public String input() {
        return this.input;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.activityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowExecution());
        hashCode = 31 * hashCode + Objects.hashCode(this.activityType());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForActivityTaskResponse)) {
            return false;
        }
        PollForActivityTaskResponse other = (PollForActivityTaskResponse)((Object)obj);
        return Objects.equals(this.taskToken(), other.taskToken()) && Objects.equals(this.activityId(), other.activityId()) && Objects.equals(this.startedEventId(), other.startedEventId()) && Objects.equals(this.workflowExecution(), other.workflowExecution()) && Objects.equals(this.activityType(), other.activityType()) && Objects.equals(this.input(), other.input());
    }

    public String toString() {
        return ToString.builder((String)"PollForActivityTaskResponse").add("TaskToken", (Object)this.taskToken()).add("ActivityId", (Object)this.activityId()).add("StartedEventId", (Object)this.startedEventId()).add("WorkflowExecution", (Object)this.workflowExecution()).add("ActivityType", (Object)this.activityType()).add("Input", (Object)this.input()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskToken": {
                return Optional.ofNullable(clazz.cast(this.taskToken()));
            }
            case "activityId": {
                return Optional.ofNullable(clazz.cast(this.activityId()));
            }
            case "startedEventId": {
                return Optional.ofNullable(clazz.cast(this.startedEventId()));
            }
            case "workflowExecution": {
                return Optional.ofNullable(clazz.cast(this.workflowExecution()));
            }
            case "activityType": {
                return Optional.ofNullable(clazz.cast(this.activityType()));
            }
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PollForActivityTaskResponse, T> g) {
        return obj -> g.apply((PollForActivityTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfResponse.BuilderImpl
    implements Builder {
        private String taskToken;
        private String activityId;
        private Long startedEventId;
        private WorkflowExecution workflowExecution;
        private ActivityType activityType;
        private String input;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForActivityTaskResponse model) {
            super(model);
            this.taskToken(model.taskToken);
            this.activityId(model.activityId);
            this.startedEventId(model.startedEventId);
            this.workflowExecution(model.workflowExecution);
            this.activityType(model.activityType);
            this.input(model.input);
        }

        public final String getTaskToken() {
            return this.taskToken;
        }

        @Override
        public final Builder taskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public final void setTaskToken(String taskToken) {
            this.taskToken = taskToken;
        }

        public final String getActivityId() {
            return this.activityId;
        }

        @Override
        public final Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public final void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        public final Long getStartedEventId() {
            return this.startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        public final WorkflowExecution.Builder getWorkflowExecution() {
            return this.workflowExecution != null ? this.workflowExecution.toBuilder() : null;
        }

        @Override
        public final Builder workflowExecution(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
            return this;
        }

        public final void setWorkflowExecution(WorkflowExecution.BuilderImpl workflowExecution) {
            this.workflowExecution = workflowExecution != null ? workflowExecution.build() : null;
        }

        public final ActivityType.Builder getActivityType() {
            return this.activityType != null ? this.activityType.toBuilder() : null;
        }

        @Override
        public final Builder activityType(ActivityType activityType) {
            this.activityType = activityType;
            return this;
        }

        public final void setActivityType(ActivityType.BuilderImpl activityType) {
            this.activityType = activityType != null ? activityType.build() : null;
        }

        public final String getInput() {
            return this.input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public PollForActivityTaskResponse build() {
            return new PollForActivityTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SwfResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PollForActivityTaskResponse> {
        public Builder taskToken(String var1);

        public Builder activityId(String var1);

        public Builder startedEventId(Long var1);

        public Builder workflowExecution(WorkflowExecution var1);

        default public Builder workflowExecution(Consumer<WorkflowExecution.Builder> workflowExecution) {
            return this.workflowExecution((WorkflowExecution)((WorkflowExecution.Builder)WorkflowExecution.builder().applyMutation(workflowExecution)).build());
        }

        public Builder activityType(ActivityType var1);

        default public Builder activityType(Consumer<ActivityType.Builder> activityType) {
            return this.activityType((ActivityType)((ActivityType.Builder)ActivityType.builder().applyMutation(activityType)).build());
        }

        public Builder input(String var1);
    }
}

