/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>ActivityTaskCanceled</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActivityTaskCanceledEventAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<ActivityTaskCanceledEventAttributes.Builder, ActivityTaskCanceledEventAttributes> {
    private static final SdkField<String> DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivityTaskCanceledEventAttributes::details)).setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()).build();

    private static final SdkField<Long> SCHEDULED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ActivityTaskCanceledEventAttributes::scheduledEventId)).setter(setter(Builder::scheduledEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledEventId").build()).build();

    private static final SdkField<Long> STARTED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ActivityTaskCanceledEventAttributes::startedEventId)).setter(setter(Builder::startedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedEventId").build()).build();

    private static final SdkField<Long> LATEST_CANCEL_REQUESTED_EVENT_ID_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(ActivityTaskCanceledEventAttributes::latestCancelRequestedEventId))
            .setter(setter(Builder::latestCancelRequestedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestCancelRequestedEventId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILS_FIELD,
            SCHEDULED_EVENT_ID_FIELD, STARTED_EVENT_ID_FIELD, LATEST_CANCEL_REQUESTED_EVENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String details;

    private final Long scheduledEventId;

    private final Long startedEventId;

    private final Long latestCancelRequestedEventId;

    private ActivityTaskCanceledEventAttributes(BuilderImpl builder) {
        this.details = builder.details;
        this.scheduledEventId = builder.scheduledEventId;
        this.startedEventId = builder.startedEventId;
        this.latestCancelRequestedEventId = builder.latestCancelRequestedEventId;
    }

    /**
     * <p>
     * Details of the cancellation.
     * </p>
     * 
     * @return Details of the cancellation.
     */
    public String details() {
        return details;
    }

    /**
     * <p>
     * The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled.
     * This information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     * event.
     * </p>
     * 
     * @return The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was
     *         scheduled. This information can be useful for diagnosing problems by tracing back the chain of events
     *         leading up to this event.
     */
    public Long scheduledEventId() {
        return scheduledEventId;
    }

    /**
     * <p>
     * The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
     * information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
     *         information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     *         event.
     */
    public Long startedEventId() {
        return startedEventId;
    }

    /**
     * <p>
     * If set, contains the ID of the last <code>ActivityTaskCancelRequested</code> event recorded for this activity
     * task. This information can be useful for diagnosing problems by tracing back the chain of events leading up to
     * this event.
     * </p>
     * 
     * @return If set, contains the ID of the last <code>ActivityTaskCancelRequested</code> event recorded for this
     *         activity task. This information can be useful for diagnosing problems by tracing back the chain of events
     *         leading up to this event.
     */
    public Long latestCancelRequestedEventId() {
        return latestCancelRequestedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledEventId());
        hashCode = 31 * hashCode + Objects.hashCode(startedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(latestCancelRequestedEventId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityTaskCanceledEventAttributes)) {
            return false;
        }
        ActivityTaskCanceledEventAttributes other = (ActivityTaskCanceledEventAttributes) obj;
        return Objects.equals(details(), other.details()) && Objects.equals(scheduledEventId(), other.scheduledEventId())
                && Objects.equals(startedEventId(), other.startedEventId())
                && Objects.equals(latestCancelRequestedEventId(), other.latestCancelRequestedEventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ActivityTaskCanceledEventAttributes").add("Details", details())
                .add("ScheduledEventId", scheduledEventId()).add("StartedEventId", startedEventId())
                .add("LatestCancelRequestedEventId", latestCancelRequestedEventId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        case "scheduledEventId":
            return Optional.ofNullable(clazz.cast(scheduledEventId()));
        case "startedEventId":
            return Optional.ofNullable(clazz.cast(startedEventId()));
        case "latestCancelRequestedEventId":
            return Optional.ofNullable(clazz.cast(latestCancelRequestedEventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivityTaskCanceledEventAttributes, T> g) {
        return obj -> g.apply((ActivityTaskCanceledEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActivityTaskCanceledEventAttributes> {
        /**
         * <p>
         * Details of the cancellation.
         * </p>
         * 
         * @param details
         *        Details of the cancellation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);

        /**
         * <p>
         * The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was
         * scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading
         * up to this event.
         * </p>
         * 
         * @param scheduledEventId
         *        The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was
         *        scheduled. This information can be useful for diagnosing problems by tracing back the chain of events
         *        leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledEventId(Long scheduledEventId);

        /**
         * <p>
         * The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
         * information can be useful for diagnosing problems by tracing back the chain of events leading up to this
         * event.
         * </p>
         * 
         * @param startedEventId
         *        The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started.
         *        This information can be useful for diagnosing problems by tracing back the chain of events leading up
         *        to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedEventId(Long startedEventId);

        /**
         * <p>
         * If set, contains the ID of the last <code>ActivityTaskCancelRequested</code> event recorded for this activity
         * task. This information can be useful for diagnosing problems by tracing back the chain of events leading up
         * to this event.
         * </p>
         * 
         * @param latestCancelRequestedEventId
         *        If set, contains the ID of the last <code>ActivityTaskCancelRequested</code> event recorded for this
         *        activity task. This information can be useful for diagnosing problems by tracing back the chain of
         *        events leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestCancelRequestedEventId(Long latestCancelRequestedEventId);
    }

    static final class BuilderImpl implements Builder {
        private String details;

        private Long scheduledEventId;

        private Long startedEventId;

        private Long latestCancelRequestedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivityTaskCanceledEventAttributes model) {
            details(model.details);
            scheduledEventId(model.scheduledEventId);
            startedEventId(model.startedEventId);
            latestCancelRequestedEventId(model.latestCancelRequestedEventId);
        }

        public final String getDetails() {
            return details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        public final Long getScheduledEventId() {
            return scheduledEventId;
        }

        @Override
        public final Builder scheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
            return this;
        }

        public final void setScheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
        }

        public final Long getStartedEventId() {
            return startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        public final Long getLatestCancelRequestedEventId() {
            return latestCancelRequestedEventId;
        }

        @Override
        public final Builder latestCancelRequestedEventId(Long latestCancelRequestedEventId) {
            this.latestCancelRequestedEventId = latestCancelRequestedEventId;
            return this;
        }

        public final void setLatestCancelRequestedEventId(Long latestCancelRequestedEventId) {
            this.latestCancelRequestedEventId = latestCancelRequestedEventId;
        }

        @Override
        public ActivityTaskCanceledEventAttributes build() {
            return new ActivityTaskCanceledEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
