/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterDomainRequest extends SwfRequest implements
        ToCopyableBuilder<RegisterDomainRequest.Builder, RegisterDomainRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterDomainRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterDomainRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> WORKFLOW_EXECUTION_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterDomainRequest::workflowExecutionRetentionPeriodInDays))
            .setter(setter(Builder::workflowExecutionRetentionPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("workflowExecutionRetentionPeriodInDays").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            WORKFLOW_EXECUTION_RETENTION_PERIOD_IN_DAYS_FIELD));

    private final String name;

    private final String description;

    private final String workflowExecutionRetentionPeriodInDays;

    private RegisterDomainRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.workflowExecutionRetentionPeriodInDays = builder.workflowExecutionRetentionPeriodInDays;
    }

    /**
     * <p>
     * Name of the domain to register. The name must be unique in the region that the domain is registered in.
     * </p>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> |
     * <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.
     * </p>
     * 
     * @return Name of the domain to register. The name must be unique in the region that the domain is registered
     *         in.</p>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (
     *         <code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string
     *         <code>arn</code>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A text description of the domain.
     * </p>
     * 
     * @return A text description of the domain.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The duration (in days) that records and histories of workflow executions on the domain should be kept by the
     * service. After the retention period, the workflow execution isn't available in the results of visibility calls.
     * </p>
     * <p>
     * If you pass the value <code>NONE</code> or <code>0</code> (zero), then the workflow execution history isn't
     * retained. As soon as the workflow execution completes, the execution record and its history are deleted.
     * </p>
     * <p>
     * The maximum workflow execution retention period is 90 days. For more information about Amazon SWF service limits,
     * see: <a href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html">Amazon SWF Service
     * Limits</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * 
     * @return The duration (in days) that records and histories of workflow executions on the domain should be kept by
     *         the service. After the retention period, the workflow execution isn't available in the results of
     *         visibility calls.</p>
     *         <p>
     *         If you pass the value <code>NONE</code> or <code>0</code> (zero), then the workflow execution history
     *         isn't retained. As soon as the workflow execution completes, the execution record and its history are
     *         deleted.
     *         </p>
     *         <p>
     *         The maximum workflow execution retention period is 90 days. For more information about Amazon SWF service
     *         limits, see: <a
     *         href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html">Amazon SWF Service
     *         Limits</a> in the <i>Amazon SWF Developer Guide</i>.
     */
    public String workflowExecutionRetentionPeriodInDays() {
        return workflowExecutionRetentionPeriodInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(workflowExecutionRetentionPeriodInDays());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterDomainRequest)) {
            return false;
        }
        RegisterDomainRequest other = (RegisterDomainRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(workflowExecutionRetentionPeriodInDays(), other.workflowExecutionRetentionPeriodInDays());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RegisterDomainRequest").add("Name", name()).add("Description", description())
                .add("WorkflowExecutionRetentionPeriodInDays", workflowExecutionRetentionPeriodInDays()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "workflowExecutionRetentionPeriodInDays":
            return Optional.ofNullable(clazz.cast(workflowExecutionRetentionPeriodInDays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterDomainRequest, T> g) {
        return obj -> g.apply((RegisterDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterDomainRequest> {
        /**
         * <p>
         * Name of the domain to register. The name must be unique in the region that the domain is registered in.
         * </p>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code>
         * | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.
         * </p>
         * 
         * @param name
         *        Name of the domain to register. The name must be unique in the region that the domain is registered
         *        in.</p>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (
         *        <code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string
         *        <code>arn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A text description of the domain.
         * </p>
         * 
         * @param description
         *        A text description of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The duration (in days) that records and histories of workflow executions on the domain should be kept by the
         * service. After the retention period, the workflow execution isn't available in the results of visibility
         * calls.
         * </p>
         * <p>
         * If you pass the value <code>NONE</code> or <code>0</code> (zero), then the workflow execution history isn't
         * retained. As soon as the workflow execution completes, the execution record and its history are deleted.
         * </p>
         * <p>
         * The maximum workflow execution retention period is 90 days. For more information about Amazon SWF service
         * limits, see: <a href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html">Amazon
         * SWF Service Limits</a> in the <i>Amazon SWF Developer Guide</i>.
         * </p>
         * 
         * @param workflowExecutionRetentionPeriodInDays
         *        The duration (in days) that records and histories of workflow executions on the domain should be kept
         *        by the service. After the retention period, the workflow execution isn't available in the results of
         *        visibility calls.</p>
         *        <p>
         *        If you pass the value <code>NONE</code> or <code>0</code> (zero), then the workflow execution history
         *        isn't retained. As soon as the workflow execution completes, the execution record and its history are
         *        deleted.
         *        </p>
         *        <p>
         *        The maximum workflow execution retention period is 90 days. For more information about Amazon SWF
         *        service limits, see: <a
         *        href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html">Amazon SWF
         *        Service Limits</a> in the <i>Amazon SWF Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionRetentionPeriodInDays(String workflowExecutionRetentionPeriodInDays);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SwfRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String workflowExecutionRetentionPeriodInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterDomainRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            workflowExecutionRetentionPeriodInDays(model.workflowExecutionRetentionPeriodInDays);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getWorkflowExecutionRetentionPeriodInDays() {
            return workflowExecutionRetentionPeriodInDays;
        }

        @Override
        public final Builder workflowExecutionRetentionPeriodInDays(String workflowExecutionRetentionPeriodInDays) {
            this.workflowExecutionRetentionPeriodInDays = workflowExecutionRetentionPeriodInDays;
            return this;
        }

        public final void setWorkflowExecutionRetentionPeriodInDays(String workflowExecutionRetentionPeriodInDays) {
            this.workflowExecutionRetentionPeriodInDays = workflowExecutionRetentionPeriodInDays;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterDomainRequest build() {
            return new RegisterDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
