/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details of a domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDomainResponse extends SwfResponse implements
        ToCopyableBuilder<DescribeDomainResponse.Builder, DescribeDomainResponse> {
    private static final SdkField<DomainInfo> DOMAIN_INFO_FIELD = SdkField.<DomainInfo> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeDomainResponse::domainInfo)).setter(setter(Builder::domainInfo))
            .constructor(DomainInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainInfo").build()).build();

    private static final SdkField<DomainConfiguration> CONFIGURATION_FIELD = SdkField
            .<DomainConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(DescribeDomainResponse::configuration))
            .setter(setter(Builder::configuration)).constructor(DomainConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_INFO_FIELD,
            CONFIGURATION_FIELD));

    private final DomainInfo domainInfo;

    private final DomainConfiguration configuration;

    private DescribeDomainResponse(BuilderImpl builder) {
        super(builder);
        this.domainInfo = builder.domainInfo;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The basic information about a domain, such as its name, status, and description.
     * </p>
     * 
     * @return The basic information about a domain, such as its name, status, and description.
     */
    public DomainInfo domainInfo() {
        return domainInfo;
    }

    /**
     * <p>
     * The domain configuration. Currently, this includes only the domain's retention period.
     * </p>
     * 
     * @return The domain configuration. Currently, this includes only the domain's retention period.
     */
    public DomainConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainResponse)) {
            return false;
        }
        DescribeDomainResponse other = (DescribeDomainResponse) obj;
        return Objects.equals(domainInfo(), other.domainInfo()) && Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDomainResponse").add("DomainInfo", domainInfo()).add("Configuration", configuration())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainInfo":
            return Optional.ofNullable(clazz.cast(domainInfo()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainResponse, T> g) {
        return obj -> g.apply((DescribeDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDomainResponse> {
        /**
         * <p>
         * The basic information about a domain, such as its name, status, and description.
         * </p>
         * 
         * @param domainInfo
         *        The basic information about a domain, such as its name, status, and description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainInfo(DomainInfo domainInfo);

        /**
         * <p>
         * The basic information about a domain, such as its name, status, and description.
         * </p>
         * This is a convenience that creates an instance of the {@link DomainInfo.Builder} avoiding the need to create
         * one manually via {@link DomainInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link DomainInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #domainInfo(DomainInfo)}.
         * 
         * @param domainInfo
         *        a consumer that will call methods on {@link DomainInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainInfo(DomainInfo)
         */
        default Builder domainInfo(Consumer<DomainInfo.Builder> domainInfo) {
            return domainInfo(DomainInfo.builder().applyMutation(domainInfo).build());
        }

        /**
         * <p>
         * The domain configuration. Currently, this includes only the domain's retention period.
         * </p>
         * 
         * @param configuration
         *        The domain configuration. Currently, this includes only the domain's retention period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(DomainConfiguration configuration);

        /**
         * <p>
         * The domain configuration. Currently, this includes only the domain's retention period.
         * </p>
         * This is a convenience that creates an instance of the {@link DomainConfiguration.Builder} avoiding the need
         * to create one manually via {@link DomainConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DomainConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #configuration(DomainConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link DomainConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(DomainConfiguration)
         */
        default Builder configuration(Consumer<DomainConfiguration.Builder> configuration) {
            return configuration(DomainConfiguration.builder().applyMutation(configuration).build());
        }
    }

    static final class BuilderImpl extends SwfResponse.BuilderImpl implements Builder {
        private DomainInfo domainInfo;

        private DomainConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainResponse model) {
            super(model);
            domainInfo(model.domainInfo);
            configuration(model.configuration);
        }

        public final DomainInfo.Builder getDomainInfo() {
            return domainInfo != null ? domainInfo.toBuilder() : null;
        }

        @Override
        public final Builder domainInfo(DomainInfo domainInfo) {
            this.domainInfo = domainInfo;
            return this;
        }

        public final void setDomainInfo(DomainInfo.BuilderImpl domainInfo) {
            this.domainInfo = domainInfo != null ? domainInfo.build() : null;
        }

        public final DomainConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(DomainConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(DomainConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public DescribeDomainResponse build() {
            return new DescribeDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
