/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CountOpenWorkflowExecutionsRequest extends SwfRequest implements
        ToCopyableBuilder<CountOpenWorkflowExecutionsRequest.Builder, CountOpenWorkflowExecutionsRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CountOpenWorkflowExecutionsRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final SdkField<ExecutionTimeFilter> START_TIME_FILTER_FIELD = SdkField
            .<ExecutionTimeFilter> builder(MarshallingType.SDK_POJO)
            .getter(getter(CountOpenWorkflowExecutionsRequest::startTimeFilter)).setter(setter(Builder::startTimeFilter))
            .constructor(ExecutionTimeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeFilter").build()).build();

    private static final SdkField<WorkflowTypeFilter> TYPE_FILTER_FIELD = SdkField
            .<WorkflowTypeFilter> builder(MarshallingType.SDK_POJO)
            .getter(getter(CountOpenWorkflowExecutionsRequest::typeFilter)).setter(setter(Builder::typeFilter))
            .constructor(WorkflowTypeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeFilter").build()).build();

    private static final SdkField<TagFilter> TAG_FILTER_FIELD = SdkField.<TagFilter> builder(MarshallingType.SDK_POJO)
            .getter(getter(CountOpenWorkflowExecutionsRequest::tagFilter)).setter(setter(Builder::tagFilter))
            .constructor(TagFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilter").build()).build();

    private static final SdkField<WorkflowExecutionFilter> EXECUTION_FILTER_FIELD = SdkField
            .<WorkflowExecutionFilter> builder(MarshallingType.SDK_POJO)
            .getter(getter(CountOpenWorkflowExecutionsRequest::executionFilter)).setter(setter(Builder::executionFilter))
            .constructor(WorkflowExecutionFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            START_TIME_FILTER_FIELD, TYPE_FILTER_FIELD, TAG_FILTER_FIELD, EXECUTION_FILTER_FIELD));

    private final String domain;

    private final ExecutionTimeFilter startTimeFilter;

    private final WorkflowTypeFilter typeFilter;

    private final TagFilter tagFilter;

    private final WorkflowExecutionFilter executionFilter;

    private CountOpenWorkflowExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.startTimeFilter = builder.startTimeFilter;
        this.typeFilter = builder.typeFilter;
        this.tagFilter = builder.tagFilter;
        this.executionFilter = builder.executionFilter;
    }

    /**
     * <p>
     * The name of the domain containing the workflow executions to count.
     * </p>
     * 
     * @return The name of the domain containing the workflow executions to count.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * Specifies the start time criteria that workflow executions must meet in order to be counted.
     * </p>
     * 
     * @return Specifies the start time criteria that workflow executions must meet in order to be counted.
     */
    public ExecutionTimeFilter startTimeFilter() {
        return startTimeFilter;
    }

    /**
     * <p>
     * Specifies the type of the workflow executions to be counted.
     * </p>
     * <note>
     * <p>
     * <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can
     * specify at most one of these in a request.
     * </p>
     * </note>
     * 
     * @return Specifies the type of the workflow executions to be counted.</p> <note>
     *         <p>
     *         <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive.
     *         You can specify at most one of these in a request.
     *         </p>
     */
    public WorkflowTypeFilter typeFilter() {
        return typeFilter;
    }

    /**
     * <p>
     * If specified, only executions that have a tag that matches the filter are counted.
     * </p>
     * <note>
     * <p>
     * <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can
     * specify at most one of these in a request.
     * </p>
     * </note>
     * 
     * @return If specified, only executions that have a tag that matches the filter are counted.</p> <note>
     *         <p>
     *         <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive.
     *         You can specify at most one of these in a request.
     *         </p>
     */
    public TagFilter tagFilter() {
        return tagFilter;
    }

    /**
     * <p>
     * If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are counted.
     * </p>
     * <note>
     * <p>
     * <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can
     * specify at most one of these in a request.
     * </p>
     * </note>
     * 
     * @return If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are
     *         counted.</p> <note>
     *         <p>
     *         <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive.
     *         You can specify at most one of these in a request.
     *         </p>
     */
    public WorkflowExecutionFilter executionFilter() {
        return executionFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(typeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(tagFilter());
        hashCode = 31 * hashCode + Objects.hashCode(executionFilter());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CountOpenWorkflowExecutionsRequest)) {
            return false;
        }
        CountOpenWorkflowExecutionsRequest other = (CountOpenWorkflowExecutionsRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(startTimeFilter(), other.startTimeFilter())
                && Objects.equals(typeFilter(), other.typeFilter()) && Objects.equals(tagFilter(), other.tagFilter())
                && Objects.equals(executionFilter(), other.executionFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CountOpenWorkflowExecutionsRequest").add("Domain", domain())
                .add("StartTimeFilter", startTimeFilter()).add("TypeFilter", typeFilter()).add("TagFilter", tagFilter())
                .add("ExecutionFilter", executionFilter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "startTimeFilter":
            return Optional.ofNullable(clazz.cast(startTimeFilter()));
        case "typeFilter":
            return Optional.ofNullable(clazz.cast(typeFilter()));
        case "tagFilter":
            return Optional.ofNullable(clazz.cast(tagFilter()));
        case "executionFilter":
            return Optional.ofNullable(clazz.cast(executionFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CountOpenWorkflowExecutionsRequest, T> g) {
        return obj -> g.apply((CountOpenWorkflowExecutionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfRequest.Builder, SdkPojo, CopyableBuilder<Builder, CountOpenWorkflowExecutionsRequest> {
        /**
         * <p>
         * The name of the domain containing the workflow executions to count.
         * </p>
         * 
         * @param domain
         *        The name of the domain containing the workflow executions to count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * Specifies the start time criteria that workflow executions must meet in order to be counted.
         * </p>
         * 
         * @param startTimeFilter
         *        Specifies the start time criteria that workflow executions must meet in order to be counted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeFilter(ExecutionTimeFilter startTimeFilter);

        /**
         * <p>
         * Specifies the start time criteria that workflow executions must meet in order to be counted.
         * </p>
         * This is a convenience that creates an instance of the {@link ExecutionTimeFilter.Builder} avoiding the need
         * to create one manually via {@link ExecutionTimeFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExecutionTimeFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #startTimeFilter(ExecutionTimeFilter)}.
         * 
         * @param startTimeFilter
         *        a consumer that will call methods on {@link ExecutionTimeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startTimeFilter(ExecutionTimeFilter)
         */
        default Builder startTimeFilter(Consumer<ExecutionTimeFilter.Builder> startTimeFilter) {
            return startTimeFilter(ExecutionTimeFilter.builder().applyMutation(startTimeFilter).build());
        }

        /**
         * <p>
         * Specifies the type of the workflow executions to be counted.
         * </p>
         * <note>
         * <p>
         * <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You
         * can specify at most one of these in a request.
         * </p>
         * </note>
         * 
         * @param typeFilter
         *        Specifies the type of the workflow executions to be counted.</p> <note>
         *        <p>
         *        <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually
         *        exclusive. You can specify at most one of these in a request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeFilter(WorkflowTypeFilter typeFilter);

        /**
         * <p>
         * Specifies the type of the workflow executions to be counted.
         * </p>
         * <note>
         * <p>
         * <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You
         * can specify at most one of these in a request.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link WorkflowTypeFilter.Builder} avoiding the
         * need to create one manually via {@link WorkflowTypeFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowTypeFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #typeFilter(WorkflowTypeFilter)}.
         * 
         * @param typeFilter
         *        a consumer that will call methods on {@link WorkflowTypeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #typeFilter(WorkflowTypeFilter)
         */
        default Builder typeFilter(Consumer<WorkflowTypeFilter.Builder> typeFilter) {
            return typeFilter(WorkflowTypeFilter.builder().applyMutation(typeFilter).build());
        }

        /**
         * <p>
         * If specified, only executions that have a tag that matches the filter are counted.
         * </p>
         * <note>
         * <p>
         * <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You
         * can specify at most one of these in a request.
         * </p>
         * </note>
         * 
         * @param tagFilter
         *        If specified, only executions that have a tag that matches the filter are counted.</p> <note>
         *        <p>
         *        <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually
         *        exclusive. You can specify at most one of these in a request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilter(TagFilter tagFilter);

        /**
         * <p>
         * If specified, only executions that have a tag that matches the filter are counted.
         * </p>
         * <note>
         * <p>
         * <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You
         * can specify at most one of these in a request.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link TagFilter.Builder} avoiding the need to
         * create one manually via {@link TagFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link TagFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #tagFilter(TagFilter)}.
         * 
         * @param tagFilter
         *        a consumer that will call methods on {@link TagFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagFilter(TagFilter)
         */
        default Builder tagFilter(Consumer<TagFilter.Builder> tagFilter) {
            return tagFilter(TagFilter.builder().applyMutation(tagFilter).build());
        }

        /**
         * <p>
         * If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are counted.
         * </p>
         * <note>
         * <p>
         * <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You
         * can specify at most one of these in a request.
         * </p>
         * </note>
         * 
         * @param executionFilter
         *        If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are
         *        counted.</p> <note>
         *        <p>
         *        <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually
         *        exclusive. You can specify at most one of these in a request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionFilter(WorkflowExecutionFilter executionFilter);

        /**
         * <p>
         * If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are counted.
         * </p>
         * <note>
         * <p>
         * <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You
         * can specify at most one of these in a request.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link WorkflowExecutionFilter.Builder}
         * avoiding the need to create one manually via {@link WorkflowExecutionFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowExecutionFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #executionFilter(WorkflowExecutionFilter)}.
         * 
         * @param executionFilter
         *        a consumer that will call methods on {@link WorkflowExecutionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionFilter(WorkflowExecutionFilter)
         */
        default Builder executionFilter(Consumer<WorkflowExecutionFilter.Builder> executionFilter) {
            return executionFilter(WorkflowExecutionFilter.builder().applyMutation(executionFilter).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SwfRequest.BuilderImpl implements Builder {
        private String domain;

        private ExecutionTimeFilter startTimeFilter;

        private WorkflowTypeFilter typeFilter;

        private TagFilter tagFilter;

        private WorkflowExecutionFilter executionFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(CountOpenWorkflowExecutionsRequest model) {
            super(model);
            domain(model.domain);
            startTimeFilter(model.startTimeFilter);
            typeFilter(model.typeFilter);
            tagFilter(model.tagFilter);
            executionFilter(model.executionFilter);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final ExecutionTimeFilter.Builder getStartTimeFilter() {
            return startTimeFilter != null ? startTimeFilter.toBuilder() : null;
        }

        @Override
        public final Builder startTimeFilter(ExecutionTimeFilter startTimeFilter) {
            this.startTimeFilter = startTimeFilter;
            return this;
        }

        public final void setStartTimeFilter(ExecutionTimeFilter.BuilderImpl startTimeFilter) {
            this.startTimeFilter = startTimeFilter != null ? startTimeFilter.build() : null;
        }

        public final WorkflowTypeFilter.Builder getTypeFilter() {
            return typeFilter != null ? typeFilter.toBuilder() : null;
        }

        @Override
        public final Builder typeFilter(WorkflowTypeFilter typeFilter) {
            this.typeFilter = typeFilter;
            return this;
        }

        public final void setTypeFilter(WorkflowTypeFilter.BuilderImpl typeFilter) {
            this.typeFilter = typeFilter != null ? typeFilter.build() : null;
        }

        public final TagFilter.Builder getTagFilter() {
            return tagFilter != null ? tagFilter.toBuilder() : null;
        }

        @Override
        public final Builder tagFilter(TagFilter tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }

        public final void setTagFilter(TagFilter.BuilderImpl tagFilter) {
            this.tagFilter = tagFilter != null ? tagFilter.build() : null;
        }

        public final WorkflowExecutionFilter.Builder getExecutionFilter() {
            return executionFilter != null ? executionFilter.toBuilder() : null;
        }

        @Override
        public final Builder executionFilter(WorkflowExecutionFilter executionFilter) {
            this.executionFilter = executionFilter;
            return this;
        }

        public final void setExecutionFilter(WorkflowExecutionFilter.BuilderImpl executionFilter) {
            this.executionFilter = executionFilter != null ? executionFilter.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CountOpenWorkflowExecutionsRequest build() {
            return new CountOpenWorkflowExecutionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
