/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of <code>WorkflowExecutionStarted</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowExecutionStartedEventAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkflowExecutionStartedEventAttributes.Builder, WorkflowExecutionStartedEventAttributes> {
    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WorkflowExecutionStartedEventAttributes::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<String> EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(WorkflowExecutionStartedEventAttributes::executionStartToCloseTimeout))
            .setter(setter(Builder::executionStartToCloseTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStartToCloseTimeout")
                    .build()).build();

    private static final SdkField<String> TASK_START_TO_CLOSE_TIMEOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WorkflowExecutionStartedEventAttributes::taskStartToCloseTimeout))
            .setter(setter(Builder::taskStartToCloseTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStartToCloseTimeout").build())
            .build();

    private static final SdkField<String> CHILD_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WorkflowExecutionStartedEventAttributes::childPolicyAsString)).setter(setter(Builder::childPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childPolicy").build()).build();

    private static final SdkField<TaskList> TASK_LIST_FIELD = SdkField.<TaskList> builder(MarshallingType.SDK_POJO)
            .getter(getter(WorkflowExecutionStartedEventAttributes::taskList)).setter(setter(Builder::taskList))
            .constructor(TaskList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskList").build()).build();

    private static final SdkField<String> TASK_PRIORITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WorkflowExecutionStartedEventAttributes::taskPriority)).setter(setter(Builder::taskPriority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskPriority").build()).build();

    private static final SdkField<WorkflowType> WORKFLOW_TYPE_FIELD = SdkField.<WorkflowType> builder(MarshallingType.SDK_POJO)
            .getter(getter(WorkflowExecutionStartedEventAttributes::workflowType)).setter(setter(Builder::workflowType))
            .constructor(WorkflowType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowType").build()).build();

    private static final SdkField<List<String>> TAG_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(WorkflowExecutionStartedEventAttributes::tagList))
            .setter(setter(Builder::tagList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONTINUED_EXECUTION_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WorkflowExecutionStartedEventAttributes::continuedExecutionRunId))
            .setter(setter(Builder::continuedExecutionRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuedExecutionRunId").build())
            .build();

    private static final SdkField<WorkflowExecution> PARENT_WORKFLOW_EXECUTION_FIELD = SdkField
            .<WorkflowExecution> builder(MarshallingType.SDK_POJO)
            .getter(getter(WorkflowExecutionStartedEventAttributes::parentWorkflowExecution))
            .setter(setter(Builder::parentWorkflowExecution)).constructor(WorkflowExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentWorkflowExecution").build())
            .build();

    private static final SdkField<Long> PARENT_INITIATED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(WorkflowExecutionStartedEventAttributes::parentInitiatedEventId))
            .setter(setter(Builder::parentInitiatedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentInitiatedEventId").build())
            .build();

    private static final SdkField<String> LAMBDA_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WorkflowExecutionStartedEventAttributes::lambdaRole)).setter(setter(Builder::lambdaRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD,
            EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD, TASK_START_TO_CLOSE_TIMEOUT_FIELD, CHILD_POLICY_FIELD, TASK_LIST_FIELD,
            TASK_PRIORITY_FIELD, WORKFLOW_TYPE_FIELD, TAG_LIST_FIELD, CONTINUED_EXECUTION_RUN_ID_FIELD,
            PARENT_WORKFLOW_EXECUTION_FIELD, PARENT_INITIATED_EVENT_ID_FIELD, LAMBDA_ROLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String input;

    private final String executionStartToCloseTimeout;

    private final String taskStartToCloseTimeout;

    private final String childPolicy;

    private final TaskList taskList;

    private final String taskPriority;

    private final WorkflowType workflowType;

    private final List<String> tagList;

    private final String continuedExecutionRunId;

    private final WorkflowExecution parentWorkflowExecution;

    private final Long parentInitiatedEventId;

    private final String lambdaRole;

    private WorkflowExecutionStartedEventAttributes(BuilderImpl builder) {
        this.input = builder.input;
        this.executionStartToCloseTimeout = builder.executionStartToCloseTimeout;
        this.taskStartToCloseTimeout = builder.taskStartToCloseTimeout;
        this.childPolicy = builder.childPolicy;
        this.taskList = builder.taskList;
        this.taskPriority = builder.taskPriority;
        this.workflowType = builder.workflowType;
        this.tagList = builder.tagList;
        this.continuedExecutionRunId = builder.continuedExecutionRunId;
        this.parentWorkflowExecution = builder.parentWorkflowExecution;
        this.parentInitiatedEventId = builder.parentInitiatedEventId;
        this.lambdaRole = builder.lambdaRole;
    }

    /**
     * <p>
     * The input provided to the workflow execution.
     * </p>
     * 
     * @return The input provided to the workflow execution.
     */
    public String input() {
        return input;
    }

    /**
     * <p>
     * The maximum duration for this workflow execution.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     * <code>NONE</code> to specify unlimited duration.
     * </p>
     * 
     * @return The maximum duration for this workflow execution.</p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     *         <code>NONE</code> to specify unlimited duration.
     */
    public String executionStartToCloseTimeout() {
        return executionStartToCloseTimeout;
    }

    /**
     * <p>
     * The maximum duration of decision tasks for this workflow type.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     * <code>NONE</code> to specify unlimited duration.
     * </p>
     * 
     * @return The maximum duration of decision tasks for this workflow type.</p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     *         <code>NONE</code> to specify unlimited duration.
     */
    public String taskStartToCloseTimeout() {
        return taskStartToCloseTimeout;
    }

    /**
     * <p>
     * The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
     * <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.
     * </p>
     * <p>
     * The supported child policies are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TERMINATE</code> – The child executions are terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate
     * actions when it receives an execution history with this event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ABANDON</code> – No action is taken. The child executions continue to run.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #childPolicy} will
     * return {@link ChildPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #childPolicyAsString}.
     * </p>
     * 
     * @return The policy to use for the child workflow executions if this workflow execution is terminated, by calling
     *         the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
     *         <p>
     *         The supported child policies are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TERMINATE</code> – The child executions are terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     *         <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
     *         appropriate actions when it receives an execution history with this event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ABANDON</code> – No action is taken. The child executions continue to run.
     *         </p>
     *         </li>
     * @see ChildPolicy
     */
    public ChildPolicy childPolicy() {
        return ChildPolicy.fromValue(childPolicy);
    }

    /**
     * <p>
     * The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
     * <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.
     * </p>
     * <p>
     * The supported child policies are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TERMINATE</code> – The child executions are terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate
     * actions when it receives an execution history with this event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ABANDON</code> – No action is taken. The child executions continue to run.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #childPolicy} will
     * return {@link ChildPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #childPolicyAsString}.
     * </p>
     * 
     * @return The policy to use for the child workflow executions if this workflow execution is terminated, by calling
     *         the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
     *         <p>
     *         The supported child policies are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TERMINATE</code> – The child executions are terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     *         <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
     *         appropriate actions when it receives an execution history with this event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ABANDON</code> – No action is taken. The child executions continue to run.
     *         </p>
     *         </li>
     * @see ChildPolicy
     */
    public String childPolicyAsString() {
        return childPolicy;
    }

    /**
     * <p>
     * The name of the task list for scheduling the decision tasks for this workflow execution.
     * </p>
     * 
     * @return The name of the task list for scheduling the decision tasks for this workflow execution.
     */
    public TaskList taskList() {
        return taskList;
    }

    /**
     * <p>
     * The priority of the decision tasks in the workflow execution.
     * </p>
     * 
     * @return The priority of the decision tasks in the workflow execution.
     */
    public String taskPriority() {
        return taskPriority;
    }

    /**
     * <p>
     * The workflow type of this execution.
     * </p>
     * 
     * @return The workflow type of this execution.
     */
    public WorkflowType workflowType() {
        return workflowType;
    }

    /**
     * <p>
     * The list of tags associated with this workflow execution. An execution can have up to 5 tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of tags associated with this workflow execution. An execution can have up to 5 tags.
     */
    public List<String> tagList() {
        return tagList;
    }

    /**
     * <p>
     * If this workflow execution was started due to a <code>ContinueAsNewWorkflowExecution</code> decision, then it
     * contains the <code>runId</code> of the previous workflow execution that was closed and continued as this
     * execution.
     * </p>
     * 
     * @return If this workflow execution was started due to a <code>ContinueAsNewWorkflowExecution</code> decision,
     *         then it contains the <code>runId</code> of the previous workflow execution that was closed and continued
     *         as this execution.
     */
    public String continuedExecutionRunId() {
        return continuedExecutionRunId;
    }

    /**
     * <p>
     * The source workflow execution that started this workflow execution. The member isn't set if the workflow
     * execution was not started by a workflow.
     * </p>
     * 
     * @return The source workflow execution that started this workflow execution. The member isn't set if the workflow
     *         execution was not started by a workflow.
     */
    public WorkflowExecution parentWorkflowExecution() {
        return parentWorkflowExecution;
    }

    /**
     * <p>
     * The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
     * <code>StartChildWorkflowExecution</code> <a>Decision</a> to start this workflow execution. The source event with
     * this ID can be found in the history of the source workflow execution. This information can be useful for
     * diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
     *         <code>StartChildWorkflowExecution</code> <a>Decision</a> to start this workflow execution. The source
     *         event with this ID can be found in the history of the source workflow execution. This information can be
     *         useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public Long parentInitiatedEventId() {
        return parentInitiatedEventId;
    }

    /**
     * <p>
     * The IAM role attached to the workflow execution.
     * </p>
     * 
     * @return The IAM role attached to the workflow execution.
     */
    public String lambdaRole() {
        return lambdaRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(executionStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(taskStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(childPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(taskList());
        hashCode = 31 * hashCode + Objects.hashCode(taskPriority());
        hashCode = 31 * hashCode + Objects.hashCode(workflowType());
        hashCode = 31 * hashCode + Objects.hashCode(tagList());
        hashCode = 31 * hashCode + Objects.hashCode(continuedExecutionRunId());
        hashCode = 31 * hashCode + Objects.hashCode(parentWorkflowExecution());
        hashCode = 31 * hashCode + Objects.hashCode(parentInitiatedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaRole());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionStartedEventAttributes)) {
            return false;
        }
        WorkflowExecutionStartedEventAttributes other = (WorkflowExecutionStartedEventAttributes) obj;
        return Objects.equals(input(), other.input())
                && Objects.equals(executionStartToCloseTimeout(), other.executionStartToCloseTimeout())
                && Objects.equals(taskStartToCloseTimeout(), other.taskStartToCloseTimeout())
                && Objects.equals(childPolicyAsString(), other.childPolicyAsString())
                && Objects.equals(taskList(), other.taskList()) && Objects.equals(taskPriority(), other.taskPriority())
                && Objects.equals(workflowType(), other.workflowType()) && Objects.equals(tagList(), other.tagList())
                && Objects.equals(continuedExecutionRunId(), other.continuedExecutionRunId())
                && Objects.equals(parentWorkflowExecution(), other.parentWorkflowExecution())
                && Objects.equals(parentInitiatedEventId(), other.parentInitiatedEventId())
                && Objects.equals(lambdaRole(), other.lambdaRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("WorkflowExecutionStartedEventAttributes").add("Input", input())
                .add("ExecutionStartToCloseTimeout", executionStartToCloseTimeout())
                .add("TaskStartToCloseTimeout", taskStartToCloseTimeout()).add("ChildPolicy", childPolicyAsString())
                .add("TaskList", taskList()).add("TaskPriority", taskPriority()).add("WorkflowType", workflowType())
                .add("TagList", tagList()).add("ContinuedExecutionRunId", continuedExecutionRunId())
                .add("ParentWorkflowExecution", parentWorkflowExecution())
                .add("ParentInitiatedEventId", parentInitiatedEventId()).add("LambdaRole", lambdaRole()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "executionStartToCloseTimeout":
            return Optional.ofNullable(clazz.cast(executionStartToCloseTimeout()));
        case "taskStartToCloseTimeout":
            return Optional.ofNullable(clazz.cast(taskStartToCloseTimeout()));
        case "childPolicy":
            return Optional.ofNullable(clazz.cast(childPolicyAsString()));
        case "taskList":
            return Optional.ofNullable(clazz.cast(taskList()));
        case "taskPriority":
            return Optional.ofNullable(clazz.cast(taskPriority()));
        case "workflowType":
            return Optional.ofNullable(clazz.cast(workflowType()));
        case "tagList":
            return Optional.ofNullable(clazz.cast(tagList()));
        case "continuedExecutionRunId":
            return Optional.ofNullable(clazz.cast(continuedExecutionRunId()));
        case "parentWorkflowExecution":
            return Optional.ofNullable(clazz.cast(parentWorkflowExecution()));
        case "parentInitiatedEventId":
            return Optional.ofNullable(clazz.cast(parentInitiatedEventId()));
        case "lambdaRole":
            return Optional.ofNullable(clazz.cast(lambdaRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowExecutionStartedEventAttributes, T> g) {
        return obj -> g.apply((WorkflowExecutionStartedEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowExecutionStartedEventAttributes> {
        /**
         * <p>
         * The input provided to the workflow execution.
         * </p>
         * 
         * @param input
         *        The input provided to the workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * The maximum duration for this workflow execution.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         * <code>NONE</code> to specify unlimited duration.
         * </p>
         * 
         * @param executionStartToCloseTimeout
         *        The maximum duration for this workflow execution.</p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         *        <code>NONE</code> to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartToCloseTimeout(String executionStartToCloseTimeout);

        /**
         * <p>
         * The maximum duration of decision tasks for this workflow type.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         * <code>NONE</code> to specify unlimited duration.
         * </p>
         * 
         * @param taskStartToCloseTimeout
         *        The maximum duration of decision tasks for this workflow type.</p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         *        <code>NONE</code> to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStartToCloseTimeout(String taskStartToCloseTimeout);

        /**
         * <p>
         * The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
         * <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TERMINATE</code> – The child executions are terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ABANDON</code> – No action is taken. The child executions continue to run.
         * </p>
         * </li>
         * </ul>
         * 
         * @param childPolicy
         *        The policy to use for the child workflow executions if this workflow execution is terminated, by
         *        calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TERMINATE</code> – The child executions are terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         *        <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ABANDON</code> – No action is taken. The child executions continue to run.
         *        </p>
         *        </li>
         * @see ChildPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(String childPolicy);

        /**
         * <p>
         * The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
         * <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TERMINATE</code> – The child executions are terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ABANDON</code> – No action is taken. The child executions continue to run.
         * </p>
         * </li>
         * </ul>
         * 
         * @param childPolicy
         *        The policy to use for the child workflow executions if this workflow execution is terminated, by
         *        calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TERMINATE</code> – The child executions are terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         *        <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ABANDON</code> – No action is taken. The child executions continue to run.
         *        </p>
         *        </li>
         * @see ChildPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(ChildPolicy childPolicy);

        /**
         * <p>
         * The name of the task list for scheduling the decision tasks for this workflow execution.
         * </p>
         * 
         * @param taskList
         *        The name of the task list for scheduling the decision tasks for this workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskList(TaskList taskList);

        /**
         * <p>
         * The name of the task list for scheduling the decision tasks for this workflow execution.
         * </p>
         * This is a convenience that creates an instance of the {@link TaskList.Builder} avoiding the need to create
         * one manually via {@link TaskList#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskList.Builder#build()} is called immediately and its result is
         * passed to {@link #taskList(TaskList)}.
         * 
         * @param taskList
         *        a consumer that will call methods on {@link TaskList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskList(TaskList)
         */
        default Builder taskList(Consumer<TaskList.Builder> taskList) {
            return taskList(TaskList.builder().applyMutation(taskList).build());
        }

        /**
         * <p>
         * The priority of the decision tasks in the workflow execution.
         * </p>
         * 
         * @param taskPriority
         *        The priority of the decision tasks in the workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskPriority(String taskPriority);

        /**
         * <p>
         * The workflow type of this execution.
         * </p>
         * 
         * @param workflowType
         *        The workflow type of this execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowType(WorkflowType workflowType);

        /**
         * <p>
         * The workflow type of this execution.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkflowType.Builder} avoiding the need to
         * create one manually via {@link WorkflowType#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowType.Builder#build()} is called immediately and its
         * result is passed to {@link #workflowType(WorkflowType)}.
         * 
         * @param workflowType
         *        a consumer that will call methods on {@link WorkflowType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowType(WorkflowType)
         */
        default Builder workflowType(Consumer<WorkflowType.Builder> workflowType) {
            return workflowType(WorkflowType.builder().applyMutation(workflowType).build());
        }

        /**
         * <p>
         * The list of tags associated with this workflow execution. An execution can have up to 5 tags.
         * </p>
         * 
         * @param tagList
         *        The list of tags associated with this workflow execution. An execution can have up to 5 tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Collection<String> tagList);

        /**
         * <p>
         * The list of tags associated with this workflow execution. An execution can have up to 5 tags.
         * </p>
         * 
         * @param tagList
         *        The list of tags associated with this workflow execution. An execution can have up to 5 tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(String... tagList);

        /**
         * <p>
         * If this workflow execution was started due to a <code>ContinueAsNewWorkflowExecution</code> decision, then it
         * contains the <code>runId</code> of the previous workflow execution that was closed and continued as this
         * execution.
         * </p>
         * 
         * @param continuedExecutionRunId
         *        If this workflow execution was started due to a <code>ContinueAsNewWorkflowExecution</code> decision,
         *        then it contains the <code>runId</code> of the previous workflow execution that was closed and
         *        continued as this execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuedExecutionRunId(String continuedExecutionRunId);

        /**
         * <p>
         * The source workflow execution that started this workflow execution. The member isn't set if the workflow
         * execution was not started by a workflow.
         * </p>
         * 
         * @param parentWorkflowExecution
         *        The source workflow execution that started this workflow execution. The member isn't set if the
         *        workflow execution was not started by a workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentWorkflowExecution(WorkflowExecution parentWorkflowExecution);

        /**
         * <p>
         * The source workflow execution that started this workflow execution. The member isn't set if the workflow
         * execution was not started by a workflow.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkflowExecution.Builder} avoiding the need to
         * create one manually via {@link WorkflowExecution#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #parentWorkflowExecution(WorkflowExecution)}.
         * 
         * @param parentWorkflowExecution
         *        a consumer that will call methods on {@link WorkflowExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parentWorkflowExecution(WorkflowExecution)
         */
        default Builder parentWorkflowExecution(Consumer<WorkflowExecution.Builder> parentWorkflowExecution) {
            return parentWorkflowExecution(WorkflowExecution.builder().applyMutation(parentWorkflowExecution).build());
        }

        /**
         * <p>
         * The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
         * <code>StartChildWorkflowExecution</code> <a>Decision</a> to start this workflow execution. The source event
         * with this ID can be found in the history of the source workflow execution. This information can be useful for
         * diagnosing problems by tracing back the chain of events leading up to this event.
         * </p>
         * 
         * @param parentInitiatedEventId
         *        The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
         *        <code>StartChildWorkflowExecution</code> <a>Decision</a> to start this workflow execution. The source
         *        event with this ID can be found in the history of the source workflow execution. This information can
         *        be useful for diagnosing problems by tracing back the chain of events leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentInitiatedEventId(Long parentInitiatedEventId);

        /**
         * <p>
         * The IAM role attached to the workflow execution.
         * </p>
         * 
         * @param lambdaRole
         *        The IAM role attached to the workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaRole(String lambdaRole);
    }

    static final class BuilderImpl implements Builder {
        private String input;

        private String executionStartToCloseTimeout;

        private String taskStartToCloseTimeout;

        private String childPolicy;

        private TaskList taskList;

        private String taskPriority;

        private WorkflowType workflowType;

        private List<String> tagList = DefaultSdkAutoConstructList.getInstance();

        private String continuedExecutionRunId;

        private WorkflowExecution parentWorkflowExecution;

        private Long parentInitiatedEventId;

        private String lambdaRole;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionStartedEventAttributes model) {
            input(model.input);
            executionStartToCloseTimeout(model.executionStartToCloseTimeout);
            taskStartToCloseTimeout(model.taskStartToCloseTimeout);
            childPolicy(model.childPolicy);
            taskList(model.taskList);
            taskPriority(model.taskPriority);
            workflowType(model.workflowType);
            tagList(model.tagList);
            continuedExecutionRunId(model.continuedExecutionRunId);
            parentWorkflowExecution(model.parentWorkflowExecution);
            parentInitiatedEventId(model.parentInitiatedEventId);
            lambdaRole(model.lambdaRole);
        }

        public final String getInput() {
            return input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final String getExecutionStartToCloseTimeout() {
            return executionStartToCloseTimeout;
        }

        @Override
        public final Builder executionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
            return this;
        }

        public final void setExecutionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
        }

        public final String getTaskStartToCloseTimeout() {
            return taskStartToCloseTimeout;
        }

        @Override
        public final Builder taskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
            return this;
        }

        public final void setTaskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
        }

        public final String getChildPolicyAsString() {
            return childPolicy;
        }

        @Override
        public final Builder childPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
            return this;
        }

        @Override
        public final Builder childPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy == null ? null : childPolicy.toString());
            return this;
        }

        public final void setChildPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
        }

        public final TaskList.Builder getTaskList() {
            return taskList != null ? taskList.toBuilder() : null;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final void setTaskList(TaskList.BuilderImpl taskList) {
            this.taskList = taskList != null ? taskList.build() : null;
        }

        public final String getTaskPriority() {
            return taskPriority;
        }

        @Override
        public final Builder taskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        public final void setTaskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
        }

        public final WorkflowType.Builder getWorkflowType() {
            return workflowType != null ? workflowType.toBuilder() : null;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final void setWorkflowType(WorkflowType.BuilderImpl workflowType) {
            this.workflowType = workflowType != null ? workflowType.build() : null;
        }

        public final Collection<String> getTagList() {
            return tagList;
        }

        @Override
        public final Builder tagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(String... tagList) {
            tagList(Arrays.asList(tagList));
            return this;
        }

        public final void setTagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
        }

        public final String getContinuedExecutionRunId() {
            return continuedExecutionRunId;
        }

        @Override
        public final Builder continuedExecutionRunId(String continuedExecutionRunId) {
            this.continuedExecutionRunId = continuedExecutionRunId;
            return this;
        }

        public final void setContinuedExecutionRunId(String continuedExecutionRunId) {
            this.continuedExecutionRunId = continuedExecutionRunId;
        }

        public final WorkflowExecution.Builder getParentWorkflowExecution() {
            return parentWorkflowExecution != null ? parentWorkflowExecution.toBuilder() : null;
        }

        @Override
        public final Builder parentWorkflowExecution(WorkflowExecution parentWorkflowExecution) {
            this.parentWorkflowExecution = parentWorkflowExecution;
            return this;
        }

        public final void setParentWorkflowExecution(WorkflowExecution.BuilderImpl parentWorkflowExecution) {
            this.parentWorkflowExecution = parentWorkflowExecution != null ? parentWorkflowExecution.build() : null;
        }

        public final Long getParentInitiatedEventId() {
            return parentInitiatedEventId;
        }

        @Override
        public final Builder parentInitiatedEventId(Long parentInitiatedEventId) {
            this.parentInitiatedEventId = parentInitiatedEventId;
            return this;
        }

        public final void setParentInitiatedEventId(Long parentInitiatedEventId) {
            this.parentInitiatedEventId = parentInitiatedEventId;
        }

        public final String getLambdaRole() {
            return lambdaRole;
        }

        @Override
        public final Builder lambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
            return this;
        }

        public final void setLambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
        }

        @Override
        public WorkflowExecutionStartedEventAttributes build() {
            return new WorkflowExecutionStartedEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
