/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about an activity type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActivityTypeInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ActivityTypeInfo.Builder, ActivityTypeInfo> {
    private static final SdkField<ActivityType> ACTIVITY_TYPE_FIELD = SdkField.<ActivityType> builder(MarshallingType.SDK_POJO)
            .getter(getter(ActivityTypeInfo::activityType)).setter(setter(Builder::activityType))
            .constructor(ActivityType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivityTypeInfo::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivityTypeInfo::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ActivityTypeInfo::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> DEPRECATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ActivityTypeInfo::deprecationDate)).setter(setter(Builder::deprecationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deprecationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_TYPE_FIELD,
            STATUS_FIELD, DESCRIPTION_FIELD, CREATION_DATE_FIELD, DEPRECATION_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ActivityType activityType;

    private final String status;

    private final String description;

    private final Instant creationDate;

    private final Instant deprecationDate;

    private ActivityTypeInfo(BuilderImpl builder) {
        this.activityType = builder.activityType;
        this.status = builder.status;
        this.description = builder.description;
        this.creationDate = builder.creationDate;
        this.deprecationDate = builder.deprecationDate;
    }

    /**
     * <p>
     * The <a>ActivityType</a> type structure representing the activity type.
     * </p>
     * 
     * @return The <a>ActivityType</a> type structure representing the activity type.
     */
    public ActivityType activityType() {
        return activityType;
    }

    /**
     * <p>
     * The current status of the activity type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the activity type.
     * @see RegistrationStatus
     */
    public RegistrationStatus status() {
        return RegistrationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the activity type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the activity type.
     * @see RegistrationStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The description of the activity type provided in <a>RegisterActivityType</a>.
     * </p>
     * 
     * @return The description of the activity type provided in <a>RegisterActivityType</a>.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The date and time this activity type was created through <a>RegisterActivityType</a>.
     * </p>
     * 
     * @return The date and time this activity type was created through <a>RegisterActivityType</a>.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * If DEPRECATED, the date and time <a>DeprecateActivityType</a> was called.
     * </p>
     * 
     * @return If DEPRECATED, the date and time <a>DeprecateActivityType</a> was called.
     */
    public Instant deprecationDate() {
        return deprecationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activityType());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(deprecationDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityTypeInfo)) {
            return false;
        }
        ActivityTypeInfo other = (ActivityTypeInfo) obj;
        return Objects.equals(activityType(), other.activityType()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(deprecationDate(), other.deprecationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ActivityTypeInfo").add("ActivityType", activityType()).add("Status", statusAsString())
                .add("Description", description()).add("CreationDate", creationDate()).add("DeprecationDate", deprecationDate())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activityType":
            return Optional.ofNullable(clazz.cast(activityType()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "deprecationDate":
            return Optional.ofNullable(clazz.cast(deprecationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivityTypeInfo, T> g) {
        return obj -> g.apply((ActivityTypeInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActivityTypeInfo> {
        /**
         * <p>
         * The <a>ActivityType</a> type structure representing the activity type.
         * </p>
         * 
         * @param activityType
         *        The <a>ActivityType</a> type structure representing the activity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityType(ActivityType activityType);

        /**
         * <p>
         * The <a>ActivityType</a> type structure representing the activity type.
         * </p>
         * This is a convenience that creates an instance of the {@link ActivityType.Builder} avoiding the need to
         * create one manually via {@link ActivityType#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActivityType.Builder#build()} is called immediately and its
         * result is passed to {@link #activityType(ActivityType)}.
         * 
         * @param activityType
         *        a consumer that will call methods on {@link ActivityType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityType(ActivityType)
         */
        default Builder activityType(Consumer<ActivityType.Builder> activityType) {
            return activityType(ActivityType.builder().applyMutation(activityType).build());
        }

        /**
         * <p>
         * The current status of the activity type.
         * </p>
         * 
         * @param status
         *        The current status of the activity type.
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the activity type.
         * </p>
         * 
         * @param status
         *        The current status of the activity type.
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder status(RegistrationStatus status);

        /**
         * <p>
         * The description of the activity type provided in <a>RegisterActivityType</a>.
         * </p>
         * 
         * @param description
         *        The description of the activity type provided in <a>RegisterActivityType</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time this activity type was created through <a>RegisterActivityType</a>.
         * </p>
         * 
         * @param creationDate
         *        The date and time this activity type was created through <a>RegisterActivityType</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * If DEPRECATED, the date and time <a>DeprecateActivityType</a> was called.
         * </p>
         * 
         * @param deprecationDate
         *        If DEPRECATED, the date and time <a>DeprecateActivityType</a> was called.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecationDate(Instant deprecationDate);
    }

    static final class BuilderImpl implements Builder {
        private ActivityType activityType;

        private String status;

        private String description;

        private Instant creationDate;

        private Instant deprecationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivityTypeInfo model) {
            activityType(model.activityType);
            status(model.status);
            description(model.description);
            creationDate(model.creationDate);
            deprecationDate(model.deprecationDate);
        }

        public final ActivityType.Builder getActivityType() {
            return activityType != null ? activityType.toBuilder() : null;
        }

        @Override
        public final Builder activityType(ActivityType activityType) {
            this.activityType = activityType;
            return this;
        }

        public final void setActivityType(ActivityType.BuilderImpl activityType) {
            this.activityType = activityType != null ? activityType.build() : null;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RegistrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getDeprecationDate() {
            return deprecationDate;
        }

        @Override
        public final Builder deprecationDate(Instant deprecationDate) {
            this.deprecationDate = deprecationDate;
            return this;
        }

        public final void setDeprecationDate(Instant deprecationDate) {
            this.deprecationDate = deprecationDate;
        }

        @Override
        public ActivityTypeInfo build() {
            return new ActivityTypeInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
