/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the count of workflow executions returned from <a>CountOpenWorkflowExecutions</a> or
 * <a>CountClosedWorkflowExecutions</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CountOpenWorkflowExecutionsResponse extends SwfResponse implements
        ToCopyableBuilder<CountOpenWorkflowExecutionsResponse.Builder, CountOpenWorkflowExecutionsResponse> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CountOpenWorkflowExecutionsResponse::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<Boolean> TRUNCATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CountOpenWorkflowExecutionsResponse::truncated)).setter(setter(Builder::truncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("truncated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, TRUNCATED_FIELD));

    private final Integer count;

    private final Boolean truncated;

    private CountOpenWorkflowExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.count = builder.count;
        this.truncated = builder.truncated;
    }

    /**
     * <p>
     * The number of workflow executions.
     * </p>
     * 
     * @return The number of workflow executions.
     */
    public Integer count() {
        return count;
    }

    /**
     * <p>
     * If set to true, indicates that the actual count was more than the maximum supported by this API and the count
     * returned is the truncated value.
     * </p>
     * 
     * @return If set to true, indicates that the actual count was more than the maximum supported by this API and the
     *         count returned is the truncated value.
     */
    public Boolean truncated() {
        return truncated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(truncated());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CountOpenWorkflowExecutionsResponse)) {
            return false;
        }
        CountOpenWorkflowExecutionsResponse other = (CountOpenWorkflowExecutionsResponse) obj;
        return Objects.equals(count(), other.count()) && Objects.equals(truncated(), other.truncated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CountOpenWorkflowExecutionsResponse").add("Count", count()).add("Truncated", truncated())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "truncated":
            return Optional.ofNullable(clazz.cast(truncated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CountOpenWorkflowExecutionsResponse, T> g) {
        return obj -> g.apply((CountOpenWorkflowExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfResponse.Builder, SdkPojo, CopyableBuilder<Builder, CountOpenWorkflowExecutionsResponse> {
        /**
         * <p>
         * The number of workflow executions.
         * </p>
         * 
         * @param count
         *        The number of workflow executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * If set to true, indicates that the actual count was more than the maximum supported by this API and the count
         * returned is the truncated value.
         * </p>
         * 
         * @param truncated
         *        If set to true, indicates that the actual count was more than the maximum supported by this API and
         *        the count returned is the truncated value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truncated(Boolean truncated);
    }

    static final class BuilderImpl extends SwfResponse.BuilderImpl implements Builder {
        private Integer count;

        private Boolean truncated;

        private BuilderImpl() {
        }

        private BuilderImpl(CountOpenWorkflowExecutionsResponse model) {
            super(model);
            count(model.count);
            truncated(model.truncated);
        }

        public final Integer getCount() {
            return count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final Boolean getTruncated() {
            return truncated;
        }

        @Override
        public final Builder truncated(Boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        public final void setTruncated(Boolean truncated) {
            this.truncated = truncated;
        }

        @Override
        public CountOpenWorkflowExecutionsResponse build() {
            return new CountOpenWorkflowExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
