/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>ActivityTaskTimedOut</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActivityTaskTimedOutEventAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<ActivityTaskTimedOutEventAttributes.Builder, ActivityTaskTimedOutEventAttributes> {
    private static final SdkField<String> TIMEOUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivityTaskTimedOutEventAttributes::timeoutTypeAsString)).setter(setter(Builder::timeoutType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutType").build()).build();

    private static final SdkField<Long> SCHEDULED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ActivityTaskTimedOutEventAttributes::scheduledEventId)).setter(setter(Builder::scheduledEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledEventId").build()).build();

    private static final SdkField<Long> STARTED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ActivityTaskTimedOutEventAttributes::startedEventId)).setter(setter(Builder::startedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedEventId").build()).build();

    private static final SdkField<String> DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivityTaskTimedOutEventAttributes::details)).setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_TYPE_FIELD,
            SCHEDULED_EVENT_ID_FIELD, STARTED_EVENT_ID_FIELD, DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String timeoutType;

    private final Long scheduledEventId;

    private final Long startedEventId;

    private final String details;

    private ActivityTaskTimedOutEventAttributes(BuilderImpl builder) {
        this.timeoutType = builder.timeoutType;
        this.scheduledEventId = builder.scheduledEventId;
        this.startedEventId = builder.startedEventId;
        this.details = builder.details;
    }

    /**
     * <p>
     * The type of the timeout that caused this event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeoutType} will
     * return {@link ActivityTaskTimeoutType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeoutTypeAsString}.
     * </p>
     * 
     * @return The type of the timeout that caused this event.
     * @see ActivityTaskTimeoutType
     */
    public ActivityTaskTimeoutType timeoutType() {
        return ActivityTaskTimeoutType.fromValue(timeoutType);
    }

    /**
     * <p>
     * The type of the timeout that caused this event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeoutType} will
     * return {@link ActivityTaskTimeoutType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeoutTypeAsString}.
     * </p>
     * 
     * @return The type of the timeout that caused this event.
     * @see ActivityTaskTimeoutType
     */
    public String timeoutTypeAsString() {
        return timeoutType;
    }

    /**
     * <p>
     * The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled.
     * This information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     * event.
     * </p>
     * 
     * @return The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was
     *         scheduled. This information can be useful for diagnosing problems by tracing back the chain of events
     *         leading up to this event.
     */
    public Long scheduledEventId() {
        return scheduledEventId;
    }

    /**
     * <p>
     * The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
     * information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
     *         information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     *         event.
     */
    public Long startedEventId() {
        return startedEventId;
    }

    /**
     * <p>
     * Contains the content of the <code>details</code> parameter for the last call made by the activity to
     * <code>RecordActivityTaskHeartbeat</code>.
     * </p>
     * 
     * @return Contains the content of the <code>details</code> parameter for the last call made by the activity to
     *         <code>RecordActivityTaskHeartbeat</code>.
     */
    public String details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeoutTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledEventId());
        hashCode = 31 * hashCode + Objects.hashCode(startedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityTaskTimedOutEventAttributes)) {
            return false;
        }
        ActivityTaskTimedOutEventAttributes other = (ActivityTaskTimedOutEventAttributes) obj;
        return Objects.equals(timeoutTypeAsString(), other.timeoutTypeAsString())
                && Objects.equals(scheduledEventId(), other.scheduledEventId())
                && Objects.equals(startedEventId(), other.startedEventId()) && Objects.equals(details(), other.details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ActivityTaskTimedOutEventAttributes").add("TimeoutType", timeoutTypeAsString())
                .add("ScheduledEventId", scheduledEventId()).add("StartedEventId", startedEventId()).add("Details", details())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeoutType":
            return Optional.ofNullable(clazz.cast(timeoutTypeAsString()));
        case "scheduledEventId":
            return Optional.ofNullable(clazz.cast(scheduledEventId()));
        case "startedEventId":
            return Optional.ofNullable(clazz.cast(startedEventId()));
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivityTaskTimedOutEventAttributes, T> g) {
        return obj -> g.apply((ActivityTaskTimedOutEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActivityTaskTimedOutEventAttributes> {
        /**
         * <p>
         * The type of the timeout that caused this event.
         * </p>
         * 
         * @param timeoutType
         *        The type of the timeout that caused this event.
         * @see ActivityTaskTimeoutType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityTaskTimeoutType
         */
        Builder timeoutType(String timeoutType);

        /**
         * <p>
         * The type of the timeout that caused this event.
         * </p>
         * 
         * @param timeoutType
         *        The type of the timeout that caused this event.
         * @see ActivityTaskTimeoutType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityTaskTimeoutType
         */
        Builder timeoutType(ActivityTaskTimeoutType timeoutType);

        /**
         * <p>
         * The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was
         * scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading
         * up to this event.
         * </p>
         * 
         * @param scheduledEventId
         *        The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was
         *        scheduled. This information can be useful for diagnosing problems by tracing back the chain of events
         *        leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledEventId(Long scheduledEventId);

        /**
         * <p>
         * The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
         * information can be useful for diagnosing problems by tracing back the chain of events leading up to this
         * event.
         * </p>
         * 
         * @param startedEventId
         *        The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started.
         *        This information can be useful for diagnosing problems by tracing back the chain of events leading up
         *        to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedEventId(Long startedEventId);

        /**
         * <p>
         * Contains the content of the <code>details</code> parameter for the last call made by the activity to
         * <code>RecordActivityTaskHeartbeat</code>.
         * </p>
         * 
         * @param details
         *        Contains the content of the <code>details</code> parameter for the last call made by the activity to
         *        <code>RecordActivityTaskHeartbeat</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);
    }

    static final class BuilderImpl implements Builder {
        private String timeoutType;

        private Long scheduledEventId;

        private Long startedEventId;

        private String details;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivityTaskTimedOutEventAttributes model) {
            timeoutType(model.timeoutType);
            scheduledEventId(model.scheduledEventId);
            startedEventId(model.startedEventId);
            details(model.details);
        }

        public final String getTimeoutTypeAsString() {
            return timeoutType;
        }

        @Override
        public final Builder timeoutType(String timeoutType) {
            this.timeoutType = timeoutType;
            return this;
        }

        @Override
        public final Builder timeoutType(ActivityTaskTimeoutType timeoutType) {
            this.timeoutType(timeoutType == null ? null : timeoutType.toString());
            return this;
        }

        public final void setTimeoutType(String timeoutType) {
            this.timeoutType = timeoutType;
        }

        public final Long getScheduledEventId() {
            return scheduledEventId;
        }

        @Override
        public final Builder scheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
            return this;
        }

        public final void setScheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
        }

        public final Long getStartedEventId() {
            return startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        public final String getDetails() {
            return details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        @Override
        public ActivityTaskTimedOutEventAttributes build() {
            return new ActivityTaskTimedOutEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
