/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>ExternalWorkflowExecutionCancelRequested</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExternalWorkflowExecutionCancelRequestedEventAttributes
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<ExternalWorkflowExecutionCancelRequestedEventAttributes.Builder, ExternalWorkflowExecutionCancelRequestedEventAttributes> {
    private static final SdkField<WorkflowExecution> WORKFLOW_EXECUTION_FIELD = SdkField
            .<WorkflowExecution> builder(MarshallingType.SDK_POJO)
            .getter(getter(ExternalWorkflowExecutionCancelRequestedEventAttributes::workflowExecution))
            .setter(setter(Builder::workflowExecution)).constructor(WorkflowExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowExecution").build()).build();

    private static final SdkField<Long> INITIATED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ExternalWorkflowExecutionCancelRequestedEventAttributes::initiatedEventId))
            .setter(setter(Builder::initiatedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initiatedEventId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_EXECUTION_FIELD,
            INITIATED_EVENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final WorkflowExecution workflowExecution;

    private final Long initiatedEventId;

    private ExternalWorkflowExecutionCancelRequestedEventAttributes(BuilderImpl builder) {
        this.workflowExecution = builder.workflowExecution;
        this.initiatedEventId = builder.initiatedEventId;
    }

    /**
     * <p>
     * The external workflow execution to which the cancellation request was delivered.
     * </p>
     * 
     * @return The external workflow execution to which the cancellation request was delivered.
     */
    public WorkflowExecution workflowExecution() {
        return workflowExecution;
    }

    /**
     * <p>
     * The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
     * <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this external workflow execution. This
     * information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
     *         <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this external workflow execution.
     *         This information can be useful for diagnosing problems by tracing back the chain of events leading up to
     *         this event.
     */
    public Long initiatedEventId() {
        return initiatedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workflowExecution());
        hashCode = 31 * hashCode + Objects.hashCode(initiatedEventId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalWorkflowExecutionCancelRequestedEventAttributes)) {
            return false;
        }
        ExternalWorkflowExecutionCancelRequestedEventAttributes other = (ExternalWorkflowExecutionCancelRequestedEventAttributes) obj;
        return Objects.equals(workflowExecution(), other.workflowExecution())
                && Objects.equals(initiatedEventId(), other.initiatedEventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExternalWorkflowExecutionCancelRequestedEventAttributes")
                .add("WorkflowExecution", workflowExecution()).add("InitiatedEventId", initiatedEventId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workflowExecution":
            return Optional.ofNullable(clazz.cast(workflowExecution()));
        case "initiatedEventId":
            return Optional.ofNullable(clazz.cast(initiatedEventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExternalWorkflowExecutionCancelRequestedEventAttributes, T> g) {
        return obj -> g.apply((ExternalWorkflowExecutionCancelRequestedEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExternalWorkflowExecutionCancelRequestedEventAttributes> {
        /**
         * <p>
         * The external workflow execution to which the cancellation request was delivered.
         * </p>
         * 
         * @param workflowExecution
         *        The external workflow execution to which the cancellation request was delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecution(WorkflowExecution workflowExecution);

        /**
         * <p>
         * The external workflow execution to which the cancellation request was delivered.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkflowExecution.Builder} avoiding the need to
         * create one manually via {@link WorkflowExecution#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #workflowExecution(WorkflowExecution)}.
         * 
         * @param workflowExecution
         *        a consumer that will call methods on {@link WorkflowExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowExecution(WorkflowExecution)
         */
        default Builder workflowExecution(Consumer<WorkflowExecution.Builder> workflowExecution) {
            return workflowExecution(WorkflowExecution.builder().applyMutation(workflowExecution).build());
        }

        /**
         * <p>
         * The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
         * <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this external workflow execution. This
         * information can be useful for diagnosing problems by tracing back the chain of events leading up to this
         * event.
         * </p>
         * 
         * @param initiatedEventId
         *        The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
         *        <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this external workflow
         *        execution. This information can be useful for diagnosing problems by tracing back the chain of events
         *        leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiatedEventId(Long initiatedEventId);
    }

    static final class BuilderImpl implements Builder {
        private WorkflowExecution workflowExecution;

        private Long initiatedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalWorkflowExecutionCancelRequestedEventAttributes model) {
            workflowExecution(model.workflowExecution);
            initiatedEventId(model.initiatedEventId);
        }

        public final WorkflowExecution.Builder getWorkflowExecution() {
            return workflowExecution != null ? workflowExecution.toBuilder() : null;
        }

        @Override
        public final Builder workflowExecution(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
            return this;
        }

        public final void setWorkflowExecution(WorkflowExecution.BuilderImpl workflowExecution) {
            this.workflowExecution = workflowExecution != null ? workflowExecution.build() : null;
        }

        public final Long getInitiatedEventId() {
            return initiatedEventId;
        }

        @Override
        public final Builder initiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
            return this;
        }

        public final void setInitiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
        }

        @Override
        public ExternalWorkflowExecutionCancelRequestedEventAttributes build() {
            return new ExternalWorkflowExecutionCancelRequestedEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
