/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.synthetics.model.CanaryState;
import software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CanaryStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CanaryStatus> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CanaryStatus.getter(CanaryStatus::stateAsString)).setter(CanaryStatus.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CanaryStatus.getter(CanaryStatus::stateReason)).setter(CanaryStatus.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final SdkField<String> STATE_REASON_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CanaryStatus.getter(CanaryStatus::stateReasonCodeAsString)).setter(CanaryStatus.setter(Builder::stateReasonCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReasonCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, STATE_REASON_FIELD, STATE_REASON_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String state;
    private final String stateReason;
    private final String stateReasonCode;

    private CanaryStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.stateReasonCode = builder.stateReasonCode;
    }

    public CanaryState state() {
        return CanaryState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String stateReason() {
        return this.stateReason;
    }

    public CanaryStateReasonCode stateReasonCode() {
        return CanaryStateReasonCode.fromValue(this.stateReasonCode);
    }

    public String stateReasonCodeAsString() {
        return this.stateReasonCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReasonCodeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryStatus)) {
            return false;
        }
        CanaryStatus other = (CanaryStatus)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateReason(), other.stateReason()) && Objects.equals(this.stateReasonCodeAsString(), other.stateReasonCodeAsString());
    }

    public String toString() {
        return ToString.builder((String)"CanaryStatus").add("State", (Object)this.stateAsString()).add("StateReason", (Object)this.stateReason()).add("StateReasonCode", (Object)this.stateReasonCodeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "StateReasonCode": {
                return Optional.ofNullable(clazz.cast(this.stateReasonCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CanaryStatus, T> g) {
        return obj -> g.apply((CanaryStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private String stateReason;
        private String stateReasonCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryStatus model) {
            this.state(model.state);
            this.stateReason(model.stateReason);
            this.stateReasonCode(model.stateReasonCode);
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CanaryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        public final String getStateReasonCodeAsString() {
            return this.stateReasonCode;
        }

        @Override
        public final Builder stateReasonCode(String stateReasonCode) {
            this.stateReasonCode = stateReasonCode;
            return this;
        }

        @Override
        public final Builder stateReasonCode(CanaryStateReasonCode stateReasonCode) {
            this.stateReasonCode(stateReasonCode == null ? null : stateReasonCode.toString());
            return this;
        }

        public final void setStateReasonCode(String stateReasonCode) {
            this.stateReasonCode = stateReasonCode;
        }

        public CanaryStatus build() {
            return new CanaryStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CanaryStatus> {
        public Builder state(String var1);

        public Builder state(CanaryState var1);

        public Builder stateReason(String var1);

        public Builder stateReasonCode(String var1);

        public Builder stateReasonCode(CanaryStateReasonCode var1);
    }
}

