/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.synthetics.SyntheticsAsyncClient;
import software.amazon.awssdk.services.synthetics.model.DescribeCanariesLastRunRequest;
import software.amazon.awssdk.services.synthetics.model.DescribeCanariesLastRunResponse;

public class DescribeCanariesLastRunPublisher
implements SdkPublisher<DescribeCanariesLastRunResponse> {
    private final SyntheticsAsyncClient client;
    private final DescribeCanariesLastRunRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCanariesLastRunPublisher(SyntheticsAsyncClient client, DescribeCanariesLastRunRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCanariesLastRunPublisher(SyntheticsAsyncClient client, DescribeCanariesLastRunRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCanariesLastRunResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCanariesLastRunResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeCanariesLastRunResponseFetcher
    implements AsyncPageFetcher<DescribeCanariesLastRunResponse> {
        private DescribeCanariesLastRunResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCanariesLastRunResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeCanariesLastRunResponse> nextPage(DescribeCanariesLastRunResponse previousPage) {
            if (previousPage == null) {
                return DescribeCanariesLastRunPublisher.this.client.describeCanariesLastRun(DescribeCanariesLastRunPublisher.this.firstRequest);
            }
            return DescribeCanariesLastRunPublisher.this.client.describeCanariesLastRun((DescribeCanariesLastRunRequest)((Object)DescribeCanariesLastRunPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

