/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRuntimeVersionsResponse extends SyntheticsResponse implements
        ToCopyableBuilder<DescribeRuntimeVersionsResponse.Builder, DescribeRuntimeVersionsResponse> {
    private static final SdkField<List<RuntimeVersion>> RUNTIME_VERSIONS_FIELD = SdkField
            .<List<RuntimeVersion>> builder(MarshallingType.LIST)
            .getter(getter(DescribeRuntimeVersionsResponse::runtimeVersions))
            .setter(setter(Builder::runtimeVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuntimeVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuntimeVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeRuntimeVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNTIME_VERSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<RuntimeVersion> runtimeVersions;

    private final String nextToken;

    private DescribeRuntimeVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.runtimeVersions = builder.runtimeVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the RuntimeVersions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRuntimeVersions() {
        return runtimeVersions != null && !(runtimeVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that display the details about each Synthetics canary runtime version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRuntimeVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that display the details about each Synthetics canary runtime version.
     */
    public List<RuntimeVersion> runtimeVersions() {
        return runtimeVersions;
    }

    /**
     * <p>
     * A token that indicates that there is more data available. You can use this token in a subsequent
     * <code>DescribeRuntimeVersions</code> operation to retrieve the next set of results.
     * </p>
     * 
     * @return A token that indicates that there is more data available. You can use this token in a subsequent
     *         <code>DescribeRuntimeVersions</code> operation to retrieve the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(runtimeVersions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRuntimeVersionsResponse)) {
            return false;
        }
        DescribeRuntimeVersionsResponse other = (DescribeRuntimeVersionsResponse) obj;
        return Objects.equals(runtimeVersions(), other.runtimeVersions()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeRuntimeVersionsResponse").add("RuntimeVersions", runtimeVersions())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuntimeVersions":
            return Optional.ofNullable(clazz.cast(runtimeVersions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRuntimeVersionsResponse, T> g) {
        return obj -> g.apply((DescribeRuntimeVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SyntheticsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRuntimeVersionsResponse> {
        /**
         * <p>
         * An array of objects that display the details about each Synthetics canary runtime version.
         * </p>
         * 
         * @param runtimeVersions
         *        An array of objects that display the details about each Synthetics canary runtime version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeVersions(Collection<RuntimeVersion> runtimeVersions);

        /**
         * <p>
         * An array of objects that display the details about each Synthetics canary runtime version.
         * </p>
         * 
         * @param runtimeVersions
         *        An array of objects that display the details about each Synthetics canary runtime version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeVersions(RuntimeVersion... runtimeVersions);

        /**
         * <p>
         * An array of objects that display the details about each Synthetics canary runtime version.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RuntimeVersion>.Builder} avoiding the need
         * to create one manually via {@link List<RuntimeVersion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RuntimeVersion>.Builder#build()} is called immediately and
         * its result is passed to {@link #runtimeVersions(List<RuntimeVersion>)}.
         * 
         * @param runtimeVersions
         *        a consumer that will call methods on {@link List<RuntimeVersion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runtimeVersions(List<RuntimeVersion>)
         */
        Builder runtimeVersions(Consumer<RuntimeVersion.Builder>... runtimeVersions);

        /**
         * <p>
         * A token that indicates that there is more data available. You can use this token in a subsequent
         * <code>DescribeRuntimeVersions</code> operation to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates that there is more data available. You can use this token in a subsequent
         *        <code>DescribeRuntimeVersions</code> operation to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SyntheticsResponse.BuilderImpl implements Builder {
        private List<RuntimeVersion> runtimeVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRuntimeVersionsResponse model) {
            super(model);
            runtimeVersions(model.runtimeVersions);
            nextToken(model.nextToken);
        }

        public final Collection<RuntimeVersion.Builder> getRuntimeVersions() {
            return runtimeVersions != null ? runtimeVersions.stream().map(RuntimeVersion::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder runtimeVersions(Collection<RuntimeVersion> runtimeVersions) {
            this.runtimeVersions = RuntimeVersionListCopier.copy(runtimeVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runtimeVersions(RuntimeVersion... runtimeVersions) {
            runtimeVersions(Arrays.asList(runtimeVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runtimeVersions(Consumer<RuntimeVersion.Builder>... runtimeVersions) {
            runtimeVersions(Stream.of(runtimeVersions).map(c -> RuntimeVersion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRuntimeVersions(Collection<RuntimeVersion.BuilderImpl> runtimeVersions) {
            this.runtimeVersions = RuntimeVersionListCopier.copyFromBuilder(runtimeVersions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeRuntimeVersionsResponse build() {
            return new DescribeRuntimeVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
