/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains input information for a canary run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanaryRunConfigInput implements SdkPojo, Serializable,
        ToCopyableBuilder<CanaryRunConfigInput.Builder, CanaryRunConfigInput> {
    private static final SdkField<Integer> TIMEOUT_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CanaryRunConfigInput::timeoutInSeconds)).setter(setter(Builder::timeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutInSeconds").build()).build();

    private static final SdkField<Integer> MEMORY_IN_MB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CanaryRunConfigInput::memoryInMB)).setter(setter(Builder::memoryInMB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryInMB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_IN_SECONDS_FIELD,
            MEMORY_IN_MB_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer timeoutInSeconds;

    private final Integer memoryInMB;

    private CanaryRunConfigInput(BuilderImpl builder) {
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.memoryInMB = builder.memoryInMB;
    }

    /**
     * <p>
     * How long the canary is allowed to run before it must stop. If you omit this field, the frequency of the canary is
     * used as this value, up to a maximum of 14 minutes.
     * </p>
     * 
     * @return How long the canary is allowed to run before it must stop. If you omit this field, the frequency of the
     *         canary is used as this value, up to a maximum of 14 minutes.
     */
    public Integer timeoutInSeconds() {
        return timeoutInSeconds;
    }

    /**
     * <p>
     * The maximum amount of memory available to the canary while it is running, in MB. The value you specify must be a
     * multiple of 64.
     * </p>
     * 
     * @return The maximum amount of memory available to the canary while it is running, in MB. The value you specify
     *         must be a multiple of 64.
     */
    public Integer memoryInMB() {
        return memoryInMB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(memoryInMB());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryRunConfigInput)) {
            return false;
        }
        CanaryRunConfigInput other = (CanaryRunConfigInput) obj;
        return Objects.equals(timeoutInSeconds(), other.timeoutInSeconds()) && Objects.equals(memoryInMB(), other.memoryInMB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CanaryRunConfigInput").add("TimeoutInSeconds", timeoutInSeconds())
                .add("MemoryInMB", memoryInMB()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(timeoutInSeconds()));
        case "MemoryInMB":
            return Optional.ofNullable(clazz.cast(memoryInMB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CanaryRunConfigInput, T> g) {
        return obj -> g.apply((CanaryRunConfigInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanaryRunConfigInput> {
        /**
         * <p>
         * How long the canary is allowed to run before it must stop. If you omit this field, the frequency of the
         * canary is used as this value, up to a maximum of 14 minutes.
         * </p>
         * 
         * @param timeoutInSeconds
         *        How long the canary is allowed to run before it must stop. If you omit this field, the frequency of
         *        the canary is used as this value, up to a maximum of 14 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInSeconds(Integer timeoutInSeconds);

        /**
         * <p>
         * The maximum amount of memory available to the canary while it is running, in MB. The value you specify must
         * be a multiple of 64.
         * </p>
         * 
         * @param memoryInMB
         *        The maximum amount of memory available to the canary while it is running, in MB. The value you specify
         *        must be a multiple of 64.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryInMB(Integer memoryInMB);
    }

    static final class BuilderImpl implements Builder {
        private Integer timeoutInSeconds;

        private Integer memoryInMB;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryRunConfigInput model) {
            timeoutInSeconds(model.timeoutInSeconds);
            memoryInMB(model.memoryInMB);
        }

        public final Integer getTimeoutInSeconds() {
            return timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final void setTimeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        public final Integer getMemoryInMB() {
            return memoryInMB;
        }

        @Override
        public final Builder memoryInMB(Integer memoryInMB) {
            this.memoryInMB = memoryInMB;
            return this;
        }

        public final void setMemoryInMB(Integer memoryInMB) {
            this.memoryInMB = memoryInMB;
        }

        @Override
        public CanaryRunConfigInput build() {
            return new CanaryRunConfigInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
