/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information about a canary run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanaryRunConfigOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<CanaryRunConfigOutput.Builder, CanaryRunConfigOutput> {
    private static final SdkField<Integer> TIMEOUT_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CanaryRunConfigOutput::timeoutInSeconds)).setter(setter(Builder::timeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutInSeconds").build()).build();

    private static final SdkField<Integer> MEMORY_IN_MB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CanaryRunConfigOutput::memoryInMB)).setter(setter(Builder::memoryInMB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryInMB").build()).build();

    private static final SdkField<Boolean> ACTIVE_TRACING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CanaryRunConfigOutput::activeTracing)).setter(setter(Builder::activeTracing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveTracing").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_IN_SECONDS_FIELD,
            MEMORY_IN_MB_FIELD, ACTIVE_TRACING_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer timeoutInSeconds;

    private final Integer memoryInMB;

    private final Boolean activeTracing;

    private CanaryRunConfigOutput(BuilderImpl builder) {
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.memoryInMB = builder.memoryInMB;
        this.activeTracing = builder.activeTracing;
    }

    /**
     * <p>
     * How long the canary is allowed to run before it must stop.
     * </p>
     * 
     * @return How long the canary is allowed to run before it must stop.
     */
    public Integer timeoutInSeconds() {
        return timeoutInSeconds;
    }

    /**
     * <p>
     * The maximum amount of memory available to the canary while it is running, in MB. This value must be a multiple of
     * 64.
     * </p>
     * 
     * @return The maximum amount of memory available to the canary while it is running, in MB. This value must be a
     *         multiple of 64.
     */
    public Integer memoryInMB() {
        return memoryInMB;
    }

    /**
     * <p>
     * Displays whether this canary run used active AWS X-Ray tracing.
     * </p>
     * 
     * @return Displays whether this canary run used active AWS X-Ray tracing.
     */
    public Boolean activeTracing() {
        return activeTracing;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(memoryInMB());
        hashCode = 31 * hashCode + Objects.hashCode(activeTracing());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryRunConfigOutput)) {
            return false;
        }
        CanaryRunConfigOutput other = (CanaryRunConfigOutput) obj;
        return Objects.equals(timeoutInSeconds(), other.timeoutInSeconds()) && Objects.equals(memoryInMB(), other.memoryInMB())
                && Objects.equals(activeTracing(), other.activeTracing());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CanaryRunConfigOutput").add("TimeoutInSeconds", timeoutInSeconds())
                .add("MemoryInMB", memoryInMB()).add("ActiveTracing", activeTracing()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(timeoutInSeconds()));
        case "MemoryInMB":
            return Optional.ofNullable(clazz.cast(memoryInMB()));
        case "ActiveTracing":
            return Optional.ofNullable(clazz.cast(activeTracing()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CanaryRunConfigOutput, T> g) {
        return obj -> g.apply((CanaryRunConfigOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanaryRunConfigOutput> {
        /**
         * <p>
         * How long the canary is allowed to run before it must stop.
         * </p>
         * 
         * @param timeoutInSeconds
         *        How long the canary is allowed to run before it must stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInSeconds(Integer timeoutInSeconds);

        /**
         * <p>
         * The maximum amount of memory available to the canary while it is running, in MB. This value must be a
         * multiple of 64.
         * </p>
         * 
         * @param memoryInMB
         *        The maximum amount of memory available to the canary while it is running, in MB. This value must be a
         *        multiple of 64.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryInMB(Integer memoryInMB);

        /**
         * <p>
         * Displays whether this canary run used active AWS X-Ray tracing.
         * </p>
         * 
         * @param activeTracing
         *        Displays whether this canary run used active AWS X-Ray tracing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeTracing(Boolean activeTracing);
    }

    static final class BuilderImpl implements Builder {
        private Integer timeoutInSeconds;

        private Integer memoryInMB;

        private Boolean activeTracing;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryRunConfigOutput model) {
            timeoutInSeconds(model.timeoutInSeconds);
            memoryInMB(model.memoryInMB);
            activeTracing(model.activeTracing);
        }

        public final Integer getTimeoutInSeconds() {
            return timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final void setTimeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        public final Integer getMemoryInMB() {
            return memoryInMB;
        }

        @Override
        public final Builder memoryInMB(Integer memoryInMB) {
            this.memoryInMB = memoryInMB;
            return this;
        }

        public final void setMemoryInMB(Integer memoryInMB) {
            this.memoryInMB = memoryInMB;
        }

        public final Boolean getActiveTracing() {
            return activeTracing;
        }

        @Override
        public final Builder activeTracing(Boolean activeTracing) {
            this.activeTracing = activeTracing;
            return this;
        }

        public final void setActiveTracing(Boolean activeTracing) {
            this.activeTracing = activeTracing;
        }

        @Override
        public CanaryRunConfigOutput build() {
            return new CanaryRunConfigOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
