/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCanaryRequest extends SyntheticsRequest implements
        ToCopyableBuilder<UpdateCanaryRequest.Builder, UpdateCanaryRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateCanaryRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<CanaryCodeInput> CODE_FIELD = SdkField.<CanaryCodeInput> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateCanaryRequest::code)).setter(setter(Builder::code)).constructor(CanaryCodeInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateCanaryRequest::executionRoleArn)).setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<String> RUNTIME_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateCanaryRequest::runtimeVersion)).setter(setter(Builder::runtimeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeVersion").build()).build();

    private static final SdkField<CanaryScheduleInput> SCHEDULE_FIELD = SdkField
            .<CanaryScheduleInput> builder(MarshallingType.SDK_POJO).getter(getter(UpdateCanaryRequest::schedule))
            .setter(setter(Builder::schedule)).constructor(CanaryScheduleInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<CanaryRunConfigInput> RUN_CONFIG_FIELD = SdkField
            .<CanaryRunConfigInput> builder(MarshallingType.SDK_POJO).getter(getter(UpdateCanaryRequest::runConfig))
            .setter(setter(Builder::runConfig)).constructor(CanaryRunConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunConfig").build()).build();

    private static final SdkField<Integer> SUCCESS_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateCanaryRequest::successRetentionPeriodInDays))
            .setter(setter(Builder::successRetentionPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessRetentionPeriodInDays")
                    .build()).build();

    private static final SdkField<Integer> FAILURE_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateCanaryRequest::failureRetentionPeriodInDays))
            .setter(setter(Builder::failureRetentionPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureRetentionPeriodInDays")
                    .build()).build();

    private static final SdkField<VpcConfigInput> VPC_CONFIG_FIELD = SdkField.<VpcConfigInput> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateCanaryRequest::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CODE_FIELD,
            EXECUTION_ROLE_ARN_FIELD, RUNTIME_VERSION_FIELD, SCHEDULE_FIELD, RUN_CONFIG_FIELD,
            SUCCESS_RETENTION_PERIOD_IN_DAYS_FIELD, FAILURE_RETENTION_PERIOD_IN_DAYS_FIELD, VPC_CONFIG_FIELD));

    private final String name;

    private final CanaryCodeInput code;

    private final String executionRoleArn;

    private final String runtimeVersion;

    private final CanaryScheduleInput schedule;

    private final CanaryRunConfigInput runConfig;

    private final Integer successRetentionPeriodInDays;

    private final Integer failureRetentionPeriodInDays;

    private final VpcConfigInput vpcConfig;

    private UpdateCanaryRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.code = builder.code;
        this.executionRoleArn = builder.executionRoleArn;
        this.runtimeVersion = builder.runtimeVersion;
        this.schedule = builder.schedule;
        this.runConfig = builder.runConfig;
        this.successRetentionPeriodInDays = builder.successRetentionPeriodInDays;
        this.failureRetentionPeriodInDays = builder.failureRetentionPeriodInDays;
        this.vpcConfig = builder.vpcConfig;
    }

    /**
     * <p>
     * The name of the canary that you want to update. To find the names of your canaries, use <a
     * href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html"
     * >DescribeCanaries</a>.
     * </p>
     * <p>
     * You cannot change the name of a canary that has already been created.
     * </p>
     * 
     * @return The name of the canary that you want to update. To find the names of your canaries, use <a
     *         href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html"
     *         >DescribeCanaries</a>.</p>
     *         <p>
     *         You cannot change the name of a canary that has already been created.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A structure that includes the entry point from which the canary should start running your script. If the script
     * is stored in an S3 bucket, the bucket name, key, and version are also included.
     * </p>
     * 
     * @return A structure that includes the entry point from which the canary should start running your script. If the
     *         script is stored in an S3 bucket, the bucket name, key, and version are also included.
     */
    public CanaryCodeInput code() {
        return code;
    }

    /**
     * <p>
     * The ARN of the IAM role to be used to run the canary. This role must already exist, and must include
     * <code>lambda.amazonaws.com</code> as a principal in the trust policy. The role must also have the following
     * permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>s3:PutObject</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:GetBucketLocation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:ListAllMyBuckets</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cloudwatch:PutMetricData</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>logs:CreateLogGroup</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>logs:CreateLogStream</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>logs:CreateLogStream</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The ARN of the IAM role to be used to run the canary. This role must already exist, and must include
     *         <code>lambda.amazonaws.com</code> as a principal in the trust policy. The role must also have the
     *         following permissions:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>s3:PutObject</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:GetBucketLocation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:ListAllMyBuckets</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cloudwatch:PutMetricData</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>logs:CreateLogGroup</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>logs:CreateLogStream</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>logs:CreateLogStream</code>
     *         </p>
     *         </li>
     */
    public String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * Specifies the runtime version to use for the canary. Currently, the only valid values are
     * <code>syn-nodejs-2.0</code>, <code>syn-nodejs-2.0-beta</code>, and <code>syn-1.0</code>. For more information
     * about runtime versions, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
     * Canary Runtime Versions</a>.
     * </p>
     * 
     * @return Specifies the runtime version to use for the canary. Currently, the only valid values are
     *         <code>syn-nodejs-2.0</code>, <code>syn-nodejs-2.0-beta</code>, and <code>syn-1.0</code>. For more
     *         information about runtime versions, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html"
     *         > Canary Runtime Versions</a>.
     */
    public String runtimeVersion() {
        return runtimeVersion;
    }

    /**
     * <p>
     * A structure that contains information about how often the canary is to run, and when these runs are to stop.
     * </p>
     * 
     * @return A structure that contains information about how often the canary is to run, and when these runs are to
     *         stop.
     */
    public CanaryScheduleInput schedule() {
        return schedule;
    }

    /**
     * <p>
     * A structure that contains the timeout value that is used for each individual run of the canary.
     * </p>
     * 
     * @return A structure that contains the timeout value that is used for each individual run of the canary.
     */
    public CanaryRunConfigInput runConfig() {
        return runConfig;
    }

    /**
     * <p>
     * The number of days to retain data about successful runs of this canary.
     * </p>
     * 
     * @return The number of days to retain data about successful runs of this canary.
     */
    public Integer successRetentionPeriodInDays() {
        return successRetentionPeriodInDays;
    }

    /**
     * <p>
     * The number of days to retain data about failed runs of this canary.
     * </p>
     * 
     * @return The number of days to retain data about failed runs of this canary.
     */
    public Integer failureRetentionPeriodInDays() {
        return failureRetentionPeriodInDays;
    }

    /**
     * <p>
     * If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security
     * groups of the VPC endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">
     * Running a Canary in a VPC</a>.
     * </p>
     * 
     * @return If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and
     *         security groups of the VPC endpoint. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">
     *         Running a Canary in a VPC</a>.
     */
    public VpcConfigInput vpcConfig() {
        return vpcConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(runConfig());
        hashCode = 31 * hashCode + Objects.hashCode(successRetentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(failureRetentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCanaryRequest)) {
            return false;
        }
        UpdateCanaryRequest other = (UpdateCanaryRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(code(), other.code())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(runtimeVersion(), other.runtimeVersion()) && Objects.equals(schedule(), other.schedule())
                && Objects.equals(runConfig(), other.runConfig())
                && Objects.equals(successRetentionPeriodInDays(), other.successRetentionPeriodInDays())
                && Objects.equals(failureRetentionPeriodInDays(), other.failureRetentionPeriodInDays())
                && Objects.equals(vpcConfig(), other.vpcConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateCanaryRequest").add("Name", name()).add("Code", code())
                .add("ExecutionRoleArn", executionRoleArn()).add("RuntimeVersion", runtimeVersion()).add("Schedule", schedule())
                .add("RunConfig", runConfig()).add("SuccessRetentionPeriodInDays", successRetentionPeriodInDays())
                .add("FailureRetentionPeriodInDays", failureRetentionPeriodInDays()).add("VpcConfig", vpcConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "RuntimeVersion":
            return Optional.ofNullable(clazz.cast(runtimeVersion()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "RunConfig":
            return Optional.ofNullable(clazz.cast(runConfig()));
        case "SuccessRetentionPeriodInDays":
            return Optional.ofNullable(clazz.cast(successRetentionPeriodInDays()));
        case "FailureRetentionPeriodInDays":
            return Optional.ofNullable(clazz.cast(failureRetentionPeriodInDays()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCanaryRequest, T> g) {
        return obj -> g.apply((UpdateCanaryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SyntheticsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCanaryRequest> {
        /**
         * <p>
         * The name of the canary that you want to update. To find the names of your canaries, use <a
         * href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html"
         * >DescribeCanaries</a>.
         * </p>
         * <p>
         * You cannot change the name of a canary that has already been created.
         * </p>
         * 
         * @param name
         *        The name of the canary that you want to update. To find the names of your canaries, use <a
         *        href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html"
         *        >DescribeCanaries</a>.</p>
         *        <p>
         *        You cannot change the name of a canary that has already been created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A structure that includes the entry point from which the canary should start running your script. If the
         * script is stored in an S3 bucket, the bucket name, key, and version are also included.
         * </p>
         * 
         * @param code
         *        A structure that includes the entry point from which the canary should start running your script. If
         *        the script is stored in an S3 bucket, the bucket name, key, and version are also included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(CanaryCodeInput code);

        /**
         * <p>
         * A structure that includes the entry point from which the canary should start running your script. If the
         * script is stored in an S3 bucket, the bucket name, key, and version are also included.
         * </p>
         * This is a convenience that creates an instance of the {@link CanaryCodeInput.Builder} avoiding the need to
         * create one manually via {@link CanaryCodeInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link CanaryCodeInput.Builder#build()} is called immediately and its
         * result is passed to {@link #code(CanaryCodeInput)}.
         * 
         * @param code
         *        a consumer that will call methods on {@link CanaryCodeInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #code(CanaryCodeInput)
         */
        default Builder code(Consumer<CanaryCodeInput.Builder> code) {
            return code(CanaryCodeInput.builder().applyMutation(code).build());
        }

        /**
         * <p>
         * The ARN of the IAM role to be used to run the canary. This role must already exist, and must include
         * <code>lambda.amazonaws.com</code> as a principal in the trust policy. The role must also have the following
         * permissions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>s3:PutObject</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:GetBucketLocation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:ListAllMyBuckets</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cloudwatch:PutMetricData</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>logs:CreateLogGroup</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>logs:CreateLogStream</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>logs:CreateLogStream</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param executionRoleArn
         *        The ARN of the IAM role to be used to run the canary. This role must already exist, and must include
         *        <code>lambda.amazonaws.com</code> as a principal in the trust policy. The role must also have the
         *        following permissions:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>s3:PutObject</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:GetBucketLocation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:ListAllMyBuckets</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cloudwatch:PutMetricData</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>logs:CreateLogGroup</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>logs:CreateLogStream</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>logs:CreateLogStream</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * Specifies the runtime version to use for the canary. Currently, the only valid values are
         * <code>syn-nodejs-2.0</code>, <code>syn-nodejs-2.0-beta</code>, and <code>syn-1.0</code>. For more information
         * about runtime versions, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
         * Canary Runtime Versions</a>.
         * </p>
         * 
         * @param runtimeVersion
         *        Specifies the runtime version to use for the canary. Currently, the only valid values are
         *        <code>syn-nodejs-2.0</code>, <code>syn-nodejs-2.0-beta</code>, and <code>syn-1.0</code>. For more
         *        information about runtime versions, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html"
         *        > Canary Runtime Versions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeVersion(String runtimeVersion);

        /**
         * <p>
         * A structure that contains information about how often the canary is to run, and when these runs are to stop.
         * </p>
         * 
         * @param schedule
         *        A structure that contains information about how often the canary is to run, and when these runs are to
         *        stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(CanaryScheduleInput schedule);

        /**
         * <p>
         * A structure that contains information about how often the canary is to run, and when these runs are to stop.
         * </p>
         * This is a convenience that creates an instance of the {@link CanaryScheduleInput.Builder} avoiding the need
         * to create one manually via {@link CanaryScheduleInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link CanaryScheduleInput.Builder#build()} is called immediately and
         * its result is passed to {@link #schedule(CanaryScheduleInput)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link CanaryScheduleInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(CanaryScheduleInput)
         */
        default Builder schedule(Consumer<CanaryScheduleInput.Builder> schedule) {
            return schedule(CanaryScheduleInput.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * A structure that contains the timeout value that is used for each individual run of the canary.
         * </p>
         * 
         * @param runConfig
         *        A structure that contains the timeout value that is used for each individual run of the canary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runConfig(CanaryRunConfigInput runConfig);

        /**
         * <p>
         * A structure that contains the timeout value that is used for each individual run of the canary.
         * </p>
         * This is a convenience that creates an instance of the {@link CanaryRunConfigInput.Builder} avoiding the need
         * to create one manually via {@link CanaryRunConfigInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link CanaryRunConfigInput.Builder#build()} is called immediately and
         * its result is passed to {@link #runConfig(CanaryRunConfigInput)}.
         * 
         * @param runConfig
         *        a consumer that will call methods on {@link CanaryRunConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runConfig(CanaryRunConfigInput)
         */
        default Builder runConfig(Consumer<CanaryRunConfigInput.Builder> runConfig) {
            return runConfig(CanaryRunConfigInput.builder().applyMutation(runConfig).build());
        }

        /**
         * <p>
         * The number of days to retain data about successful runs of this canary.
         * </p>
         * 
         * @param successRetentionPeriodInDays
         *        The number of days to retain data about successful runs of this canary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successRetentionPeriodInDays(Integer successRetentionPeriodInDays);

        /**
         * <p>
         * The number of days to retain data about failed runs of this canary.
         * </p>
         * 
         * @param failureRetentionPeriodInDays
         *        The number of days to retain data about failed runs of this canary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureRetentionPeriodInDays(Integer failureRetentionPeriodInDays);

        /**
         * <p>
         * If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and
         * security groups of the VPC endpoint. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">
         * Running a Canary in a VPC</a>.
         * </p>
         * 
         * @param vpcConfig
         *        If this canary is to test an endpoint in a VPC, this structure contains information about the subnet
         *        and security groups of the VPC endpoint. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html"
         *        > Running a Canary in a VPC</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfigInput vpcConfig);

        /**
         * <p>
         * If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and
         * security groups of the VPC endpoint. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">
         * Running a Canary in a VPC</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfigInput.Builder} avoiding the need to
         * create one manually via {@link VpcConfigInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfigInput.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfig(VpcConfigInput)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfigInput)
         */
        default Builder vpcConfig(Consumer<VpcConfigInput.Builder> vpcConfig) {
            return vpcConfig(VpcConfigInput.builder().applyMutation(vpcConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SyntheticsRequest.BuilderImpl implements Builder {
        private String name;

        private CanaryCodeInput code;

        private String executionRoleArn;

        private String runtimeVersion;

        private CanaryScheduleInput schedule;

        private CanaryRunConfigInput runConfig;

        private Integer successRetentionPeriodInDays;

        private Integer failureRetentionPeriodInDays;

        private VpcConfigInput vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCanaryRequest model) {
            super(model);
            name(model.name);
            code(model.code);
            executionRoleArn(model.executionRoleArn);
            runtimeVersion(model.runtimeVersion);
            schedule(model.schedule);
            runConfig(model.runConfig);
            successRetentionPeriodInDays(model.successRetentionPeriodInDays);
            failureRetentionPeriodInDays(model.failureRetentionPeriodInDays);
            vpcConfig(model.vpcConfig);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final CanaryCodeInput.Builder getCode() {
            return code != null ? code.toBuilder() : null;
        }

        @Override
        public final Builder code(CanaryCodeInput code) {
            this.code = code;
            return this;
        }

        public final void setCode(CanaryCodeInput.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final String getRuntimeVersion() {
            return runtimeVersion;
        }

        @Override
        public final Builder runtimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
            return this;
        }

        public final void setRuntimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
        }

        public final CanaryScheduleInput.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        @Override
        public final Builder schedule(CanaryScheduleInput schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(CanaryScheduleInput.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        public final CanaryRunConfigInput.Builder getRunConfig() {
            return runConfig != null ? runConfig.toBuilder() : null;
        }

        @Override
        public final Builder runConfig(CanaryRunConfigInput runConfig) {
            this.runConfig = runConfig;
            return this;
        }

        public final void setRunConfig(CanaryRunConfigInput.BuilderImpl runConfig) {
            this.runConfig = runConfig != null ? runConfig.build() : null;
        }

        public final Integer getSuccessRetentionPeriodInDays() {
            return successRetentionPeriodInDays;
        }

        @Override
        public final Builder successRetentionPeriodInDays(Integer successRetentionPeriodInDays) {
            this.successRetentionPeriodInDays = successRetentionPeriodInDays;
            return this;
        }

        public final void setSuccessRetentionPeriodInDays(Integer successRetentionPeriodInDays) {
            this.successRetentionPeriodInDays = successRetentionPeriodInDays;
        }

        public final Integer getFailureRetentionPeriodInDays() {
            return failureRetentionPeriodInDays;
        }

        @Override
        public final Builder failureRetentionPeriodInDays(Integer failureRetentionPeriodInDays) {
            this.failureRetentionPeriodInDays = failureRetentionPeriodInDays;
            return this;
        }

        public final void setFailureRetentionPeriodInDays(Integer failureRetentionPeriodInDays) {
            this.failureRetentionPeriodInDays = failureRetentionPeriodInDays;
        }

        public final VpcConfigInput.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfigInput vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfigInput.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCanaryRequest build() {
            return new UpdateCanaryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
