/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains information about one canary runtime version. For more information about runtime versions,
 * see <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
 * Canary Runtime Versions</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuntimeVersion implements SdkPojo, Serializable, ToCopyableBuilder<RuntimeVersion.Builder, RuntimeVersion> {
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RuntimeVersion::versionName)).setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RuntimeVersion::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> RELEASE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(RuntimeVersion::releaseDate)).setter(setter(Builder::releaseDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseDate").build()).build();

    private static final SdkField<Instant> DEPRECATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(RuntimeVersion::deprecationDate)).setter(setter(Builder::deprecationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_NAME_FIELD,
            DESCRIPTION_FIELD, RELEASE_DATE_FIELD, DEPRECATION_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String versionName;

    private final String description;

    private final Instant releaseDate;

    private final Instant deprecationDate;

    private RuntimeVersion(BuilderImpl builder) {
        this.versionName = builder.versionName;
        this.description = builder.description;
        this.releaseDate = builder.releaseDate;
        this.deprecationDate = builder.deprecationDate;
    }

    /**
     * <p>
     * The name of the runtime version. Currently, the only valid values are <code>syn-nodejs-2.0</code>,
     * <code>syn-nodejs-2.0-beta</code>, and <code>syn-1.0</code>.
     * </p>
     * 
     * @return The name of the runtime version. Currently, the only valid values are <code>syn-nodejs-2.0</code>,
     *         <code>syn-nodejs-2.0-beta</code>, and <code>syn-1.0</code>.
     */
    public String versionName() {
        return versionName;
    }

    /**
     * <p>
     * A description of the runtime version, created by Amazon.
     * </p>
     * 
     * @return A description of the runtime version, created by Amazon.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The date that the runtime version was released.
     * </p>
     * 
     * @return The date that the runtime version was released.
     */
    public Instant releaseDate() {
        return releaseDate;
    }

    /**
     * <p>
     * If this runtime version is deprecated, this value is the date of deprecation.
     * </p>
     * 
     * @return If this runtime version is deprecated, this value is the date of deprecation.
     */
    public Instant deprecationDate() {
        return deprecationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(releaseDate());
        hashCode = 31 * hashCode + Objects.hashCode(deprecationDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimeVersion)) {
            return false;
        }
        RuntimeVersion other = (RuntimeVersion) obj;
        return Objects.equals(versionName(), other.versionName()) && Objects.equals(description(), other.description())
                && Objects.equals(releaseDate(), other.releaseDate())
                && Objects.equals(deprecationDate(), other.deprecationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RuntimeVersion").add("VersionName", versionName()).add("Description", description())
                .add("ReleaseDate", releaseDate()).add("DeprecationDate", deprecationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VersionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ReleaseDate":
            return Optional.ofNullable(clazz.cast(releaseDate()));
        case "DeprecationDate":
            return Optional.ofNullable(clazz.cast(deprecationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuntimeVersion, T> g) {
        return obj -> g.apply((RuntimeVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuntimeVersion> {
        /**
         * <p>
         * The name of the runtime version. Currently, the only valid values are <code>syn-nodejs-2.0</code>,
         * <code>syn-nodejs-2.0-beta</code>, and <code>syn-1.0</code>.
         * </p>
         * 
         * @param versionName
         *        The name of the runtime version. Currently, the only valid values are <code>syn-nodejs-2.0</code>,
         *        <code>syn-nodejs-2.0-beta</code>, and <code>syn-1.0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * A description of the runtime version, created by Amazon.
         * </p>
         * 
         * @param description
         *        A description of the runtime version, created by Amazon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date that the runtime version was released.
         * </p>
         * 
         * @param releaseDate
         *        The date that the runtime version was released.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseDate(Instant releaseDate);

        /**
         * <p>
         * If this runtime version is deprecated, this value is the date of deprecation.
         * </p>
         * 
         * @param deprecationDate
         *        If this runtime version is deprecated, this value is the date of deprecation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecationDate(Instant deprecationDate);
    }

    static final class BuilderImpl implements Builder {
        private String versionName;

        private String description;

        private Instant releaseDate;

        private Instant deprecationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimeVersion model) {
            versionName(model.versionName);
            description(model.description);
            releaseDate(model.releaseDate);
            deprecationDate(model.deprecationDate);
        }

        public final String getVersionName() {
            return versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getReleaseDate() {
            return releaseDate;
        }

        @Override
        public final Builder releaseDate(Instant releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public final void setReleaseDate(Instant releaseDate) {
            this.releaseDate = releaseDate;
        }

        public final Instant getDeprecationDate() {
            return deprecationDate;
        }

        @Override
        public final Builder deprecationDate(Instant deprecationDate) {
            this.deprecationDate = deprecationDate;
            return this;
        }

        public final void setDeprecationDate(Instant deprecationDate) {
            this.deprecationDate = deprecationDate;
        }

        @Override
        public RuntimeVersion build() {
            return new RuntimeVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
