/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCanaryRequest extends SyntheticsRequest implements
        ToCopyableBuilder<CreateCanaryRequest.Builder, CreateCanaryRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateCanaryRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<CanaryCodeInput> CODE_FIELD = SdkField.<CanaryCodeInput> builder(MarshallingType.SDK_POJO)
            .memberName("Code").getter(getter(CreateCanaryRequest::code)).setter(setter(Builder::code))
            .constructor(CanaryCodeInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> ARTIFACT_S3_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactS3Location").getter(getter(CreateCanaryRequest::artifactS3Location))
            .setter(setter(Builder::artifactS3Location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactS3Location").build())
            .build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(CreateCanaryRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<CanaryScheduleInput> SCHEDULE_FIELD = SdkField
            .<CanaryScheduleInput> builder(MarshallingType.SDK_POJO).memberName("Schedule")
            .getter(getter(CreateCanaryRequest::schedule)).setter(setter(Builder::schedule))
            .constructor(CanaryScheduleInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<CanaryRunConfigInput> RUN_CONFIG_FIELD = SdkField
            .<CanaryRunConfigInput> builder(MarshallingType.SDK_POJO).memberName("RunConfig")
            .getter(getter(CreateCanaryRequest::runConfig)).setter(setter(Builder::runConfig))
            .constructor(CanaryRunConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunConfig").build()).build();

    private static final SdkField<Integer> SUCCESS_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SuccessRetentionPeriodInDays")
            .getter(getter(CreateCanaryRequest::successRetentionPeriodInDays))
            .setter(setter(Builder::successRetentionPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessRetentionPeriodInDays")
                    .build()).build();

    private static final SdkField<Integer> FAILURE_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("FailureRetentionPeriodInDays")
            .getter(getter(CreateCanaryRequest::failureRetentionPeriodInDays))
            .setter(setter(Builder::failureRetentionPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureRetentionPeriodInDays")
                    .build()).build();

    private static final SdkField<String> RUNTIME_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuntimeVersion").getter(getter(CreateCanaryRequest::runtimeVersion))
            .setter(setter(Builder::runtimeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeVersion").build()).build();

    private static final SdkField<VpcConfigInput> VPC_CONFIG_FIELD = SdkField.<VpcConfigInput> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(CreateCanaryRequest::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateCanaryRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CODE_FIELD,
            ARTIFACT_S3_LOCATION_FIELD, EXECUTION_ROLE_ARN_FIELD, SCHEDULE_FIELD, RUN_CONFIG_FIELD,
            SUCCESS_RETENTION_PERIOD_IN_DAYS_FIELD, FAILURE_RETENTION_PERIOD_IN_DAYS_FIELD, RUNTIME_VERSION_FIELD,
            VPC_CONFIG_FIELD, TAGS_FIELD));

    private final String name;

    private final CanaryCodeInput code;

    private final String artifactS3Location;

    private final String executionRoleArn;

    private final CanaryScheduleInput schedule;

    private final CanaryRunConfigInput runConfig;

    private final Integer successRetentionPeriodInDays;

    private final Integer failureRetentionPeriodInDays;

    private final String runtimeVersion;

    private final VpcConfigInput vpcConfig;

    private final Map<String, String> tags;

    private CreateCanaryRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.code = builder.code;
        this.artifactS3Location = builder.artifactS3Location;
        this.executionRoleArn = builder.executionRoleArn;
        this.schedule = builder.schedule;
        this.runConfig = builder.runConfig;
        this.successRetentionPeriodInDays = builder.successRetentionPeriodInDays;
        this.failureRetentionPeriodInDays = builder.failureRetentionPeriodInDays;
        this.runtimeVersion = builder.runtimeVersion;
        this.vpcConfig = builder.vpcConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name for this canary. Be sure to give it a descriptive name that distinguishes it from other canaries in your
     * account.
     * </p>
     * <p>
     * Do not include secrets or proprietary information in your canary names. The canary name makes up part of the
     * canary ARN, and the ARN is included in outbound calls over the internet. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html">Security
     * Considerations for Synthetics Canaries</a>.
     * </p>
     * 
     * @return The name for this canary. Be sure to give it a descriptive name that distinguishes it from other canaries
     *         in your account.</p>
     *         <p>
     *         Do not include secrets or proprietary information in your canary names. The canary name makes up part of
     *         the canary ARN, and the ARN is included in outbound calls over the internet. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html">
     *         Security Considerations for Synthetics Canaries</a>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A structure that includes the entry point from which the canary should start running your script. If the script
     * is stored in an S3 bucket, the bucket name, key, and version are also included.
     * </p>
     * 
     * @return A structure that includes the entry point from which the canary should start running your script. If the
     *         script is stored in an S3 bucket, the bucket name, key, and version are also included.
     */
    public CanaryCodeInput code() {
        return code;
    }

    /**
     * <p>
     * The location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary. Artifacts include
     * the log file, screenshots, and HAR files.
     * </p>
     * 
     * @return The location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary. Artifacts
     *         include the log file, screenshots, and HAR files.
     */
    public String artifactS3Location() {
        return artifactS3Location;
    }

    /**
     * <p>
     * The ARN of the IAM role to be used to run the canary. This role must already exist, and must include
     * <code>lambda.amazonaws.com</code> as a principal in the trust policy. The role must also have the following
     * permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>s3:PutObject</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:GetBucketLocation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:ListAllMyBuckets</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cloudwatch:PutMetricData</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>logs:CreateLogGroup</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>logs:CreateLogStream</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>logs:PutLogEvents</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The ARN of the IAM role to be used to run the canary. This role must already exist, and must include
     *         <code>lambda.amazonaws.com</code> as a principal in the trust policy. The role must also have the
     *         following permissions:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>s3:PutObject</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:GetBucketLocation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:ListAllMyBuckets</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cloudwatch:PutMetricData</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>logs:CreateLogGroup</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>logs:CreateLogStream</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>logs:PutLogEvents</code>
     *         </p>
     *         </li>
     */
    public String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * A structure that contains information about how often the canary is to run and when these test runs are to stop.
     * </p>
     * 
     * @return A structure that contains information about how often the canary is to run and when these test runs are
     *         to stop.
     */
    public CanaryScheduleInput schedule() {
        return schedule;
    }

    /**
     * <p>
     * A structure that contains the configuration for individual canary runs, such as timeout value.
     * </p>
     * 
     * @return A structure that contains the configuration for individual canary runs, such as timeout value.
     */
    public CanaryRunConfigInput runConfig() {
        return runConfig;
    }

    /**
     * <p>
     * The number of days to retain data about successful runs of this canary. If you omit this field, the default of 31
     * days is used. The valid range is 1 to 455 days.
     * </p>
     * 
     * @return The number of days to retain data about successful runs of this canary. If you omit this field, the
     *         default of 31 days is used. The valid range is 1 to 455 days.
     */
    public Integer successRetentionPeriodInDays() {
        return successRetentionPeriodInDays;
    }

    /**
     * <p>
     * The number of days to retain data about failed runs of this canary. If you omit this field, the default of 31
     * days is used. The valid range is 1 to 455 days.
     * </p>
     * 
     * @return The number of days to retain data about failed runs of this canary. If you omit this field, the default
     *         of 31 days is used. The valid range is 1 to 455 days.
     */
    public Integer failureRetentionPeriodInDays() {
        return failureRetentionPeriodInDays;
    }

    /**
     * <p>
     * Specifies the runtime version to use for the canary. Currently, the only valid values are
     * <code>syn-nodejs-2.0</code>, <code>syn-nodejs-2.0-beta</code>, and <code>syn-1.0</code>. For more information
     * about runtime versions, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
     * Canary Runtime Versions</a>.
     * </p>
     * 
     * @return Specifies the runtime version to use for the canary. Currently, the only valid values are
     *         <code>syn-nodejs-2.0</code>, <code>syn-nodejs-2.0-beta</code>, and <code>syn-1.0</code>. For more
     *         information about runtime versions, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html"
     *         > Canary Runtime Versions</a>.
     */
    public String runtimeVersion() {
        return runtimeVersion;
    }

    /**
     * <p>
     * If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security
     * groups of the VPC endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">
     * Running a Canary in a VPC</a>.
     * </p>
     * 
     * @return If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and
     *         security groups of the VPC endpoint. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">
     *         Running a Canary in a VPC</a>.
     */
    public VpcConfigInput vpcConfig() {
        return vpcConfig;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs to associate with the canary. You can associate as many as 50 tags with a canary.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by
     * granting a user permission to access or change only the resources that have certain tag values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of key-value pairs to associate with the canary. You can associate as many as 50 tags with a
     *         canary.</p>
     *         <p>
     *         Tags can help you organize and categorize your resources. You can also use them to scope user
     *         permissions, by granting a user permission to access or change only the resources that have certain tag
     *         values.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(artifactS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(runConfig());
        hashCode = 31 * hashCode + Objects.hashCode(successRetentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(failureRetentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCanaryRequest)) {
            return false;
        }
        CreateCanaryRequest other = (CreateCanaryRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(code(), other.code())
                && Objects.equals(artifactS3Location(), other.artifactS3Location())
                && Objects.equals(executionRoleArn(), other.executionRoleArn()) && Objects.equals(schedule(), other.schedule())
                && Objects.equals(runConfig(), other.runConfig())
                && Objects.equals(successRetentionPeriodInDays(), other.successRetentionPeriodInDays())
                && Objects.equals(failureRetentionPeriodInDays(), other.failureRetentionPeriodInDays())
                && Objects.equals(runtimeVersion(), other.runtimeVersion()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateCanaryRequest").add("Name", name()).add("Code", code())
                .add("ArtifactS3Location", artifactS3Location()).add("ExecutionRoleArn", executionRoleArn())
                .add("Schedule", schedule()).add("RunConfig", runConfig())
                .add("SuccessRetentionPeriodInDays", successRetentionPeriodInDays())
                .add("FailureRetentionPeriodInDays", failureRetentionPeriodInDays()).add("RuntimeVersion", runtimeVersion())
                .add("VpcConfig", vpcConfig()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "ArtifactS3Location":
            return Optional.ofNullable(clazz.cast(artifactS3Location()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "RunConfig":
            return Optional.ofNullable(clazz.cast(runConfig()));
        case "SuccessRetentionPeriodInDays":
            return Optional.ofNullable(clazz.cast(successRetentionPeriodInDays()));
        case "FailureRetentionPeriodInDays":
            return Optional.ofNullable(clazz.cast(failureRetentionPeriodInDays()));
        case "RuntimeVersion":
            return Optional.ofNullable(clazz.cast(runtimeVersion()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCanaryRequest, T> g) {
        return obj -> g.apply((CreateCanaryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SyntheticsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCanaryRequest> {
        /**
         * <p>
         * The name for this canary. Be sure to give it a descriptive name that distinguishes it from other canaries in
         * your account.
         * </p>
         * <p>
         * Do not include secrets or proprietary information in your canary names. The canary name makes up part of the
         * canary ARN, and the ARN is included in outbound calls over the internet. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html"
         * >Security Considerations for Synthetics Canaries</a>.
         * </p>
         * 
         * @param name
         *        The name for this canary. Be sure to give it a descriptive name that distinguishes it from other
         *        canaries in your account.</p>
         *        <p>
         *        Do not include secrets or proprietary information in your canary names. The canary name makes up part
         *        of the canary ARN, and the ARN is included in outbound calls over the internet. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html"
         *        >Security Considerations for Synthetics Canaries</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A structure that includes the entry point from which the canary should start running your script. If the
         * script is stored in an S3 bucket, the bucket name, key, and version are also included.
         * </p>
         * 
         * @param code
         *        A structure that includes the entry point from which the canary should start running your script. If
         *        the script is stored in an S3 bucket, the bucket name, key, and version are also included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(CanaryCodeInput code);

        /**
         * <p>
         * A structure that includes the entry point from which the canary should start running your script. If the
         * script is stored in an S3 bucket, the bucket name, key, and version are also included.
         * </p>
         * This is a convenience that creates an instance of the {@link CanaryCodeInput.Builder} avoiding the need to
         * create one manually via {@link CanaryCodeInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link CanaryCodeInput.Builder#build()} is called immediately and its
         * result is passed to {@link #code(CanaryCodeInput)}.
         * 
         * @param code
         *        a consumer that will call methods on {@link CanaryCodeInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #code(CanaryCodeInput)
         */
        default Builder code(Consumer<CanaryCodeInput.Builder> code) {
            return code(CanaryCodeInput.builder().applyMutation(code).build());
        }

        /**
         * <p>
         * The location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary. Artifacts
         * include the log file, screenshots, and HAR files.
         * </p>
         * 
         * @param artifactS3Location
         *        The location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary.
         *        Artifacts include the log file, screenshots, and HAR files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactS3Location(String artifactS3Location);

        /**
         * <p>
         * The ARN of the IAM role to be used to run the canary. This role must already exist, and must include
         * <code>lambda.amazonaws.com</code> as a principal in the trust policy. The role must also have the following
         * permissions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>s3:PutObject</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:GetBucketLocation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:ListAllMyBuckets</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cloudwatch:PutMetricData</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>logs:CreateLogGroup</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>logs:CreateLogStream</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>logs:PutLogEvents</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param executionRoleArn
         *        The ARN of the IAM role to be used to run the canary. This role must already exist, and must include
         *        <code>lambda.amazonaws.com</code> as a principal in the trust policy. The role must also have the
         *        following permissions:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>s3:PutObject</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:GetBucketLocation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:ListAllMyBuckets</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cloudwatch:PutMetricData</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>logs:CreateLogGroup</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>logs:CreateLogStream</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>logs:PutLogEvents</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * A structure that contains information about how often the canary is to run and when these test runs are to
         * stop.
         * </p>
         * 
         * @param schedule
         *        A structure that contains information about how often the canary is to run and when these test runs
         *        are to stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(CanaryScheduleInput schedule);

        /**
         * <p>
         * A structure that contains information about how often the canary is to run and when these test runs are to
         * stop.
         * </p>
         * This is a convenience that creates an instance of the {@link CanaryScheduleInput.Builder} avoiding the need
         * to create one manually via {@link CanaryScheduleInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link CanaryScheduleInput.Builder#build()} is called immediately and
         * its result is passed to {@link #schedule(CanaryScheduleInput)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link CanaryScheduleInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(CanaryScheduleInput)
         */
        default Builder schedule(Consumer<CanaryScheduleInput.Builder> schedule) {
            return schedule(CanaryScheduleInput.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * A structure that contains the configuration for individual canary runs, such as timeout value.
         * </p>
         * 
         * @param runConfig
         *        A structure that contains the configuration for individual canary runs, such as timeout value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runConfig(CanaryRunConfigInput runConfig);

        /**
         * <p>
         * A structure that contains the configuration for individual canary runs, such as timeout value.
         * </p>
         * This is a convenience that creates an instance of the {@link CanaryRunConfigInput.Builder} avoiding the need
         * to create one manually via {@link CanaryRunConfigInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link CanaryRunConfigInput.Builder#build()} is called immediately and
         * its result is passed to {@link #runConfig(CanaryRunConfigInput)}.
         * 
         * @param runConfig
         *        a consumer that will call methods on {@link CanaryRunConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runConfig(CanaryRunConfigInput)
         */
        default Builder runConfig(Consumer<CanaryRunConfigInput.Builder> runConfig) {
            return runConfig(CanaryRunConfigInput.builder().applyMutation(runConfig).build());
        }

        /**
         * <p>
         * The number of days to retain data about successful runs of this canary. If you omit this field, the default
         * of 31 days is used. The valid range is 1 to 455 days.
         * </p>
         * 
         * @param successRetentionPeriodInDays
         *        The number of days to retain data about successful runs of this canary. If you omit this field, the
         *        default of 31 days is used. The valid range is 1 to 455 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successRetentionPeriodInDays(Integer successRetentionPeriodInDays);

        /**
         * <p>
         * The number of days to retain data about failed runs of this canary. If you omit this field, the default of 31
         * days is used. The valid range is 1 to 455 days.
         * </p>
         * 
         * @param failureRetentionPeriodInDays
         *        The number of days to retain data about failed runs of this canary. If you omit this field, the
         *        default of 31 days is used. The valid range is 1 to 455 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureRetentionPeriodInDays(Integer failureRetentionPeriodInDays);

        /**
         * <p>
         * Specifies the runtime version to use for the canary. Currently, the only valid values are
         * <code>syn-nodejs-2.0</code>, <code>syn-nodejs-2.0-beta</code>, and <code>syn-1.0</code>. For more information
         * about runtime versions, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
         * Canary Runtime Versions</a>.
         * </p>
         * 
         * @param runtimeVersion
         *        Specifies the runtime version to use for the canary. Currently, the only valid values are
         *        <code>syn-nodejs-2.0</code>, <code>syn-nodejs-2.0-beta</code>, and <code>syn-1.0</code>. For more
         *        information about runtime versions, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html"
         *        > Canary Runtime Versions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeVersion(String runtimeVersion);

        /**
         * <p>
         * If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and
         * security groups of the VPC endpoint. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">
         * Running a Canary in a VPC</a>.
         * </p>
         * 
         * @param vpcConfig
         *        If this canary is to test an endpoint in a VPC, this structure contains information about the subnet
         *        and security groups of the VPC endpoint. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html"
         *        > Running a Canary in a VPC</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfigInput vpcConfig);

        /**
         * <p>
         * If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and
         * security groups of the VPC endpoint. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">
         * Running a Canary in a VPC</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfigInput.Builder} avoiding the need to
         * create one manually via {@link VpcConfigInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfigInput.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfig(VpcConfigInput)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfigInput)
         */
        default Builder vpcConfig(Consumer<VpcConfigInput.Builder> vpcConfig) {
            return vpcConfig(VpcConfigInput.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * A list of key-value pairs to associate with the canary. You can associate as many as 50 tags with a canary.
         * </p>
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by
         * granting a user permission to access or change only the resources that have certain tag values.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to associate with the canary. You can associate as many as 50 tags with a
         *        canary.</p>
         *        <p>
         *        Tags can help you organize and categorize your resources. You can also use them to scope user
         *        permissions, by granting a user permission to access or change only the resources that have certain
         *        tag values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SyntheticsRequest.BuilderImpl implements Builder {
        private String name;

        private CanaryCodeInput code;

        private String artifactS3Location;

        private String executionRoleArn;

        private CanaryScheduleInput schedule;

        private CanaryRunConfigInput runConfig;

        private Integer successRetentionPeriodInDays;

        private Integer failureRetentionPeriodInDays;

        private String runtimeVersion;

        private VpcConfigInput vpcConfig;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCanaryRequest model) {
            super(model);
            name(model.name);
            code(model.code);
            artifactS3Location(model.artifactS3Location);
            executionRoleArn(model.executionRoleArn);
            schedule(model.schedule);
            runConfig(model.runConfig);
            successRetentionPeriodInDays(model.successRetentionPeriodInDays);
            failureRetentionPeriodInDays(model.failureRetentionPeriodInDays);
            runtimeVersion(model.runtimeVersion);
            vpcConfig(model.vpcConfig);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final CanaryCodeInput.Builder getCode() {
            return code != null ? code.toBuilder() : null;
        }

        @Override
        public final Builder code(CanaryCodeInput code) {
            this.code = code;
            return this;
        }

        public final void setCode(CanaryCodeInput.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        public final String getArtifactS3Location() {
            return artifactS3Location;
        }

        @Override
        public final Builder artifactS3Location(String artifactS3Location) {
            this.artifactS3Location = artifactS3Location;
            return this;
        }

        public final void setArtifactS3Location(String artifactS3Location) {
            this.artifactS3Location = artifactS3Location;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final CanaryScheduleInput.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        @Override
        public final Builder schedule(CanaryScheduleInput schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(CanaryScheduleInput.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        public final CanaryRunConfigInput.Builder getRunConfig() {
            return runConfig != null ? runConfig.toBuilder() : null;
        }

        @Override
        public final Builder runConfig(CanaryRunConfigInput runConfig) {
            this.runConfig = runConfig;
            return this;
        }

        public final void setRunConfig(CanaryRunConfigInput.BuilderImpl runConfig) {
            this.runConfig = runConfig != null ? runConfig.build() : null;
        }

        public final Integer getSuccessRetentionPeriodInDays() {
            return successRetentionPeriodInDays;
        }

        @Override
        public final Builder successRetentionPeriodInDays(Integer successRetentionPeriodInDays) {
            this.successRetentionPeriodInDays = successRetentionPeriodInDays;
            return this;
        }

        public final void setSuccessRetentionPeriodInDays(Integer successRetentionPeriodInDays) {
            this.successRetentionPeriodInDays = successRetentionPeriodInDays;
        }

        public final Integer getFailureRetentionPeriodInDays() {
            return failureRetentionPeriodInDays;
        }

        @Override
        public final Builder failureRetentionPeriodInDays(Integer failureRetentionPeriodInDays) {
            this.failureRetentionPeriodInDays = failureRetentionPeriodInDays;
            return this;
        }

        public final void setFailureRetentionPeriodInDays(Integer failureRetentionPeriodInDays) {
            this.failureRetentionPeriodInDays = failureRetentionPeriodInDays;
        }

        public final String getRuntimeVersion() {
            return runtimeVersion;
        }

        @Override
        public final Builder runtimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
            return this;
        }

        public final void setRuntimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
        }

        public final VpcConfigInput.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfigInput vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfigInput.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCanaryRequest build() {
            return new CreateCanaryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
