/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the current state of the canary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanaryStatus implements SdkPojo, Serializable, ToCopyableBuilder<CanaryStatus.Builder, CanaryStatus> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(CanaryStatus::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReason").getter(getter(CanaryStatus::stateReason)).setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()).build();

    private static final SdkField<String> STATE_REASON_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReasonCode").getter(getter(CanaryStatus::stateReasonCodeAsString))
            .setter(setter(Builder::stateReasonCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReasonCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            STATE_REASON_FIELD, STATE_REASON_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String state;

    private final String stateReason;

    private final String stateReasonCode;

    private CanaryStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.stateReasonCode = builder.stateReasonCode;
    }

    /**
     * <p>
     * The current state of the canary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CanaryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the canary.
     * @see CanaryState
     */
    public CanaryState state() {
        return CanaryState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the canary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CanaryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the canary.
     * @see CanaryState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * If the canary has insufficient permissions to run, this field provides more details.
     * </p>
     * 
     * @return If the canary has insufficient permissions to run, this field provides more details.
     */
    public String stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * If the canary cannot run or has failed, this field displays the reason.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateReasonCode}
     * will return {@link CanaryStateReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateReasonCodeAsString}.
     * </p>
     * 
     * @return If the canary cannot run or has failed, this field displays the reason.
     * @see CanaryStateReasonCode
     */
    public CanaryStateReasonCode stateReasonCode() {
        return CanaryStateReasonCode.fromValue(stateReasonCode);
    }

    /**
     * <p>
     * If the canary cannot run or has failed, this field displays the reason.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateReasonCode}
     * will return {@link CanaryStateReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateReasonCodeAsString}.
     * </p>
     * 
     * @return If the canary cannot run or has failed, this field displays the reason.
     * @see CanaryStateReasonCode
     */
    public String stateReasonCodeAsString() {
        return stateReasonCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(stateReasonCodeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryStatus)) {
            return false;
        }
        CanaryStatus other = (CanaryStatus) obj;
        return Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(stateReason(), other.stateReason())
                && Objects.equals(stateReasonCodeAsString(), other.stateReasonCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CanaryStatus").add("State", stateAsString()).add("StateReason", stateReason())
                .add("StateReasonCode", stateReasonCodeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "StateReasonCode":
            return Optional.ofNullable(clazz.cast(stateReasonCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CanaryStatus, T> g) {
        return obj -> g.apply((CanaryStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanaryStatus> {
        /**
         * <p>
         * The current state of the canary.
         * </p>
         * 
         * @param state
         *        The current state of the canary.
         * @see CanaryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CanaryState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the canary.
         * </p>
         * 
         * @param state
         *        The current state of the canary.
         * @see CanaryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CanaryState
         */
        Builder state(CanaryState state);

        /**
         * <p>
         * If the canary has insufficient permissions to run, this field provides more details.
         * </p>
         * 
         * @param stateReason
         *        If the canary has insufficient permissions to run, this field provides more details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * If the canary cannot run or has failed, this field displays the reason.
         * </p>
         * 
         * @param stateReasonCode
         *        If the canary cannot run or has failed, this field displays the reason.
         * @see CanaryStateReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CanaryStateReasonCode
         */
        Builder stateReasonCode(String stateReasonCode);

        /**
         * <p>
         * If the canary cannot run or has failed, this field displays the reason.
         * </p>
         * 
         * @param stateReasonCode
         *        If the canary cannot run or has failed, this field displays the reason.
         * @see CanaryStateReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CanaryStateReasonCode
         */
        Builder stateReasonCode(CanaryStateReasonCode stateReasonCode);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private String stateReason;

        private String stateReasonCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryStatus model) {
            state(model.state);
            stateReason(model.stateReason);
            stateReasonCode(model.stateReasonCode);
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CanaryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateReason() {
            return stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        public final String getStateReasonCode() {
            return stateReasonCode;
        }

        @Override
        public final Builder stateReasonCode(String stateReasonCode) {
            this.stateReasonCode = stateReasonCode;
            return this;
        }

        @Override
        public final Builder stateReasonCode(CanaryStateReasonCode stateReasonCode) {
            this.stateReasonCode(stateReasonCode == null ? null : stateReasonCode.toString());
            return this;
        }

        public final void setStateReasonCode(String stateReasonCode) {
            this.stateReasonCode = stateReasonCode;
        }

        @Override
        public CanaryStatus build() {
            return new CanaryStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
