/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.synthetics.model.CanaryRunStatus;
import software.amazon.awssdk.services.synthetics.model.CanaryRunTimeline;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CanaryRun
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CanaryRun> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CanaryRun.getter(CanaryRun::id)).setter(CanaryRun.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CanaryRun.getter(CanaryRun::name)).setter(CanaryRun.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<CanaryRunStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(CanaryRun.getter(CanaryRun::status)).setter(CanaryRun.setter(Builder::status)).constructor(CanaryRunStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<CanaryRunTimeline> TIMELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Timeline").getter(CanaryRun.getter(CanaryRun::timeline)).setter(CanaryRun.setter(Builder::timeline)).constructor(CanaryRunTimeline::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeline").build()}).build();
    private static final SdkField<String> ARTIFACT_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArtifactS3Location").getter(CanaryRun.getter(CanaryRun::artifactS3Location)).setter(CanaryRun.setter(Builder::artifactS3Location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactS3Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, STATUS_FIELD, TIMELINE_FIELD, ARTIFACT_S3_LOCATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final CanaryRunStatus status;
    private final CanaryRunTimeline timeline;
    private final String artifactS3Location;

    private CanaryRun(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.timeline = builder.timeline;
        this.artifactS3Location = builder.artifactS3Location;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public CanaryRunStatus status() {
        return this.status;
    }

    public CanaryRunTimeline timeline() {
        return this.timeline;
    }

    public String artifactS3Location() {
        return this.artifactS3Location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeline());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactS3Location());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryRun)) {
            return false;
        }
        CanaryRun other = (CanaryRun)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.timeline(), other.timeline()) && Objects.equals(this.artifactS3Location(), other.artifactS3Location());
    }

    public String toString() {
        return ToString.builder((String)"CanaryRun").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Status", (Object)this.status()).add("Timeline", (Object)this.timeline()).add("ArtifactS3Location", (Object)this.artifactS3Location()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Timeline": {
                return Optional.ofNullable(clazz.cast(this.timeline()));
            }
            case "ArtifactS3Location": {
                return Optional.ofNullable(clazz.cast(this.artifactS3Location()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CanaryRun, T> g) {
        return obj -> g.apply((CanaryRun)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private CanaryRunStatus status;
        private CanaryRunTimeline timeline;
        private String artifactS3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryRun model) {
            this.id(model.id);
            this.name(model.name);
            this.status(model.status);
            this.timeline(model.timeline);
            this.artifactS3Location(model.artifactS3Location);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final CanaryRunStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(CanaryRunStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(CanaryRunStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final CanaryRunTimeline.Builder getTimeline() {
            return this.timeline != null ? this.timeline.toBuilder() : null;
        }

        @Override
        public final Builder timeline(CanaryRunTimeline timeline) {
            this.timeline = timeline;
            return this;
        }

        public final void setTimeline(CanaryRunTimeline.BuilderImpl timeline) {
            this.timeline = timeline != null ? timeline.build() : null;
        }

        public final String getArtifactS3Location() {
            return this.artifactS3Location;
        }

        @Override
        public final Builder artifactS3Location(String artifactS3Location) {
            this.artifactS3Location = artifactS3Location;
            return this;
        }

        public final void setArtifactS3Location(String artifactS3Location) {
            this.artifactS3Location = artifactS3Location;
        }

        public CanaryRun build() {
            return new CanaryRun(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CanaryRun> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder status(CanaryRunStatus var1);

        default public Builder status(Consumer<CanaryRunStatus.Builder> status) {
            return this.status((CanaryRunStatus)((CanaryRunStatus.Builder)CanaryRunStatus.builder().applyMutation(status)).build());
        }

        public Builder timeline(CanaryRunTimeline var1);

        default public Builder timeline(Consumer<CanaryRunTimeline.Builder> timeline) {
            return this.timeline((CanaryRunTimeline)((CanaryRunTimeline.Builder)CanaryRunTimeline.builder().applyMutation(timeline)).build());
        }

        public Builder artifactS3Location(String var1);
    }
}

