/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.synthetics.model.CanaryRun;
import software.amazon.awssdk.services.synthetics.model.CanaryRunsCopier;
import software.amazon.awssdk.services.synthetics.model.SyntheticsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCanaryRunsResponse
extends SyntheticsResponse
implements ToCopyableBuilder<Builder, GetCanaryRunsResponse> {
    private static final SdkField<List<CanaryRun>> CANARY_RUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CanaryRuns").getter(GetCanaryRunsResponse.getter(GetCanaryRunsResponse::canaryRuns)).setter(GetCanaryRunsResponse.setter(Builder::canaryRuns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanaryRuns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CanaryRun::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetCanaryRunsResponse.getter(GetCanaryRunsResponse::nextToken)).setter(GetCanaryRunsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANARY_RUNS_FIELD, NEXT_TOKEN_FIELD));
    private final List<CanaryRun> canaryRuns;
    private final String nextToken;

    private GetCanaryRunsResponse(BuilderImpl builder) {
        super(builder);
        this.canaryRuns = builder.canaryRuns;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCanaryRuns() {
        return this.canaryRuns != null && !(this.canaryRuns instanceof SdkAutoConstructList);
    }

    public final List<CanaryRun> canaryRuns() {
        return this.canaryRuns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCanaryRuns() ? this.canaryRuns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCanaryRunsResponse)) {
            return false;
        }
        GetCanaryRunsResponse other = (GetCanaryRunsResponse)((Object)obj);
        return this.hasCanaryRuns() == other.hasCanaryRuns() && Objects.equals(this.canaryRuns(), other.canaryRuns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetCanaryRunsResponse").add("CanaryRuns", this.hasCanaryRuns() ? this.canaryRuns() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CanaryRuns": {
                return Optional.ofNullable(clazz.cast(this.canaryRuns()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCanaryRunsResponse, T> g) {
        return obj -> g.apply((GetCanaryRunsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SyntheticsResponse.BuilderImpl
    implements Builder {
        private List<CanaryRun> canaryRuns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCanaryRunsResponse model) {
            super(model);
            this.canaryRuns(model.canaryRuns);
            this.nextToken(model.nextToken);
        }

        public final List<CanaryRun.Builder> getCanaryRuns() {
            List<CanaryRun.Builder> result = CanaryRunsCopier.copyToBuilder(this.canaryRuns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder canaryRuns(Collection<CanaryRun> canaryRuns) {
            this.canaryRuns = CanaryRunsCopier.copy(canaryRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder canaryRuns(CanaryRun ... canaryRuns) {
            this.canaryRuns(Arrays.asList(canaryRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder canaryRuns(Consumer<CanaryRun.Builder> ... canaryRuns) {
            this.canaryRuns(Stream.of(canaryRuns).map(c -> (CanaryRun)((CanaryRun.Builder)CanaryRun.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCanaryRuns(Collection<CanaryRun.BuilderImpl> canaryRuns) {
            this.canaryRuns = CanaryRunsCopier.copyFromBuilder(canaryRuns);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetCanaryRunsResponse build() {
            return new GetCanaryRunsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SyntheticsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCanaryRunsResponse> {
        public Builder canaryRuns(Collection<CanaryRun> var1);

        public Builder canaryRuns(CanaryRun ... var1);

        public Builder canaryRuns(Consumer<CanaryRun.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

