/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCanaryRunsResponse extends SyntheticsResponse implements
        ToCopyableBuilder<GetCanaryRunsResponse.Builder, GetCanaryRunsResponse> {
    private static final SdkField<List<CanaryRun>> CANARY_RUNS_FIELD = SdkField
            .<List<CanaryRun>> builder(MarshallingType.LIST)
            .memberName("CanaryRuns")
            .getter(getter(GetCanaryRunsResponse::canaryRuns))
            .setter(setter(Builder::canaryRuns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanaryRuns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CanaryRun> builder(MarshallingType.SDK_POJO)
                                            .constructor(CanaryRun::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetCanaryRunsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANARY_RUNS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<CanaryRun> canaryRuns;

    private final String nextToken;

    private GetCanaryRunsResponse(BuilderImpl builder) {
        super(builder);
        this.canaryRuns = builder.canaryRuns;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the CanaryRuns property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCanaryRuns() {
        return canaryRuns != null && !(canaryRuns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures. Each structure contains the details of one of the retrieved canary runs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCanaryRuns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of structures. Each structure contains the details of one of the retrieved canary runs.
     */
    public final List<CanaryRun> canaryRuns() {
        return canaryRuns;
    }

    /**
     * <p>
     * A token that indicates that there is more data available. You can use this token in a subsequent
     * <code>GetCanaryRuns</code> operation to retrieve the next set of results.
     * </p>
     * 
     * @return A token that indicates that there is more data available. You can use this token in a subsequent
     *         <code>GetCanaryRuns</code> operation to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCanaryRuns() ? canaryRuns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCanaryRunsResponse)) {
            return false;
        }
        GetCanaryRunsResponse other = (GetCanaryRunsResponse) obj;
        return hasCanaryRuns() == other.hasCanaryRuns() && Objects.equals(canaryRuns(), other.canaryRuns())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCanaryRunsResponse").add("CanaryRuns", hasCanaryRuns() ? canaryRuns() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CanaryRuns":
            return Optional.ofNullable(clazz.cast(canaryRuns()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCanaryRunsResponse, T> g) {
        return obj -> g.apply((GetCanaryRunsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SyntheticsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCanaryRunsResponse> {
        /**
         * <p>
         * An array of structures. Each structure contains the details of one of the retrieved canary runs.
         * </p>
         * 
         * @param canaryRuns
         *        An array of structures. Each structure contains the details of one of the retrieved canary runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canaryRuns(Collection<CanaryRun> canaryRuns);

        /**
         * <p>
         * An array of structures. Each structure contains the details of one of the retrieved canary runs.
         * </p>
         * 
         * @param canaryRuns
         *        An array of structures. Each structure contains the details of one of the retrieved canary runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canaryRuns(CanaryRun... canaryRuns);

        /**
         * <p>
         * An array of structures. Each structure contains the details of one of the retrieved canary runs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CanaryRun>.Builder} avoiding the need to
         * create one manually via {@link List<CanaryRun>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CanaryRun>.Builder#build()} is called immediately and its
         * result is passed to {@link #canaryRuns(List<CanaryRun>)}.
         * 
         * @param canaryRuns
         *        a consumer that will call methods on {@link List<CanaryRun>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #canaryRuns(List<CanaryRun>)
         */
        Builder canaryRuns(Consumer<CanaryRun.Builder>... canaryRuns);

        /**
         * <p>
         * A token that indicates that there is more data available. You can use this token in a subsequent
         * <code>GetCanaryRuns</code> operation to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates that there is more data available. You can use this token in a subsequent
         *        <code>GetCanaryRuns</code> operation to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SyntheticsResponse.BuilderImpl implements Builder {
        private List<CanaryRun> canaryRuns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCanaryRunsResponse model) {
            super(model);
            canaryRuns(model.canaryRuns);
            nextToken(model.nextToken);
        }

        public final Collection<CanaryRun.Builder> getCanaryRuns() {
            if (canaryRuns instanceof SdkAutoConstructList) {
                return null;
            }
            return canaryRuns != null ? canaryRuns.stream().map(CanaryRun::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder canaryRuns(Collection<CanaryRun> canaryRuns) {
            this.canaryRuns = CanaryRunsCopier.copy(canaryRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder canaryRuns(CanaryRun... canaryRuns) {
            canaryRuns(Arrays.asList(canaryRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder canaryRuns(Consumer<CanaryRun.Builder>... canaryRuns) {
            canaryRuns(Stream.of(canaryRuns).map(c -> CanaryRun.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCanaryRuns(Collection<CanaryRun.BuilderImpl> canaryRuns) {
            this.canaryRuns = CanaryRunsCopier.copyFromBuilder(canaryRuns);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetCanaryRunsResponse build() {
            return new GetCanaryRunsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
