/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains information about when the canary was created and modified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanaryTimeline implements SdkPojo, Serializable, ToCopyableBuilder<CanaryTimeline.Builder, CanaryTimeline> {
    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Created").getter(getter(CanaryTimeline::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModified").getter(getter(CanaryTimeline::lastModified)).setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()).build();

    private static final SdkField<Instant> LAST_STARTED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastStarted").getter(getter(CanaryTimeline::lastStarted)).setter(setter(Builder::lastStarted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastStarted").build()).build();

    private static final SdkField<Instant> LAST_STOPPED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastStopped").getter(getter(CanaryTimeline::lastStopped)).setter(setter(Builder::lastStopped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastStopped").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_FIELD,
            LAST_MODIFIED_FIELD, LAST_STARTED_FIELD, LAST_STOPPED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant created;

    private final Instant lastModified;

    private final Instant lastStarted;

    private final Instant lastStopped;

    private CanaryTimeline(BuilderImpl builder) {
        this.created = builder.created;
        this.lastModified = builder.lastModified;
        this.lastStarted = builder.lastStarted;
        this.lastStopped = builder.lastStopped;
    }

    /**
     * <p>
     * The date and time the canary was created.
     * </p>
     * 
     * @return The date and time the canary was created.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * The date and time the canary was most recently modified.
     * </p>
     * 
     * @return The date and time the canary was most recently modified.
     */
    public final Instant lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * The date and time that the canary's most recent run started.
     * </p>
     * 
     * @return The date and time that the canary's most recent run started.
     */
    public final Instant lastStarted() {
        return lastStarted;
    }

    /**
     * <p>
     * The date and time that the canary's most recent run ended.
     * </p>
     * 
     * @return The date and time that the canary's most recent run ended.
     */
    public final Instant lastStopped() {
        return lastStopped;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(lastStarted());
        hashCode = 31 * hashCode + Objects.hashCode(lastStopped());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryTimeline)) {
            return false;
        }
        CanaryTimeline other = (CanaryTimeline) obj;
        return Objects.equals(created(), other.created()) && Objects.equals(lastModified(), other.lastModified())
                && Objects.equals(lastStarted(), other.lastStarted()) && Objects.equals(lastStopped(), other.lastStopped());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CanaryTimeline").add("Created", created()).add("LastModified", lastModified())
                .add("LastStarted", lastStarted()).add("LastStopped", lastStopped()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Created":
            return Optional.ofNullable(clazz.cast(created()));
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "LastStarted":
            return Optional.ofNullable(clazz.cast(lastStarted()));
        case "LastStopped":
            return Optional.ofNullable(clazz.cast(lastStopped()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CanaryTimeline, T> g) {
        return obj -> g.apply((CanaryTimeline) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanaryTimeline> {
        /**
         * <p>
         * The date and time the canary was created.
         * </p>
         * 
         * @param created
         *        The date and time the canary was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The date and time the canary was most recently modified.
         * </p>
         * 
         * @param lastModified
         *        The date and time the canary was most recently modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * <p>
         * The date and time that the canary's most recent run started.
         * </p>
         * 
         * @param lastStarted
         *        The date and time that the canary's most recent run started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStarted(Instant lastStarted);

        /**
         * <p>
         * The date and time that the canary's most recent run ended.
         * </p>
         * 
         * @param lastStopped
         *        The date and time that the canary's most recent run ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStopped(Instant lastStopped);
    }

    static final class BuilderImpl implements Builder {
        private Instant created;

        private Instant lastModified;

        private Instant lastStarted;

        private Instant lastStopped;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryTimeline model) {
            created(model.created);
            lastModified(model.lastModified);
            lastStarted(model.lastStarted);
            lastStopped(model.lastStopped);
        }

        public final Instant getCreated() {
            return created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final Instant getLastStarted() {
            return lastStarted;
        }

        @Override
        public final Builder lastStarted(Instant lastStarted) {
            this.lastStarted = lastStarted;
            return this;
        }

        public final void setLastStarted(Instant lastStarted) {
            this.lastStarted = lastStarted;
        }

        public final Instant getLastStopped() {
            return lastStopped;
        }

        @Override
        public final Builder lastStopped(Instant lastStopped) {
            this.lastStopped = lastStopped;
            return this;
        }

        public final void setLastStopped(Instant lastStopped) {
            this.lastStopped = lastStopped;
        }

        @Override
        public CanaryTimeline build() {
            return new CanaryTimeline(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
