/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains all information about one canary in your account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Canary implements SdkPojo, Serializable, ToCopyableBuilder<Canary.Builder, Canary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Canary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Canary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<CanaryCodeOutput> CODE_FIELD = SdkField.<CanaryCodeOutput> builder(MarshallingType.SDK_POJO)
            .memberName("Code").getter(getter(Canary::code)).setter(setter(Builder::code)).constructor(CanaryCodeOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(Canary::executionRoleArn)).setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<CanaryScheduleOutput> SCHEDULE_FIELD = SdkField
            .<CanaryScheduleOutput> builder(MarshallingType.SDK_POJO).memberName("Schedule").getter(getter(Canary::schedule))
            .setter(setter(Builder::schedule)).constructor(CanaryScheduleOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<CanaryRunConfigOutput> RUN_CONFIG_FIELD = SdkField
            .<CanaryRunConfigOutput> builder(MarshallingType.SDK_POJO).memberName("RunConfig").getter(getter(Canary::runConfig))
            .setter(setter(Builder::runConfig)).constructor(CanaryRunConfigOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunConfig").build()).build();

    private static final SdkField<Integer> SUCCESS_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SuccessRetentionPeriodInDays")
            .getter(getter(Canary::successRetentionPeriodInDays))
            .setter(setter(Builder::successRetentionPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessRetentionPeriodInDays")
                    .build()).build();

    private static final SdkField<Integer> FAILURE_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("FailureRetentionPeriodInDays")
            .getter(getter(Canary::failureRetentionPeriodInDays))
            .setter(setter(Builder::failureRetentionPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureRetentionPeriodInDays")
                    .build()).build();

    private static final SdkField<CanaryStatus> STATUS_FIELD = SdkField.<CanaryStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status").getter(getter(Canary::status)).setter(setter(Builder::status))
            .constructor(CanaryStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<CanaryTimeline> TIMELINE_FIELD = SdkField.<CanaryTimeline> builder(MarshallingType.SDK_POJO)
            .memberName("Timeline").getter(getter(Canary::timeline)).setter(setter(Builder::timeline))
            .constructor(CanaryTimeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeline").build()).build();

    private static final SdkField<String> ARTIFACT_S3_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactS3Location").getter(getter(Canary::artifactS3Location))
            .setter(setter(Builder::artifactS3Location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactS3Location").build())
            .build();

    private static final SdkField<String> ENGINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineArn").getter(getter(Canary::engineArn)).setter(setter(Builder::engineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineArn").build()).build();

    private static final SdkField<String> RUNTIME_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuntimeVersion").getter(getter(Canary::runtimeVersion)).setter(setter(Builder::runtimeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeVersion").build()).build();

    private static final SdkField<VpcConfigOutput> VPC_CONFIG_FIELD = SdkField
            .<VpcConfigOutput> builder(MarshallingType.SDK_POJO).memberName("VpcConfig").getter(getter(Canary::vpcConfig))
            .setter(setter(Builder::vpcConfig)).constructor(VpcConfigOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<VisualReferenceOutput> VISUAL_REFERENCE_FIELD = SdkField
            .<VisualReferenceOutput> builder(MarshallingType.SDK_POJO).memberName("VisualReference")
            .getter(getter(Canary::visualReference)).setter(setter(Builder::visualReference))
            .constructor(VisualReferenceOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualReference").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(Canary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ArtifactConfigOutput> ARTIFACT_CONFIG_FIELD = SdkField
            .<ArtifactConfigOutput> builder(MarshallingType.SDK_POJO).memberName("ArtifactConfig")
            .getter(getter(Canary::artifactConfig)).setter(setter(Builder::artifactConfig))
            .constructor(ArtifactConfigOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            CODE_FIELD, EXECUTION_ROLE_ARN_FIELD, SCHEDULE_FIELD, RUN_CONFIG_FIELD, SUCCESS_RETENTION_PERIOD_IN_DAYS_FIELD,
            FAILURE_RETENTION_PERIOD_IN_DAYS_FIELD, STATUS_FIELD, TIMELINE_FIELD, ARTIFACT_S3_LOCATION_FIELD, ENGINE_ARN_FIELD,
            RUNTIME_VERSION_FIELD, VPC_CONFIG_FIELD, VISUAL_REFERENCE_FIELD, TAGS_FIELD, ARTIFACT_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final CanaryCodeOutput code;

    private final String executionRoleArn;

    private final CanaryScheduleOutput schedule;

    private final CanaryRunConfigOutput runConfig;

    private final Integer successRetentionPeriodInDays;

    private final Integer failureRetentionPeriodInDays;

    private final CanaryStatus status;

    private final CanaryTimeline timeline;

    private final String artifactS3Location;

    private final String engineArn;

    private final String runtimeVersion;

    private final VpcConfigOutput vpcConfig;

    private final VisualReferenceOutput visualReference;

    private final Map<String, String> tags;

    private final ArtifactConfigOutput artifactConfig;

    private Canary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.code = builder.code;
        this.executionRoleArn = builder.executionRoleArn;
        this.schedule = builder.schedule;
        this.runConfig = builder.runConfig;
        this.successRetentionPeriodInDays = builder.successRetentionPeriodInDays;
        this.failureRetentionPeriodInDays = builder.failureRetentionPeriodInDays;
        this.status = builder.status;
        this.timeline = builder.timeline;
        this.artifactS3Location = builder.artifactS3Location;
        this.engineArn = builder.engineArn;
        this.runtimeVersion = builder.runtimeVersion;
        this.vpcConfig = builder.vpcConfig;
        this.visualReference = builder.visualReference;
        this.tags = builder.tags;
        this.artifactConfig = builder.artifactConfig;
    }

    /**
     * <p>
     * The unique ID of this canary.
     * </p>
     * 
     * @return The unique ID of this canary.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the canary.
     * </p>
     * 
     * @return The name of the canary.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the Code property for this object.
     * 
     * @return The value of the Code property for this object.
     */
    public final CanaryCodeOutput code() {
        return code;
    }

    /**
     * <p>
     * The ARN of the IAM role used to run the canary. This role must include <code>lambda.amazonaws.com</code> as a
     * principal in the trust policy.
     * </p>
     * 
     * @return The ARN of the IAM role used to run the canary. This role must include <code>lambda.amazonaws.com</code>
     *         as a principal in the trust policy.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * A structure that contains information about how often the canary is to run, and when these runs are to stop.
     * </p>
     * 
     * @return A structure that contains information about how often the canary is to run, and when these runs are to
     *         stop.
     */
    public final CanaryScheduleOutput schedule() {
        return schedule;
    }

    /**
     * Returns the value of the RunConfig property for this object.
     * 
     * @return The value of the RunConfig property for this object.
     */
    public final CanaryRunConfigOutput runConfig() {
        return runConfig;
    }

    /**
     * <p>
     * The number of days to retain data about successful runs of this canary.
     * </p>
     * 
     * @return The number of days to retain data about successful runs of this canary.
     */
    public final Integer successRetentionPeriodInDays() {
        return successRetentionPeriodInDays;
    }

    /**
     * <p>
     * The number of days to retain data about failed runs of this canary.
     * </p>
     * 
     * @return The number of days to retain data about failed runs of this canary.
     */
    public final Integer failureRetentionPeriodInDays() {
        return failureRetentionPeriodInDays;
    }

    /**
     * <p>
     * A structure that contains information about the canary's status.
     * </p>
     * 
     * @return A structure that contains information about the canary's status.
     */
    public final CanaryStatus status() {
        return status;
    }

    /**
     * <p>
     * A structure that contains information about when the canary was created, modified, and most recently run.
     * </p>
     * 
     * @return A structure that contains information about when the canary was created, modified, and most recently run.
     */
    public final CanaryTimeline timeline() {
        return timeline;
    }

    /**
     * <p>
     * The location in Amazon S3 where Synthetics stores artifacts from the runs of this canary. Artifacts include the
     * log file, screenshots, and HAR files.
     * </p>
     * 
     * @return The location in Amazon S3 where Synthetics stores artifacts from the runs of this canary. Artifacts
     *         include the log file, screenshots, and HAR files.
     */
    public final String artifactS3Location() {
        return artifactS3Location;
    }

    /**
     * <p>
     * The ARN of the Lambda function that is used as your canary's engine. For more information about Lambda ARN
     * format, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html">Resources and
     * Conditions for Lambda Actions</a>.
     * </p>
     * 
     * @return The ARN of the Lambda function that is used as your canary's engine. For more information about Lambda
     *         ARN format, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html">Resources and
     *         Conditions for Lambda Actions</a>.
     */
    public final String engineArn() {
        return engineArn;
    }

    /**
     * <p>
     * Specifies the runtime version to use for the canary. For more information about runtime versions, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
     * Canary Runtime Versions</a>.
     * </p>
     * 
     * @return Specifies the runtime version to use for the canary. For more information about runtime versions, see <a
     *         href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html"
     *         > Canary Runtime Versions</a>.
     */
    public final String runtimeVersion() {
        return runtimeVersion;
    }

    /**
     * Returns the value of the VpcConfig property for this object.
     * 
     * @return The value of the VpcConfig property for this object.
     */
    public final VpcConfigOutput vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the canary
     * run to use as the baseline for screenshots, and the coordinates of any parts of the screen to ignore during the
     * visual monitoring comparison.
     * </p>
     * 
     * @return If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the
     *         canary run to use as the baseline for screenshots, and the coordinates of any parts of the screen to
     *         ignore during the visual monitoring comparison.
     */
    public final VisualReferenceOutput visualReference() {
        return visualReference;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of key-value pairs that are associated with the canary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of key-value pairs that are associated with the canary.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for
     * artifacts that the canary uploads to Amazon S3.
     * </p>
     * 
     * @return A structure that contains the configuration for canary artifacts, including the encryption-at-rest
     *         settings for artifacts that the canary uploads to Amazon S3.
     */
    public final ArtifactConfigOutput artifactConfig() {
        return artifactConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(runConfig());
        hashCode = 31 * hashCode + Objects.hashCode(successRetentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(failureRetentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(timeline());
        hashCode = 31 * hashCode + Objects.hashCode(artifactS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(engineArn());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(visualReference());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(artifactConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Canary)) {
            return false;
        }
        Canary other = (Canary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && Objects.equals(code(), other.code())
                && Objects.equals(executionRoleArn(), other.executionRoleArn()) && Objects.equals(schedule(), other.schedule())
                && Objects.equals(runConfig(), other.runConfig())
                && Objects.equals(successRetentionPeriodInDays(), other.successRetentionPeriodInDays())
                && Objects.equals(failureRetentionPeriodInDays(), other.failureRetentionPeriodInDays())
                && Objects.equals(status(), other.status()) && Objects.equals(timeline(), other.timeline())
                && Objects.equals(artifactS3Location(), other.artifactS3Location())
                && Objects.equals(engineArn(), other.engineArn()) && Objects.equals(runtimeVersion(), other.runtimeVersion())
                && Objects.equals(vpcConfig(), other.vpcConfig()) && Objects.equals(visualReference(), other.visualReference())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(artifactConfig(), other.artifactConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Canary").add("Id", id()).add("Name", name()).add("Code", code())
                .add("ExecutionRoleArn", executionRoleArn()).add("Schedule", schedule()).add("RunConfig", runConfig())
                .add("SuccessRetentionPeriodInDays", successRetentionPeriodInDays())
                .add("FailureRetentionPeriodInDays", failureRetentionPeriodInDays()).add("Status", status())
                .add("Timeline", timeline()).add("ArtifactS3Location", artifactS3Location()).add("EngineArn", engineArn())
                .add("RuntimeVersion", runtimeVersion()).add("VpcConfig", vpcConfig()).add("VisualReference", visualReference())
                .add("Tags", hasTags() ? tags() : null).add("ArtifactConfig", artifactConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "RunConfig":
            return Optional.ofNullable(clazz.cast(runConfig()));
        case "SuccessRetentionPeriodInDays":
            return Optional.ofNullable(clazz.cast(successRetentionPeriodInDays()));
        case "FailureRetentionPeriodInDays":
            return Optional.ofNullable(clazz.cast(failureRetentionPeriodInDays()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Timeline":
            return Optional.ofNullable(clazz.cast(timeline()));
        case "ArtifactS3Location":
            return Optional.ofNullable(clazz.cast(artifactS3Location()));
        case "EngineArn":
            return Optional.ofNullable(clazz.cast(engineArn()));
        case "RuntimeVersion":
            return Optional.ofNullable(clazz.cast(runtimeVersion()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "VisualReference":
            return Optional.ofNullable(clazz.cast(visualReference()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ArtifactConfig":
            return Optional.ofNullable(clazz.cast(artifactConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Canary, T> g) {
        return obj -> g.apply((Canary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Canary> {
        /**
         * <p>
         * The unique ID of this canary.
         * </p>
         * 
         * @param id
         *        The unique ID of this canary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the canary.
         * </p>
         * 
         * @param name
         *        The name of the canary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Code property for this object.
         *
         * @param code
         *        The new value for the Code property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(CanaryCodeOutput code);

        /**
         * Sets the value of the Code property for this object.
         *
         * This is a convenience that creates an instance of the {@link CanaryCodeOutput.Builder} avoiding the need to
         * create one manually via {@link CanaryCodeOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link CanaryCodeOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #code(CanaryCodeOutput)}.
         * 
         * @param code
         *        a consumer that will call methods on {@link CanaryCodeOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #code(CanaryCodeOutput)
         */
        default Builder code(Consumer<CanaryCodeOutput.Builder> code) {
            return code(CanaryCodeOutput.builder().applyMutation(code).build());
        }

        /**
         * <p>
         * The ARN of the IAM role used to run the canary. This role must include <code>lambda.amazonaws.com</code> as a
         * principal in the trust policy.
         * </p>
         * 
         * @param executionRoleArn
         *        The ARN of the IAM role used to run the canary. This role must include
         *        <code>lambda.amazonaws.com</code> as a principal in the trust policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * A structure that contains information about how often the canary is to run, and when these runs are to stop.
         * </p>
         * 
         * @param schedule
         *        A structure that contains information about how often the canary is to run, and when these runs are to
         *        stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(CanaryScheduleOutput schedule);

        /**
         * <p>
         * A structure that contains information about how often the canary is to run, and when these runs are to stop.
         * </p>
         * This is a convenience that creates an instance of the {@link CanaryScheduleOutput.Builder} avoiding the need
         * to create one manually via {@link CanaryScheduleOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link CanaryScheduleOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #schedule(CanaryScheduleOutput)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link CanaryScheduleOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(CanaryScheduleOutput)
         */
        default Builder schedule(Consumer<CanaryScheduleOutput.Builder> schedule) {
            return schedule(CanaryScheduleOutput.builder().applyMutation(schedule).build());
        }

        /**
         * Sets the value of the RunConfig property for this object.
         *
         * @param runConfig
         *        The new value for the RunConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runConfig(CanaryRunConfigOutput runConfig);

        /**
         * Sets the value of the RunConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link CanaryRunConfigOutput.Builder} avoiding the need
         * to create one manually via {@link CanaryRunConfigOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link CanaryRunConfigOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #runConfig(CanaryRunConfigOutput)}.
         * 
         * @param runConfig
         *        a consumer that will call methods on {@link CanaryRunConfigOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runConfig(CanaryRunConfigOutput)
         */
        default Builder runConfig(Consumer<CanaryRunConfigOutput.Builder> runConfig) {
            return runConfig(CanaryRunConfigOutput.builder().applyMutation(runConfig).build());
        }

        /**
         * <p>
         * The number of days to retain data about successful runs of this canary.
         * </p>
         * 
         * @param successRetentionPeriodInDays
         *        The number of days to retain data about successful runs of this canary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successRetentionPeriodInDays(Integer successRetentionPeriodInDays);

        /**
         * <p>
         * The number of days to retain data about failed runs of this canary.
         * </p>
         * 
         * @param failureRetentionPeriodInDays
         *        The number of days to retain data about failed runs of this canary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureRetentionPeriodInDays(Integer failureRetentionPeriodInDays);

        /**
         * <p>
         * A structure that contains information about the canary's status.
         * </p>
         * 
         * @param status
         *        A structure that contains information about the canary's status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(CanaryStatus status);

        /**
         * <p>
         * A structure that contains information about the canary's status.
         * </p>
         * This is a convenience that creates an instance of the {@link CanaryStatus.Builder} avoiding the need to
         * create one manually via {@link CanaryStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link CanaryStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(CanaryStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link CanaryStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(CanaryStatus)
         */
        default Builder status(Consumer<CanaryStatus.Builder> status) {
            return status(CanaryStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * A structure that contains information about when the canary was created, modified, and most recently run.
         * </p>
         * 
         * @param timeline
         *        A structure that contains information about when the canary was created, modified, and most recently
         *        run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeline(CanaryTimeline timeline);

        /**
         * <p>
         * A structure that contains information about when the canary was created, modified, and most recently run.
         * </p>
         * This is a convenience that creates an instance of the {@link CanaryTimeline.Builder} avoiding the need to
         * create one manually via {@link CanaryTimeline#builder()}.
         *
         * When the {@link Consumer} completes, {@link CanaryTimeline.Builder#build()} is called immediately and its
         * result is passed to {@link #timeline(CanaryTimeline)}.
         * 
         * @param timeline
         *        a consumer that will call methods on {@link CanaryTimeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeline(CanaryTimeline)
         */
        default Builder timeline(Consumer<CanaryTimeline.Builder> timeline) {
            return timeline(CanaryTimeline.builder().applyMutation(timeline).build());
        }

        /**
         * <p>
         * The location in Amazon S3 where Synthetics stores artifacts from the runs of this canary. Artifacts include
         * the log file, screenshots, and HAR files.
         * </p>
         * 
         * @param artifactS3Location
         *        The location in Amazon S3 where Synthetics stores artifacts from the runs of this canary. Artifacts
         *        include the log file, screenshots, and HAR files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactS3Location(String artifactS3Location);

        /**
         * <p>
         * The ARN of the Lambda function that is used as your canary's engine. For more information about Lambda ARN
         * format, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html">Resources
         * and Conditions for Lambda Actions</a>.
         * </p>
         * 
         * @param engineArn
         *        The ARN of the Lambda function that is used as your canary's engine. For more information about Lambda
         *        ARN format, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html">Resources and
         *        Conditions for Lambda Actions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineArn(String engineArn);

        /**
         * <p>
         * Specifies the runtime version to use for the canary. For more information about runtime versions, see <a
         * href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
         * Canary Runtime Versions</a>.
         * </p>
         * 
         * @param runtimeVersion
         *        Specifies the runtime version to use for the canary. For more information about runtime versions, see
         *        <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html"
         *        > Canary Runtime Versions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeVersion(String runtimeVersion);

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * @param vpcConfig
         *        The new value for the VpcConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfigOutput vpcConfig);

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link VpcConfigOutput.Builder} avoiding the need to
         * create one manually via {@link VpcConfigOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfigOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfig(VpcConfigOutput)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfigOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfigOutput)
         */
        default Builder vpcConfig(Consumer<VpcConfigOutput.Builder> vpcConfig) {
            return vpcConfig(VpcConfigOutput.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the
         * canary run to use as the baseline for screenshots, and the coordinates of any parts of the screen to ignore
         * during the visual monitoring comparison.
         * </p>
         * 
         * @param visualReference
         *        If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of
         *        the canary run to use as the baseline for screenshots, and the coordinates of any parts of the screen
         *        to ignore during the visual monitoring comparison.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualReference(VisualReferenceOutput visualReference);

        /**
         * <p>
         * If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the
         * canary run to use as the baseline for screenshots, and the coordinates of any parts of the screen to ignore
         * during the visual monitoring comparison.
         * </p>
         * This is a convenience that creates an instance of the {@link VisualReferenceOutput.Builder} avoiding the need
         * to create one manually via {@link VisualReferenceOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link VisualReferenceOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #visualReference(VisualReferenceOutput)}.
         * 
         * @param visualReference
         *        a consumer that will call methods on {@link VisualReferenceOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualReference(VisualReferenceOutput)
         */
        default Builder visualReference(Consumer<VisualReferenceOutput.Builder> visualReference) {
            return visualReference(VisualReferenceOutput.builder().applyMutation(visualReference).build());
        }

        /**
         * <p>
         * The list of key-value pairs that are associated with the canary.
         * </p>
         * 
         * @param tags
         *        The list of key-value pairs that are associated with the canary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings
         * for artifacts that the canary uploads to Amazon S3.
         * </p>
         * 
         * @param artifactConfig
         *        A structure that contains the configuration for canary artifacts, including the encryption-at-rest
         *        settings for artifacts that the canary uploads to Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactConfig(ArtifactConfigOutput artifactConfig);

        /**
         * <p>
         * A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings
         * for artifacts that the canary uploads to Amazon S3.
         * </p>
         * This is a convenience that creates an instance of the {@link ArtifactConfigOutput.Builder} avoiding the need
         * to create one manually via {@link ArtifactConfigOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link ArtifactConfigOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #artifactConfig(ArtifactConfigOutput)}.
         * 
         * @param artifactConfig
         *        a consumer that will call methods on {@link ArtifactConfigOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #artifactConfig(ArtifactConfigOutput)
         */
        default Builder artifactConfig(Consumer<ArtifactConfigOutput.Builder> artifactConfig) {
            return artifactConfig(ArtifactConfigOutput.builder().applyMutation(artifactConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private CanaryCodeOutput code;

        private String executionRoleArn;

        private CanaryScheduleOutput schedule;

        private CanaryRunConfigOutput runConfig;

        private Integer successRetentionPeriodInDays;

        private Integer failureRetentionPeriodInDays;

        private CanaryStatus status;

        private CanaryTimeline timeline;

        private String artifactS3Location;

        private String engineArn;

        private String runtimeVersion;

        private VpcConfigOutput vpcConfig;

        private VisualReferenceOutput visualReference;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private ArtifactConfigOutput artifactConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Canary model) {
            id(model.id);
            name(model.name);
            code(model.code);
            executionRoleArn(model.executionRoleArn);
            schedule(model.schedule);
            runConfig(model.runConfig);
            successRetentionPeriodInDays(model.successRetentionPeriodInDays);
            failureRetentionPeriodInDays(model.failureRetentionPeriodInDays);
            status(model.status);
            timeline(model.timeline);
            artifactS3Location(model.artifactS3Location);
            engineArn(model.engineArn);
            runtimeVersion(model.runtimeVersion);
            vpcConfig(model.vpcConfig);
            visualReference(model.visualReference);
            tags(model.tags);
            artifactConfig(model.artifactConfig);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CanaryCodeOutput.Builder getCode() {
            return code != null ? code.toBuilder() : null;
        }

        public final void setCode(CanaryCodeOutput.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        @Override
        @Transient
        public final Builder code(CanaryCodeOutput code) {
            this.code = code;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        @Transient
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final CanaryScheduleOutput.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(CanaryScheduleOutput.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        @Transient
        public final Builder schedule(CanaryScheduleOutput schedule) {
            this.schedule = schedule;
            return this;
        }

        public final CanaryRunConfigOutput.Builder getRunConfig() {
            return runConfig != null ? runConfig.toBuilder() : null;
        }

        public final void setRunConfig(CanaryRunConfigOutput.BuilderImpl runConfig) {
            this.runConfig = runConfig != null ? runConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder runConfig(CanaryRunConfigOutput runConfig) {
            this.runConfig = runConfig;
            return this;
        }

        public final Integer getSuccessRetentionPeriodInDays() {
            return successRetentionPeriodInDays;
        }

        public final void setSuccessRetentionPeriodInDays(Integer successRetentionPeriodInDays) {
            this.successRetentionPeriodInDays = successRetentionPeriodInDays;
        }

        @Override
        @Transient
        public final Builder successRetentionPeriodInDays(Integer successRetentionPeriodInDays) {
            this.successRetentionPeriodInDays = successRetentionPeriodInDays;
            return this;
        }

        public final Integer getFailureRetentionPeriodInDays() {
            return failureRetentionPeriodInDays;
        }

        public final void setFailureRetentionPeriodInDays(Integer failureRetentionPeriodInDays) {
            this.failureRetentionPeriodInDays = failureRetentionPeriodInDays;
        }

        @Override
        @Transient
        public final Builder failureRetentionPeriodInDays(Integer failureRetentionPeriodInDays) {
            this.failureRetentionPeriodInDays = failureRetentionPeriodInDays;
            return this;
        }

        public final CanaryStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(CanaryStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        @Transient
        public final Builder status(CanaryStatus status) {
            this.status = status;
            return this;
        }

        public final CanaryTimeline.Builder getTimeline() {
            return timeline != null ? timeline.toBuilder() : null;
        }

        public final void setTimeline(CanaryTimeline.BuilderImpl timeline) {
            this.timeline = timeline != null ? timeline.build() : null;
        }

        @Override
        @Transient
        public final Builder timeline(CanaryTimeline timeline) {
            this.timeline = timeline;
            return this;
        }

        public final String getArtifactS3Location() {
            return artifactS3Location;
        }

        public final void setArtifactS3Location(String artifactS3Location) {
            this.artifactS3Location = artifactS3Location;
        }

        @Override
        @Transient
        public final Builder artifactS3Location(String artifactS3Location) {
            this.artifactS3Location = artifactS3Location;
            return this;
        }

        public final String getEngineArn() {
            return engineArn;
        }

        public final void setEngineArn(String engineArn) {
            this.engineArn = engineArn;
        }

        @Override
        @Transient
        public final Builder engineArn(String engineArn) {
            this.engineArn = engineArn;
            return this;
        }

        public final String getRuntimeVersion() {
            return runtimeVersion;
        }

        public final void setRuntimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
        }

        @Override
        @Transient
        public final Builder runtimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
            return this;
        }

        public final VpcConfigOutput.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfigOutput.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder vpcConfig(VpcConfigOutput vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final VisualReferenceOutput.Builder getVisualReference() {
            return visualReference != null ? visualReference.toBuilder() : null;
        }

        public final void setVisualReference(VisualReferenceOutput.BuilderImpl visualReference) {
            this.visualReference = visualReference != null ? visualReference.build() : null;
        }

        @Override
        @Transient
        public final Builder visualReference(VisualReferenceOutput visualReference) {
            this.visualReference = visualReference;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final ArtifactConfigOutput.Builder getArtifactConfig() {
            return artifactConfig != null ? artifactConfig.toBuilder() : null;
        }

        public final void setArtifactConfig(ArtifactConfigOutput.BuilderImpl artifactConfig) {
            this.artifactConfig = artifactConfig != null ? artifactConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder artifactConfig(ArtifactConfigOutput artifactConfig) {
            this.artifactConfig = artifactConfig;
            return this;
        }

        @Override
        public Canary build() {
            return new Canary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
