/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCanariesResponse extends SyntheticsResponse implements
        ToCopyableBuilder<DescribeCanariesResponse.Builder, DescribeCanariesResponse> {
    private static final SdkField<List<Canary>> CANARIES_FIELD = SdkField
            .<List<Canary>> builder(MarshallingType.LIST)
            .memberName("Canaries")
            .getter(getter(DescribeCanariesResponse::canaries))
            .setter(setter(Builder::canaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Canaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Canary> builder(MarshallingType.SDK_POJO)
                                            .constructor(Canary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeCanariesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Canary> canaries;

    private final String nextToken;

    private DescribeCanariesResponse(BuilderImpl builder) {
        super(builder);
        this.canaries = builder.canaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Canaries property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCanaries() {
        return canaries != null && !(canaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns an array. Each item in the array contains the full information about one canary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCanaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns an array. Each item in the array contains the full information about one canary.
     */
    public final List<Canary> canaries() {
        return canaries;
    }

    /**
     * <p>
     * A token that indicates that there is more data available. You can use this token in a subsequent
     * <code>DescribeCanaries</code> operation to retrieve the next set of results.
     * </p>
     * 
     * @return A token that indicates that there is more data available. You can use this token in a subsequent
     *         <code>DescribeCanaries</code> operation to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCanaries() ? canaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCanariesResponse)) {
            return false;
        }
        DescribeCanariesResponse other = (DescribeCanariesResponse) obj;
        return hasCanaries() == other.hasCanaries() && Objects.equals(canaries(), other.canaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCanariesResponse").add("Canaries", hasCanaries() ? canaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Canaries":
            return Optional.ofNullable(clazz.cast(canaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCanariesResponse, T> g) {
        return obj -> g.apply((DescribeCanariesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SyntheticsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCanariesResponse> {
        /**
         * <p>
         * Returns an array. Each item in the array contains the full information about one canary.
         * </p>
         * 
         * @param canaries
         *        Returns an array. Each item in the array contains the full information about one canary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canaries(Collection<Canary> canaries);

        /**
         * <p>
         * Returns an array. Each item in the array contains the full information about one canary.
         * </p>
         * 
         * @param canaries
         *        Returns an array. Each item in the array contains the full information about one canary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canaries(Canary... canaries);

        /**
         * <p>
         * Returns an array. Each item in the array contains the full information about one canary.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Canary>.Builder} avoiding the need to
         * create one manually via {@link List<Canary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Canary>.Builder#build()} is called immediately and its
         * result is passed to {@link #canaries(List<Canary>)}.
         * 
         * @param canaries
         *        a consumer that will call methods on {@link List<Canary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #canaries(List<Canary>)
         */
        Builder canaries(Consumer<Canary.Builder>... canaries);

        /**
         * <p>
         * A token that indicates that there is more data available. You can use this token in a subsequent
         * <code>DescribeCanaries</code> operation to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates that there is more data available. You can use this token in a subsequent
         *        <code>DescribeCanaries</code> operation to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SyntheticsResponse.BuilderImpl implements Builder {
        private List<Canary> canaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCanariesResponse model) {
            super(model);
            canaries(model.canaries);
            nextToken(model.nextToken);
        }

        public final List<Canary.Builder> getCanaries() {
            List<Canary.Builder> result = CanariesCopier.copyToBuilder(this.canaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCanaries(Collection<Canary.BuilderImpl> canaries) {
            this.canaries = CanariesCopier.copyFromBuilder(canaries);
        }

        @Override
        @Transient
        public final Builder canaries(Collection<Canary> canaries) {
            this.canaries = CanariesCopier.copy(canaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder canaries(Canary... canaries) {
            canaries(Arrays.asList(canaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder canaries(Consumer<Canary.Builder>... canaries) {
            canaries(Stream.of(canaries).map(c -> Canary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeCanariesResponse build() {
            return new DescribeCanariesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
