/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCanariesLastRunRequest extends SyntheticsRequest implements
        ToCopyableBuilder<DescribeCanariesLastRunRequest.Builder, DescribeCanariesLastRunRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeCanariesLastRunRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeCanariesLastRunRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<List<String>> NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Names")
            .getter(getter(DescribeCanariesLastRunRequest::names))
            .setter(setter(Builder::names))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, NAMES_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final List<String> names;

    private DescribeCanariesLastRunRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.names = builder.names;
    }

    /**
     * <p>
     * A token that indicates that there is more data available. You can use this token in a subsequent
     * <code>DescribeCanaries</code> operation to retrieve the next set of results.
     * </p>
     * 
     * @return A token that indicates that there is more data available. You can use this token in a subsequent
     *         <code>DescribeCanaries</code> operation to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specify this parameter to limit how many runs are returned each time you use the <code>DescribeLastRun</code>
     * operation. If you omit this parameter, the default of 100 is used.
     * </p>
     * 
     * @return Specify this parameter to limit how many runs are returned each time you use the
     *         <code>DescribeLastRun</code> operation. If you omit this parameter, the default of 100 is used.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Names property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNames() {
        return names != null && !(names instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Use this parameter to return only canaries that match the names that you specify here. You can specify as many as
     * five canary names.
     * </p>
     * <p>
     * If you specify this parameter, the operation is successful only if you have authorization to view all the
     * canaries that you specify in your request. If you do not have permission to view any of the canaries, the request
     * fails with a 403 response.
     * </p>
     * <p>
     * You are required to use the <code>Names</code> parameter if you are logged on to a user or role that has an IAM
     * policy that restricts which canaries that you are allowed to view. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Restricted.html">
     * Limiting a user to viewing specific canaries</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNames} method.
     * </p>
     * 
     * @return Use this parameter to return only canaries that match the names that you specify here. You can specify as
     *         many as five canary names.</p>
     *         <p>
     *         If you specify this parameter, the operation is successful only if you have authorization to view all the
     *         canaries that you specify in your request. If you do not have permission to view any of the canaries, the
     *         request fails with a 403 response.
     *         </p>
     *         <p>
     *         You are required to use the <code>Names</code> parameter if you are logged on to a user or role that has
     *         an IAM policy that restricts which canaries that you are allowed to view. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Restricted.html"
     *         > Limiting a user to viewing specific canaries</a>.
     */
    public final List<String> names() {
        return names;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasNames() ? names() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCanariesLastRunRequest)) {
            return false;
        }
        DescribeCanariesLastRunRequest other = (DescribeCanariesLastRunRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && hasNames() == other.hasNames() && Objects.equals(names(), other.names());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCanariesLastRunRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("Names", hasNames() ? names() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Names":
            return Optional.ofNullable(clazz.cast(names()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCanariesLastRunRequest, T> g) {
        return obj -> g.apply((DescribeCanariesLastRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SyntheticsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCanariesLastRunRequest> {
        /**
         * <p>
         * A token that indicates that there is more data available. You can use this token in a subsequent
         * <code>DescribeCanaries</code> operation to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates that there is more data available. You can use this token in a subsequent
         *        <code>DescribeCanaries</code> operation to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specify this parameter to limit how many runs are returned each time you use the <code>DescribeLastRun</code>
         * operation. If you omit this parameter, the default of 100 is used.
         * </p>
         * 
         * @param maxResults
         *        Specify this parameter to limit how many runs are returned each time you use the
         *        <code>DescribeLastRun</code> operation. If you omit this parameter, the default of 100 is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Use this parameter to return only canaries that match the names that you specify here. You can specify as
         * many as five canary names.
         * </p>
         * <p>
         * If you specify this parameter, the operation is successful only if you have authorization to view all the
         * canaries that you specify in your request. If you do not have permission to view any of the canaries, the
         * request fails with a 403 response.
         * </p>
         * <p>
         * You are required to use the <code>Names</code> parameter if you are logged on to a user or role that has an
         * IAM policy that restricts which canaries that you are allowed to view. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Restricted.html"
         * > Limiting a user to viewing specific canaries</a>.
         * </p>
         * 
         * @param names
         *        Use this parameter to return only canaries that match the names that you specify here. You can specify
         *        as many as five canary names.</p>
         *        <p>
         *        If you specify this parameter, the operation is successful only if you have authorization to view all
         *        the canaries that you specify in your request. If you do not have permission to view any of the
         *        canaries, the request fails with a 403 response.
         *        </p>
         *        <p>
         *        You are required to use the <code>Names</code> parameter if you are logged on to a user or role that
         *        has an IAM policy that restricts which canaries that you are allowed to view. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Restricted.html"
         *        > Limiting a user to viewing specific canaries</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(Collection<String> names);

        /**
         * <p>
         * Use this parameter to return only canaries that match the names that you specify here. You can specify as
         * many as five canary names.
         * </p>
         * <p>
         * If you specify this parameter, the operation is successful only if you have authorization to view all the
         * canaries that you specify in your request. If you do not have permission to view any of the canaries, the
         * request fails with a 403 response.
         * </p>
         * <p>
         * You are required to use the <code>Names</code> parameter if you are logged on to a user or role that has an
         * IAM policy that restricts which canaries that you are allowed to view. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Restricted.html"
         * > Limiting a user to viewing specific canaries</a>.
         * </p>
         * 
         * @param names
         *        Use this parameter to return only canaries that match the names that you specify here. You can specify
         *        as many as five canary names.</p>
         *        <p>
         *        If you specify this parameter, the operation is successful only if you have authorization to view all
         *        the canaries that you specify in your request. If you do not have permission to view any of the
         *        canaries, the request fails with a 403 response.
         *        </p>
         *        <p>
         *        You are required to use the <code>Names</code> parameter if you are logged on to a user or role that
         *        has an IAM policy that restricts which canaries that you are allowed to view. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Restricted.html"
         *        > Limiting a user to viewing specific canaries</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(String... names);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SyntheticsRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private List<String> names = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCanariesLastRunRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            names(model.names);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getNames() {
            if (names instanceof SdkAutoConstructList) {
                return null;
            }
            return names;
        }

        public final void setNames(Collection<String> names) {
            this.names = DescribeCanariesLastRunNameFilterCopier.copy(names);
        }

        @Override
        @Transient
        public final Builder names(Collection<String> names) {
            this.names = DescribeCanariesLastRunNameFilterCopier.copy(names);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder names(String... names) {
            names(Arrays.asList(names));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCanariesLastRunRequest build() {
            return new DescribeCanariesLastRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
