/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for
 * artifacts that the canary uploads to Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArtifactConfigInput implements SdkPojo, Serializable,
        ToCopyableBuilder<ArtifactConfigInput.Builder, ArtifactConfigInput> {
    private static final SdkField<S3EncryptionConfig> S3_ENCRYPTION_FIELD = SdkField
            .<S3EncryptionConfig> builder(MarshallingType.SDK_POJO).memberName("S3Encryption")
            .getter(getter(ArtifactConfigInput::s3Encryption)).setter(setter(Builder::s3Encryption))
            .constructor(S3EncryptionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Encryption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_ENCRYPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3EncryptionConfig s3Encryption;

    private ArtifactConfigInput(BuilderImpl builder) {
        this.s3Encryption = builder.s3Encryption;
    }

    /**
     * <p>
     * A structure that contains the configuration of the encryption-at-rest settings for artifacts that the canary
     * uploads to Amazon S3. Artifact encryption functionality is available only for canaries that use Synthetics
     * runtime version syn-nodejs-puppeteer-3.3 or later. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html"
     * >Encrypting canary artifacts</a>
     * </p>
     * 
     * @return A structure that contains the configuration of the encryption-at-rest settings for artifacts that the
     *         canary uploads to Amazon S3. Artifact encryption functionality is available only for canaries that use
     *         Synthetics runtime version syn-nodejs-puppeteer-3.3 or later. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html"
     *         >Encrypting canary artifacts</a>
     */
    public final S3EncryptionConfig s3Encryption() {
        return s3Encryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Encryption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactConfigInput)) {
            return false;
        }
        ArtifactConfigInput other = (ArtifactConfigInput) obj;
        return Objects.equals(s3Encryption(), other.s3Encryption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArtifactConfigInput").add("S3Encryption", s3Encryption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Encryption":
            return Optional.ofNullable(clazz.cast(s3Encryption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArtifactConfigInput, T> g) {
        return obj -> g.apply((ArtifactConfigInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArtifactConfigInput> {
        /**
         * <p>
         * A structure that contains the configuration of the encryption-at-rest settings for artifacts that the canary
         * uploads to Amazon S3. Artifact encryption functionality is available only for canaries that use Synthetics
         * runtime version syn-nodejs-puppeteer-3.3 or later. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html"
         * >Encrypting canary artifacts</a>
         * </p>
         * 
         * @param s3Encryption
         *        A structure that contains the configuration of the encryption-at-rest settings for artifacts that the
         *        canary uploads to Amazon S3. Artifact encryption functionality is available only for canaries that use
         *        Synthetics runtime version syn-nodejs-puppeteer-3.3 or later. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html"
         *        >Encrypting canary artifacts</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Encryption(S3EncryptionConfig s3Encryption);

        /**
         * <p>
         * A structure that contains the configuration of the encryption-at-rest settings for artifacts that the canary
         * uploads to Amazon S3. Artifact encryption functionality is available only for canaries that use Synthetics
         * runtime version syn-nodejs-puppeteer-3.3 or later. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html"
         * >Encrypting canary artifacts</a>
         * </p>
         * This is a convenience that creates an instance of the {@link S3EncryptionConfig.Builder} avoiding the need to
         * create one manually via {@link S3EncryptionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3EncryptionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Encryption(S3EncryptionConfig)}.
         * 
         * @param s3Encryption
         *        a consumer that will call methods on {@link S3EncryptionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Encryption(S3EncryptionConfig)
         */
        default Builder s3Encryption(Consumer<S3EncryptionConfig.Builder> s3Encryption) {
            return s3Encryption(S3EncryptionConfig.builder().applyMutation(s3Encryption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3EncryptionConfig s3Encryption;

        private BuilderImpl() {
        }

        private BuilderImpl(ArtifactConfigInput model) {
            s3Encryption(model.s3Encryption);
        }

        public final S3EncryptionConfig.Builder getS3Encryption() {
            return s3Encryption != null ? s3Encryption.toBuilder() : null;
        }

        public final void setS3Encryption(S3EncryptionConfig.BuilderImpl s3Encryption) {
            this.s3Encryption = s3Encryption != null ? s3Encryption.build() : null;
        }

        @Override
        @Transient
        public final Builder s3Encryption(S3EncryptionConfig s3Encryption) {
            this.s3Encryption = s3Encryption;
            return this;
        }

        @Override
        public ArtifactConfigInput build() {
            return new ArtifactConfigInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
