/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains information about the most recent run of a single canary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanaryLastRun implements SdkPojo, Serializable, ToCopyableBuilder<CanaryLastRun.Builder, CanaryLastRun> {
    private static final SdkField<String> CANARY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CanaryName").getter(getter(CanaryLastRun::canaryName)).setter(setter(Builder::canaryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanaryName").build()).build();

    private static final SdkField<CanaryRun> LAST_RUN_FIELD = SdkField.<CanaryRun> builder(MarshallingType.SDK_POJO)
            .memberName("LastRun").getter(getter(CanaryLastRun::lastRun)).setter(setter(Builder::lastRun))
            .constructor(CanaryRun::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANARY_NAME_FIELD,
            LAST_RUN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String canaryName;

    private final CanaryRun lastRun;

    private CanaryLastRun(BuilderImpl builder) {
        this.canaryName = builder.canaryName;
        this.lastRun = builder.lastRun;
    }

    /**
     * <p>
     * The name of the canary.
     * </p>
     * 
     * @return The name of the canary.
     */
    public final String canaryName() {
        return canaryName;
    }

    /**
     * <p>
     * The results from this canary's most recent run.
     * </p>
     * 
     * @return The results from this canary's most recent run.
     */
    public final CanaryRun lastRun() {
        return lastRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(canaryName());
        hashCode = 31 * hashCode + Objects.hashCode(lastRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryLastRun)) {
            return false;
        }
        CanaryLastRun other = (CanaryLastRun) obj;
        return Objects.equals(canaryName(), other.canaryName()) && Objects.equals(lastRun(), other.lastRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CanaryLastRun").add("CanaryName", canaryName()).add("LastRun", lastRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CanaryName":
            return Optional.ofNullable(clazz.cast(canaryName()));
        case "LastRun":
            return Optional.ofNullable(clazz.cast(lastRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CanaryLastRun, T> g) {
        return obj -> g.apply((CanaryLastRun) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanaryLastRun> {
        /**
         * <p>
         * The name of the canary.
         * </p>
         * 
         * @param canaryName
         *        The name of the canary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canaryName(String canaryName);

        /**
         * <p>
         * The results from this canary's most recent run.
         * </p>
         * 
         * @param lastRun
         *        The results from this canary's most recent run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRun(CanaryRun lastRun);

        /**
         * <p>
         * The results from this canary's most recent run.
         * </p>
         * This is a convenience method that creates an instance of the {@link CanaryRun.Builder} avoiding the need to
         * create one manually via {@link CanaryRun#builder()}.
         *
         * When the {@link Consumer} completes, {@link CanaryRun.Builder#build()} is called immediately and its result
         * is passed to {@link #lastRun(CanaryRun)}.
         * 
         * @param lastRun
         *        a consumer that will call methods on {@link CanaryRun.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastRun(CanaryRun)
         */
        default Builder lastRun(Consumer<CanaryRun.Builder> lastRun) {
            return lastRun(CanaryRun.builder().applyMutation(lastRun).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String canaryName;

        private CanaryRun lastRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryLastRun model) {
            canaryName(model.canaryName);
            lastRun(model.lastRun);
        }

        public final String getCanaryName() {
            return canaryName;
        }

        public final void setCanaryName(String canaryName) {
            this.canaryName = canaryName;
        }

        @Override
        @Transient
        public final Builder canaryName(String canaryName) {
            this.canaryName = canaryName;
            return this;
        }

        public final CanaryRun.Builder getLastRun() {
            return lastRun != null ? lastRun.toBuilder() : null;
        }

        public final void setLastRun(CanaryRun.BuilderImpl lastRun) {
            this.lastRun = lastRun != null ? lastRun.build() : null;
        }

        @Override
        @Transient
        public final Builder lastRun(CanaryRun lastRun) {
            this.lastRun = lastRun;
            return this;
        }

        @Override
        public CanaryLastRun build() {
            return new CanaryLastRun(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
