/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains the details about one run of one canary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanaryRun implements SdkPojo, Serializable, ToCopyableBuilder<CanaryRun.Builder, CanaryRun> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(CanaryRun::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CanaryRun::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<CanaryRunStatus> STATUS_FIELD = SdkField.<CanaryRunStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status").getter(getter(CanaryRun::status)).setter(setter(Builder::status))
            .constructor(CanaryRunStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<CanaryRunTimeline> TIMELINE_FIELD = SdkField
            .<CanaryRunTimeline> builder(MarshallingType.SDK_POJO).memberName("Timeline").getter(getter(CanaryRun::timeline))
            .setter(setter(Builder::timeline)).constructor(CanaryRunTimeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeline").build()).build();

    private static final SdkField<String> ARTIFACT_S3_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactS3Location").getter(getter(CanaryRun::artifactS3Location))
            .setter(setter(Builder::artifactS3Location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactS3Location").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            STATUS_FIELD, TIMELINE_FIELD, ARTIFACT_S3_LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final CanaryRunStatus status;

    private final CanaryRunTimeline timeline;

    private final String artifactS3Location;

    private CanaryRun(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.timeline = builder.timeline;
        this.artifactS3Location = builder.artifactS3Location;
    }

    /**
     * <p>
     * A unique ID that identifies this canary run.
     * </p>
     * 
     * @return A unique ID that identifies this canary run.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the canary.
     * </p>
     * 
     * @return The name of the canary.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of this run.
     * </p>
     * 
     * @return The status of this run.
     */
    public final CanaryRunStatus status() {
        return status;
    }

    /**
     * <p>
     * A structure that contains the start and end times of this run.
     * </p>
     * 
     * @return A structure that contains the start and end times of this run.
     */
    public final CanaryRunTimeline timeline() {
        return timeline;
    }

    /**
     * <p>
     * The location where the canary stored artifacts from the run. Artifacts include the log file, screenshots, and HAR
     * files.
     * </p>
     * 
     * @return The location where the canary stored artifacts from the run. Artifacts include the log file, screenshots,
     *         and HAR files.
     */
    public final String artifactS3Location() {
        return artifactS3Location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(timeline());
        hashCode = 31 * hashCode + Objects.hashCode(artifactS3Location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryRun)) {
            return false;
        }
        CanaryRun other = (CanaryRun) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(status(), other.status()) && Objects.equals(timeline(), other.timeline())
                && Objects.equals(artifactS3Location(), other.artifactS3Location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CanaryRun").add("Id", id()).add("Name", name()).add("Status", status())
                .add("Timeline", timeline()).add("ArtifactS3Location", artifactS3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Timeline":
            return Optional.ofNullable(clazz.cast(timeline()));
        case "ArtifactS3Location":
            return Optional.ofNullable(clazz.cast(artifactS3Location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CanaryRun, T> g) {
        return obj -> g.apply((CanaryRun) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanaryRun> {
        /**
         * <p>
         * A unique ID that identifies this canary run.
         * </p>
         * 
         * @param id
         *        A unique ID that identifies this canary run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the canary.
         * </p>
         * 
         * @param name
         *        The name of the canary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of this run.
         * </p>
         * 
         * @param status
         *        The status of this run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(CanaryRunStatus status);

        /**
         * <p>
         * The status of this run.
         * </p>
         * This is a convenience method that creates an instance of the {@link CanaryRunStatus.Builder} avoiding the
         * need to create one manually via {@link CanaryRunStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link CanaryRunStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(CanaryRunStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link CanaryRunStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(CanaryRunStatus)
         */
        default Builder status(Consumer<CanaryRunStatus.Builder> status) {
            return status(CanaryRunStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * A structure that contains the start and end times of this run.
         * </p>
         * 
         * @param timeline
         *        A structure that contains the start and end times of this run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeline(CanaryRunTimeline timeline);

        /**
         * <p>
         * A structure that contains the start and end times of this run.
         * </p>
         * This is a convenience method that creates an instance of the {@link CanaryRunTimeline.Builder} avoiding the
         * need to create one manually via {@link CanaryRunTimeline#builder()}.
         *
         * When the {@link Consumer} completes, {@link CanaryRunTimeline.Builder#build()} is called immediately and its
         * result is passed to {@link #timeline(CanaryRunTimeline)}.
         * 
         * @param timeline
         *        a consumer that will call methods on {@link CanaryRunTimeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeline(CanaryRunTimeline)
         */
        default Builder timeline(Consumer<CanaryRunTimeline.Builder> timeline) {
            return timeline(CanaryRunTimeline.builder().applyMutation(timeline).build());
        }

        /**
         * <p>
         * The location where the canary stored artifacts from the run. Artifacts include the log file, screenshots, and
         * HAR files.
         * </p>
         * 
         * @param artifactS3Location
         *        The location where the canary stored artifacts from the run. Artifacts include the log file,
         *        screenshots, and HAR files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactS3Location(String artifactS3Location);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private CanaryRunStatus status;

        private CanaryRunTimeline timeline;

        private String artifactS3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryRun model) {
            id(model.id);
            name(model.name);
            status(model.status);
            timeline(model.timeline);
            artifactS3Location(model.artifactS3Location);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CanaryRunStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(CanaryRunStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        @Transient
        public final Builder status(CanaryRunStatus status) {
            this.status = status;
            return this;
        }

        public final CanaryRunTimeline.Builder getTimeline() {
            return timeline != null ? timeline.toBuilder() : null;
        }

        public final void setTimeline(CanaryRunTimeline.BuilderImpl timeline) {
            this.timeline = timeline != null ? timeline.build() : null;
        }

        @Override
        @Transient
        public final Builder timeline(CanaryRunTimeline timeline) {
            this.timeline = timeline;
            return this;
        }

        public final String getArtifactS3Location() {
            return artifactS3Location;
        }

        public final void setArtifactS3Location(String artifactS3Location) {
            this.artifactS3Location = artifactS3Location;
        }

        @Override
        @Transient
        public final Builder artifactS3Location(String artifactS3Location) {
            this.artifactS3Location = artifactS3Location;
            return this;
        }

        @Override
        public CanaryRun build() {
            return new CanaryRun(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
