/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCanaryResponse extends SyntheticsResponse implements
        ToCopyableBuilder<CreateCanaryResponse.Builder, CreateCanaryResponse> {
    private static final SdkField<Canary> CANARY_FIELD = SdkField.<Canary> builder(MarshallingType.SDK_POJO).memberName("Canary")
            .getter(getter(CreateCanaryResponse::canary)).setter(setter(Builder::canary)).constructor(Canary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Canary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANARY_FIELD));

    private final Canary canary;

    private CreateCanaryResponse(BuilderImpl builder) {
        super(builder);
        this.canary = builder.canary;
    }

    /**
     * <p>
     * The full details about the canary you have created.
     * </p>
     * 
     * @return The full details about the canary you have created.
     */
    public final Canary canary() {
        return canary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(canary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCanaryResponse)) {
            return false;
        }
        CreateCanaryResponse other = (CreateCanaryResponse) obj;
        return Objects.equals(canary(), other.canary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCanaryResponse").add("Canary", canary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Canary":
            return Optional.ofNullable(clazz.cast(canary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCanaryResponse, T> g) {
        return obj -> g.apply((CreateCanaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SyntheticsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateCanaryResponse> {
        /**
         * <p>
         * The full details about the canary you have created.
         * </p>
         * 
         * @param canary
         *        The full details about the canary you have created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canary(Canary canary);

        /**
         * <p>
         * The full details about the canary you have created.
         * </p>
         * This is a convenience method that creates an instance of the {@link Canary.Builder} avoiding the need to
         * create one manually via {@link Canary#builder()}.
         *
         * When the {@link Consumer} completes, {@link Canary.Builder#build()} is called immediately and its result is
         * passed to {@link #canary(Canary)}.
         * 
         * @param canary
         *        a consumer that will call methods on {@link Canary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #canary(Canary)
         */
        default Builder canary(Consumer<Canary.Builder> canary) {
            return canary(Canary.builder().applyMutation(canary).build());
        }
    }

    static final class BuilderImpl extends SyntheticsResponse.BuilderImpl implements Builder {
        private Canary canary;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCanaryResponse model) {
            super(model);
            canary(model.canary);
        }

        public final Canary.Builder getCanary() {
            return canary != null ? canary.toBuilder() : null;
        }

        public final void setCanary(Canary.BuilderImpl canary) {
            this.canary = canary != null ? canary.build() : null;
        }

        @Override
        @Transient
        public final Builder canary(Canary canary) {
            this.canary = canary;
            return this;
        }

        @Override
        public CreateCanaryResponse build() {
            return new CreateCanaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
