/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.synthetics.SyntheticsClient;
import software.amazon.awssdk.services.synthetics.model.ListAssociatedGroupsRequest;
import software.amazon.awssdk.services.synthetics.model.ListAssociatedGroupsResponse;

public class ListAssociatedGroupsIterable
implements SdkIterable<ListAssociatedGroupsResponse> {
    private final SyntheticsClient client;
    private final ListAssociatedGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssociatedGroupsIterable(SyntheticsClient client, ListAssociatedGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAssociatedGroupsResponseFetcher();
    }

    public Iterator<ListAssociatedGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAssociatedGroupsResponseFetcher
    implements SyncPageFetcher<ListAssociatedGroupsResponse> {
        private ListAssociatedGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssociatedGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssociatedGroupsResponse nextPage(ListAssociatedGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListAssociatedGroupsIterable.this.client.listAssociatedGroups(ListAssociatedGroupsIterable.this.firstRequest);
            }
            return ListAssociatedGroupsIterable.this.client.listAssociatedGroups((ListAssociatedGroupsRequest)((Object)ListAssociatedGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

