/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.synthetics.SyntheticsAsyncClient;
import software.amazon.awssdk.services.synthetics.model.ListAssociatedGroupsRequest;
import software.amazon.awssdk.services.synthetics.model.ListAssociatedGroupsResponse;

public class ListAssociatedGroupsPublisher
implements SdkPublisher<ListAssociatedGroupsResponse> {
    private final SyntheticsAsyncClient client;
    private final ListAssociatedGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssociatedGroupsPublisher(SyntheticsAsyncClient client, ListAssociatedGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssociatedGroupsPublisher(SyntheticsAsyncClient client, ListAssociatedGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssociatedGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssociatedGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAssociatedGroupsResponseFetcher
    implements AsyncPageFetcher<ListAssociatedGroupsResponse> {
        private ListAssociatedGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssociatedGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssociatedGroupsResponse> nextPage(ListAssociatedGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListAssociatedGroupsPublisher.this.client.listAssociatedGroups(ListAssociatedGroupsPublisher.this.firstRequest);
            }
            return ListAssociatedGroupsPublisher.this.client.listAssociatedGroups((ListAssociatedGroupsRequest)((Object)ListAssociatedGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

