/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.synthetics.SyntheticsClient;
import software.amazon.awssdk.services.synthetics.internal.UserAgentUtils;
import software.amazon.awssdk.services.synthetics.model.DescribeRuntimeVersionsRequest;
import software.amazon.awssdk.services.synthetics.model.DescribeRuntimeVersionsResponse;

public class DescribeRuntimeVersionsIterable
implements SdkIterable<DescribeRuntimeVersionsResponse> {
    private final SyntheticsClient client;
    private final DescribeRuntimeVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRuntimeVersionsIterable(SyntheticsClient client, DescribeRuntimeVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeRuntimeVersionsResponseFetcher();
    }

    public Iterator<DescribeRuntimeVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeRuntimeVersionsResponseFetcher
    implements SyncPageFetcher<DescribeRuntimeVersionsResponse> {
        private DescribeRuntimeVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRuntimeVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRuntimeVersionsResponse nextPage(DescribeRuntimeVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRuntimeVersionsIterable.this.client.describeRuntimeVersions(DescribeRuntimeVersionsIterable.this.firstRequest);
            }
            return DescribeRuntimeVersionsIterable.this.client.describeRuntimeVersions((DescribeRuntimeVersionsRequest)((Object)DescribeRuntimeVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

