/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.synthetics.DefaultSyntheticsAsyncClient;
import software.amazon.awssdk.services.synthetics.DefaultSyntheticsBaseClientBuilder;
import software.amazon.awssdk.services.synthetics.SyntheticsAsyncClient;
import software.amazon.awssdk.services.synthetics.SyntheticsAsyncClientBuilder;
import software.amazon.awssdk.services.synthetics.SyntheticsServiceClientConfiguration;
import software.amazon.awssdk.services.synthetics.endpoints.SyntheticsEndpointProvider;

@SdkInternalApi
final class DefaultSyntheticsAsyncClientBuilder
extends DefaultSyntheticsBaseClientBuilder<SyntheticsAsyncClientBuilder, SyntheticsAsyncClient>
implements SyntheticsAsyncClientBuilder {
    DefaultSyntheticsAsyncClientBuilder() {
    }

    @Override
    public DefaultSyntheticsAsyncClientBuilder endpointProvider(SyntheticsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SyntheticsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSyntheticsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        SyntheticsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSyntheticsAsyncClient client = new DefaultSyntheticsAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SyntheticsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SyntheticsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

