/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.synthetics.DefaultSyntheticsBaseClientBuilder;
import software.amazon.awssdk.services.synthetics.DefaultSyntheticsClient;
import software.amazon.awssdk.services.synthetics.SyntheticsClient;
import software.amazon.awssdk.services.synthetics.SyntheticsClientBuilder;
import software.amazon.awssdk.services.synthetics.SyntheticsServiceClientConfiguration;
import software.amazon.awssdk.services.synthetics.endpoints.SyntheticsEndpointProvider;

@SdkInternalApi
final class DefaultSyntheticsClientBuilder
extends DefaultSyntheticsBaseClientBuilder<SyntheticsClientBuilder, SyntheticsClient>
implements SyntheticsClientBuilder {
    DefaultSyntheticsClientBuilder() {
    }

    @Override
    public DefaultSyntheticsClientBuilder endpointProvider(SyntheticsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SyntheticsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSyntheticsClientBuilder.validateClientOptions(clientConfiguration);
        SyntheticsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSyntheticsClient client = new DefaultSyntheticsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SyntheticsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SyntheticsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

