/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains input information for a canary run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanaryRunConfigInput implements SdkPojo, Serializable,
        ToCopyableBuilder<CanaryRunConfigInput.Builder, CanaryRunConfigInput> {
    private static final SdkField<Integer> TIMEOUT_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimeoutInSeconds").getter(getter(CanaryRunConfigInput::timeoutInSeconds))
            .setter(setter(Builder::timeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutInSeconds").build()).build();

    private static final SdkField<Integer> MEMORY_IN_MB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MemoryInMB").getter(getter(CanaryRunConfigInput::memoryInMB)).setter(setter(Builder::memoryInMB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryInMB").build()).build();

    private static final SdkField<Boolean> ACTIVE_TRACING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ActiveTracing").getter(getter(CanaryRunConfigInput::activeTracing))
            .setter(setter(Builder::activeTracing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveTracing").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("EnvironmentVariables")
            .getter(getter(CanaryRunConfigInput::environmentVariables))
            .setter(setter(Builder::environmentVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_IN_SECONDS_FIELD,
            MEMORY_IN_MB_FIELD, ACTIVE_TRACING_FIELD, ENVIRONMENT_VARIABLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer timeoutInSeconds;

    private final Integer memoryInMB;

    private final Boolean activeTracing;

    private final Map<String, String> environmentVariables;

    private CanaryRunConfigInput(BuilderImpl builder) {
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.memoryInMB = builder.memoryInMB;
        this.activeTracing = builder.activeTracing;
        this.environmentVariables = builder.environmentVariables;
    }

    /**
     * <p>
     * How long the canary is allowed to run before it must stop. You can't set this time to be longer than the
     * frequency of the runs of this canary.
     * </p>
     * <p>
     * If you omit this field, the frequency of the canary is used as this value, up to a maximum of 14 minutes.
     * </p>
     * 
     * @return How long the canary is allowed to run before it must stop. You can't set this time to be longer than the
     *         frequency of the runs of this canary.</p>
     *         <p>
     *         If you omit this field, the frequency of the canary is used as this value, up to a maximum of 14 minutes.
     */
    public final Integer timeoutInSeconds() {
        return timeoutInSeconds;
    }

    /**
     * <p>
     * The maximum amount of memory available to the canary while it is running, in MB. This value must be a multiple of
     * 64.
     * </p>
     * 
     * @return The maximum amount of memory available to the canary while it is running, in MB. This value must be a
     *         multiple of 64.
     */
    public final Integer memoryInMB() {
        return memoryInMB;
    }

    /**
     * <p>
     * Specifies whether this canary is to use active X-Ray tracing when it runs. Active tracing enables this canary run
     * to be displayed in the ServiceLens and X-Ray service maps even if the canary does not hit an endpoint that has
     * X-Ray tracing enabled. Using X-Ray tracing incurs charges. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_tracing.html">
     * Canaries and X-Ray tracing</a>.
     * </p>
     * <p>
     * You can enable active tracing only for canaries that use version <code>syn-nodejs-2.0</code> or later for their
     * canary runtime.
     * </p>
     * 
     * @return Specifies whether this canary is to use active X-Ray tracing when it runs. Active tracing enables this
     *         canary run to be displayed in the ServiceLens and X-Ray service maps even if the canary does not hit an
     *         endpoint that has X-Ray tracing enabled. Using X-Ray tracing incurs charges. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_tracing.html"
     *         > Canaries and X-Ray tracing</a>.</p>
     *         <p>
     *         You can enable active tracing only for canaries that use version <code>syn-nodejs-2.0</code> or later for
     *         their canary runtime.
     */
    public final Boolean activeTracing() {
        return activeTracing;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentVariables property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironmentVariables() {
        return environmentVariables != null && !(environmentVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies the keys and values to use for any environment variables used in the canary script. Use the following
     * format:
     * </p>
     * <p>
     * { "key1" : "value1", "key2" : "value2", ...}
     * </p>
     * <p>
     * Keys must start with a letter and be at least two characters. The total size of your environment variables cannot
     * exceed 4 KB. You can't specify any Lambda reserved environment variables as the keys for your environment
     * variables. For more information about reserved keys, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime">
     * Runtime environment variables</a>.
     * </p>
     * <important>
     * <p>
     * The environment variables keys and values are not encrypted. Do not store sensitive information in this field.
     * </p>
     * </important>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentVariables} method.
     * </p>
     * 
     * @return Specifies the keys and values to use for any environment variables used in the canary script. Use the
     *         following format:</p>
     *         <p>
     *         { "key1" : "value1", "key2" : "value2", ...}
     *         </p>
     *         <p>
     *         Keys must start with a letter and be at least two characters. The total size of your environment
     *         variables cannot exceed 4 KB. You can't specify any Lambda reserved environment variables as the keys for
     *         your environment variables. For more information about reserved keys, see <a href=
     *         "https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime">
     *         Runtime environment variables</a>.
     *         </p>
     *         <important>
     *         <p>
     *         The environment variables keys and values are not encrypted. Do not store sensitive information in this
     *         field.
     *         </p>
     */
    public final Map<String, String> environmentVariables() {
        return environmentVariables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(memoryInMB());
        hashCode = 31 * hashCode + Objects.hashCode(activeTracing());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentVariables() ? environmentVariables() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryRunConfigInput)) {
            return false;
        }
        CanaryRunConfigInput other = (CanaryRunConfigInput) obj;
        return Objects.equals(timeoutInSeconds(), other.timeoutInSeconds()) && Objects.equals(memoryInMB(), other.memoryInMB())
                && Objects.equals(activeTracing(), other.activeTracing())
                && hasEnvironmentVariables() == other.hasEnvironmentVariables()
                && Objects.equals(environmentVariables(), other.environmentVariables());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CanaryRunConfigInput").add("TimeoutInSeconds", timeoutInSeconds())
                .add("MemoryInMB", memoryInMB()).add("ActiveTracing", activeTracing())
                .add("EnvironmentVariables", hasEnvironmentVariables() ? environmentVariables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(timeoutInSeconds()));
        case "MemoryInMB":
            return Optional.ofNullable(clazz.cast(memoryInMB()));
        case "ActiveTracing":
            return Optional.ofNullable(clazz.cast(activeTracing()));
        case "EnvironmentVariables":
            return Optional.ofNullable(clazz.cast(environmentVariables()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TimeoutInSeconds", TIMEOUT_IN_SECONDS_FIELD);
        map.put("MemoryInMB", MEMORY_IN_MB_FIELD);
        map.put("ActiveTracing", ACTIVE_TRACING_FIELD);
        map.put("EnvironmentVariables", ENVIRONMENT_VARIABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CanaryRunConfigInput, T> g) {
        return obj -> g.apply((CanaryRunConfigInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanaryRunConfigInput> {
        /**
         * <p>
         * How long the canary is allowed to run before it must stop. You can't set this time to be longer than the
         * frequency of the runs of this canary.
         * </p>
         * <p>
         * If you omit this field, the frequency of the canary is used as this value, up to a maximum of 14 minutes.
         * </p>
         * 
         * @param timeoutInSeconds
         *        How long the canary is allowed to run before it must stop. You can't set this time to be longer than
         *        the frequency of the runs of this canary.</p>
         *        <p>
         *        If you omit this field, the frequency of the canary is used as this value, up to a maximum of 14
         *        minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInSeconds(Integer timeoutInSeconds);

        /**
         * <p>
         * The maximum amount of memory available to the canary while it is running, in MB. This value must be a
         * multiple of 64.
         * </p>
         * 
         * @param memoryInMB
         *        The maximum amount of memory available to the canary while it is running, in MB. This value must be a
         *        multiple of 64.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryInMB(Integer memoryInMB);

        /**
         * <p>
         * Specifies whether this canary is to use active X-Ray tracing when it runs. Active tracing enables this canary
         * run to be displayed in the ServiceLens and X-Ray service maps even if the canary does not hit an endpoint
         * that has X-Ray tracing enabled. Using X-Ray tracing incurs charges. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_tracing.html">
         * Canaries and X-Ray tracing</a>.
         * </p>
         * <p>
         * You can enable active tracing only for canaries that use version <code>syn-nodejs-2.0</code> or later for
         * their canary runtime.
         * </p>
         * 
         * @param activeTracing
         *        Specifies whether this canary is to use active X-Ray tracing when it runs. Active tracing enables this
         *        canary run to be displayed in the ServiceLens and X-Ray service maps even if the canary does not hit
         *        an endpoint that has X-Ray tracing enabled. Using X-Ray tracing incurs charges. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_tracing.html"
         *        > Canaries and X-Ray tracing</a>.</p>
         *        <p>
         *        You can enable active tracing only for canaries that use version <code>syn-nodejs-2.0</code> or later
         *        for their canary runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeTracing(Boolean activeTracing);

        /**
         * <p>
         * Specifies the keys and values to use for any environment variables used in the canary script. Use the
         * following format:
         * </p>
         * <p>
         * { "key1" : "value1", "key2" : "value2", ...}
         * </p>
         * <p>
         * Keys must start with a letter and be at least two characters. The total size of your environment variables
         * cannot exceed 4 KB. You can't specify any Lambda reserved environment variables as the keys for your
         * environment variables. For more information about reserved keys, see <a href=
         * "https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime">
         * Runtime environment variables</a>.
         * </p>
         * <important>
         * <p>
         * The environment variables keys and values are not encrypted. Do not store sensitive information in this
         * field.
         * </p>
         * </important>
         * 
         * @param environmentVariables
         *        Specifies the keys and values to use for any environment variables used in the canary script. Use the
         *        following format:</p>
         *        <p>
         *        { "key1" : "value1", "key2" : "value2", ...}
         *        </p>
         *        <p>
         *        Keys must start with a letter and be at least two characters. The total size of your environment
         *        variables cannot exceed 4 KB. You can't specify any Lambda reserved environment variables as the keys
         *        for your environment variables. For more information about reserved keys, see <a href=
         *        "https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime"
         *        > Runtime environment variables</a>.
         *        </p>
         *        <important>
         *        <p>
         *        The environment variables keys and values are not encrypted. Do not store sensitive information in
         *        this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariables(Map<String, String> environmentVariables);
    }

    static final class BuilderImpl implements Builder {
        private Integer timeoutInSeconds;

        private Integer memoryInMB;

        private Boolean activeTracing;

        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryRunConfigInput model) {
            timeoutInSeconds(model.timeoutInSeconds);
            memoryInMB(model.memoryInMB);
            activeTracing(model.activeTracing);
            environmentVariables(model.environmentVariables);
        }

        public final Integer getTimeoutInSeconds() {
            return timeoutInSeconds;
        }

        public final void setTimeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final Integer getMemoryInMB() {
            return memoryInMB;
        }

        public final void setMemoryInMB(Integer memoryInMB) {
            this.memoryInMB = memoryInMB;
        }

        @Override
        public final Builder memoryInMB(Integer memoryInMB) {
            this.memoryInMB = memoryInMB;
            return this;
        }

        public final Boolean getActiveTracing() {
            return activeTracing;
        }

        public final void setActiveTracing(Boolean activeTracing) {
            this.activeTracing = activeTracing;
        }

        @Override
        public final Builder activeTracing(Boolean activeTracing) {
            this.activeTracing = activeTracing;
            return this;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return environmentVariables;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesMapCopier.copy(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesMapCopier.copy(environmentVariables);
            return this;
        }

        @Override
        public CanaryRunConfigInput build() {
            return new CanaryRunConfigInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
