/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains the status information about a canary run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanaryRunStatus implements SdkPojo, Serializable, ToCopyableBuilder<CanaryRunStatus.Builder, CanaryRunStatus> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(CanaryRunStatus::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReason").getter(getter(CanaryRunStatus::stateReason)).setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()).build();

    private static final SdkField<String> STATE_REASON_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReasonCode").getter(getter(CanaryRunStatus::stateReasonCodeAsString))
            .setter(setter(Builder::stateReasonCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReasonCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            STATE_REASON_FIELD, STATE_REASON_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String state;

    private final String stateReason;

    private final String stateReasonCode;

    private CanaryRunStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.stateReasonCode = builder.stateReasonCode;
    }

    /**
     * <p>
     * The current state of the run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CanaryRunState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the run.
     * @see CanaryRunState
     */
    public final CanaryRunState state() {
        return CanaryRunState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CanaryRunState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the run.
     * @see CanaryRunState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * If run of the canary failed, this field contains the reason for the error.
     * </p>
     * 
     * @return If run of the canary failed, this field contains the reason for the error.
     */
    public final String stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * If this value is <code>CANARY_FAILURE</code>, an exception occurred in the canary code. If this value is
     * <code>EXECUTION_FAILURE</code>, an exception occurred in CloudWatch Synthetics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateReasonCode}
     * will return {@link CanaryRunStateReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateReasonCodeAsString}.
     * </p>
     * 
     * @return If this value is <code>CANARY_FAILURE</code>, an exception occurred in the canary code. If this value is
     *         <code>EXECUTION_FAILURE</code>, an exception occurred in CloudWatch Synthetics.
     * @see CanaryRunStateReasonCode
     */
    public final CanaryRunStateReasonCode stateReasonCode() {
        return CanaryRunStateReasonCode.fromValue(stateReasonCode);
    }

    /**
     * <p>
     * If this value is <code>CANARY_FAILURE</code>, an exception occurred in the canary code. If this value is
     * <code>EXECUTION_FAILURE</code>, an exception occurred in CloudWatch Synthetics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateReasonCode}
     * will return {@link CanaryRunStateReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateReasonCodeAsString}.
     * </p>
     * 
     * @return If this value is <code>CANARY_FAILURE</code>, an exception occurred in the canary code. If this value is
     *         <code>EXECUTION_FAILURE</code>, an exception occurred in CloudWatch Synthetics.
     * @see CanaryRunStateReasonCode
     */
    public final String stateReasonCodeAsString() {
        return stateReasonCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(stateReasonCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryRunStatus)) {
            return false;
        }
        CanaryRunStatus other = (CanaryRunStatus) obj;
        return Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(stateReason(), other.stateReason())
                && Objects.equals(stateReasonCodeAsString(), other.stateReasonCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CanaryRunStatus").add("State", stateAsString()).add("StateReason", stateReason())
                .add("StateReasonCode", stateReasonCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "StateReasonCode":
            return Optional.ofNullable(clazz.cast(stateReasonCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        map.put("StateReasonCode", STATE_REASON_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CanaryRunStatus, T> g) {
        return obj -> g.apply((CanaryRunStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanaryRunStatus> {
        /**
         * <p>
         * The current state of the run.
         * </p>
         * 
         * @param state
         *        The current state of the run.
         * @see CanaryRunState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CanaryRunState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the run.
         * </p>
         * 
         * @param state
         *        The current state of the run.
         * @see CanaryRunState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CanaryRunState
         */
        Builder state(CanaryRunState state);

        /**
         * <p>
         * If run of the canary failed, this field contains the reason for the error.
         * </p>
         * 
         * @param stateReason
         *        If run of the canary failed, this field contains the reason for the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * If this value is <code>CANARY_FAILURE</code>, an exception occurred in the canary code. If this value is
         * <code>EXECUTION_FAILURE</code>, an exception occurred in CloudWatch Synthetics.
         * </p>
         * 
         * @param stateReasonCode
         *        If this value is <code>CANARY_FAILURE</code>, an exception occurred in the canary code. If this value
         *        is <code>EXECUTION_FAILURE</code>, an exception occurred in CloudWatch Synthetics.
         * @see CanaryRunStateReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CanaryRunStateReasonCode
         */
        Builder stateReasonCode(String stateReasonCode);

        /**
         * <p>
         * If this value is <code>CANARY_FAILURE</code>, an exception occurred in the canary code. If this value is
         * <code>EXECUTION_FAILURE</code>, an exception occurred in CloudWatch Synthetics.
         * </p>
         * 
         * @param stateReasonCode
         *        If this value is <code>CANARY_FAILURE</code>, an exception occurred in the canary code. If this value
         *        is <code>EXECUTION_FAILURE</code>, an exception occurred in CloudWatch Synthetics.
         * @see CanaryRunStateReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CanaryRunStateReasonCode
         */
        Builder stateReasonCode(CanaryRunStateReasonCode stateReasonCode);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private String stateReason;

        private String stateReasonCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryRunStatus model) {
            state(model.state);
            stateReason(model.stateReason);
            stateReasonCode(model.stateReasonCode);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CanaryRunState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateReason() {
            return stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final String getStateReasonCode() {
            return stateReasonCode;
        }

        public final void setStateReasonCode(String stateReasonCode) {
            this.stateReasonCode = stateReasonCode;
        }

        @Override
        public final Builder stateReasonCode(String stateReasonCode) {
            this.stateReasonCode = stateReasonCode;
            return this;
        }

        @Override
        public final Builder stateReasonCode(CanaryRunStateReasonCode stateReasonCode) {
            this.stateReasonCode(stateReasonCode == null ? null : stateReasonCode.toString());
            return this;
        }

        @Override
        public CanaryRunStatus build() {
            return new CanaryRunStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
